<?php
// This file is part of the Studyplan plugin for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Report
 * @package    local_treestudyplan
 * @copyright  2023 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once("../../config.php");

use local_treestudyplan\contextinfo;
use local_treestudyplan\local\helpers\formatter;
use local_treestudyplan\studyplanpage;

require_once($CFG->libdir.'/weblib.php');

require_login();

// Figure out the context (category or system, based on either category or context parameter).
$pageid = required_param('page', PARAM_INT); // Category id.
$PAGE->set_url("/local/treestudyplan/result-overview.php", ['page' => $pageid]);

$page = studyplanpage::find_by_id($pageid);
$studyplan = $page->studyplan();
$context = $studyplan->context();
$ci = new contextinfo($context);
$contextname = $ci->pathstr();

$firstperiod = optional_param('firstperiod', 0, PARAM_INT); // First period to show.
$lastperiod = optional_param('lastperiod', 0, PARAM_INT); // Last periode to show.

$PAGE->set_pagelayout('report');
$PAGE->set_title(get_string('studyplan_report', 'local_treestudyplan'));
$PAGE->set_heading(get_string('studyplan_report', 'local_treestudyplan'));

if (!has_capability('local/treestudyplan:viewuserreports', $context)) {
    throw new \moodle_exception("error:nostudyplanviewaccess", "local_treestudyplan", "", $contextname);
}

// Load page specific css.
$PAGE->requires->css(new moodle_url($CFG->wwwroot.'/local/treestudyplan/css/bootstrap-vue/bootstrap-vue.css'));
if ($CFG->debugdeveloper) {
    $PAGE->requires->css(new moodle_url($CFG->wwwroot.'/local/treestudyplan/styles.css'));
}

print $OUTPUT->header();
print $OUTPUT->render_from_template('local_treestudyplan/result_overview', [
    "studyplanid" => $studyplan->id(),
    "pageid" => $page->id(),
    "contextname" => formatter::format_string($contextname),
    "studyplanname" => formatter::format_string($studyplan->name()),
    "pagename" => formatter::format_string($page->fullname()),
    "firstperiod" => $firstperiod,
    "lastperiod" => $lastperiod,
]);

print $OUTPUT->footer();
