<?php
// This file is part of Moodle - http://moodle.org/.
//
// Moodle is free software: you can redistribute it and/or modify.
// it under the terms of the GNU General Public License as published by.
// the Free Software Foundation, either version 3 of the License, or.
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful, .
// but WITHOUT ANY WARRANTY; without even the implied warranty of.
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the.
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License.
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Local plugin Settings
 *
 * @package    local_treestudyplan
 * @copyright  2023 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

use local_treestudyplan\aggregator;
use core\context\system as context_system;

if ($hassiteconfig) {

    /**************************************
     *
     * Main studyplan settings
     *
     *************************************/

    // Create admin settings category.
    $ADMIN->add('courses', new admin_category('local_treestudyplan',
            get_string('pluginname', 'local_treestudyplan', null, true)));

    /**************************************
     *
     * Manage plans link (systemwide)
     *
     *************************************/

    $ADMIN->add('local_treestudyplan', new admin_externalpage(
        'local_treestudyplan_editplans',
        get_string('cfg_plans', 'local_treestudyplan', null, true),
        $CFG->wwwroot . '/local/treestudyplan/edit-plan.php'));

    // Settings page: Root nodes.
    $page = new admin_settingpage('local_treestudyplan_settings',
            get_string('settingspage', 'local_treestudyplan', null, true));


    // Features.
    $page->add(new admin_setting_heading('local_treestudyplan/feature_heading',
        get_string('setting_feature_heading', 'local_treestudyplan'),
        get_string('settingdesc_feature_heading', 'local_treestudyplan')
    ));

    $page->add(new admin_setting_configcheckbox('local_treestudyplan/enablecoach',
        get_string('setting_enablecoach', 'local_treestudyplan'),
        get_string('settingdesc_enablecoach', 'local_treestudyplan'),
        false,
    ));

    $page->add(new admin_setting_configcheckbox('local_treestudyplan/enableplansharing',
        get_string('setting_enableplansharing', 'local_treestudyplan'),
        get_string('settingdesc_enableplansharing', 'local_treestudyplan'),
        true,
    ));

    $page->add(new admin_setting_configcheckbox('local_treestudyplan/limitcourselist',
        get_string('setting_limitcourselist', 'local_treestudyplan'),
        get_string('settingdesc_limitcourselist', 'local_treestudyplan'),
        false,
    ));

    $page->add(new admin_setting_configcheckbox('local_treestudyplan/copystudylinesnewpage',
        get_string('setting_copystudylinesnewpage', 'local_treestudyplan'),
        get_string('settingdesc_copystudylinesnewpage', 'local_treestudyplan'),
        false,
    ));

    $page->add(new admin_setting_configcheckbox('local_treestudyplan/continueperiodnumberingnewpage',
        get_string('setting_continueperiodnumberingnewpage', 'local_treestudyplan'),
        get_string('settingdesc_continueperiodnumberingnewpage', 'local_treestudyplan'),
        false,
    ));

    // OUTCOME AGGREGATION SETTINGS.
    $aggregators = [];
    foreach (aggregator::list() as $a) {
        $aggregators[$a] = get_string("{$a}_aggregator_title", 'local_treestudyplan', null, true);
    }

    $page->add(new admin_setting_configselect('local_treestudyplan/aggregation_mode',
            get_string('setting_aggregation_mode', 'local_treestudyplan'),
            get_string('settingdesc_aggregation_mode', 'local_treestudyplan'),
            "core",
            $aggregators
        ));

    // DISPLAY COURSE INFO SETTINGS.
    $page->add(new admin_setting_heading('local_treestudyplan/display_heading',
        get_string('setting_display_heading', 'local_treestudyplan'),
        get_string('settingdesc_display_heading', 'local_treestudyplan')
    ));

    $page->add(new admin_setting_configcheckbox('local_treestudyplan/primary_nav_items',
        get_string('setting_primary_nav_items', 'local_treestudyplan'),
        get_string('settingdesc_primary_nav_items', 'local_treestudyplan'),
        true,
    ));

    $page->add(new admin_setting_configcheckbox('local_treestudyplan/primary_nav_combine',
        get_string('setting_primary_nav_combine', 'local_treestudyplan'),
        get_string('settingdesc_primary_nav_combine', 'local_treestudyplan'),
        false,
    ));

    $displayfields = [
                        "shortname" => get_string("shortname"),
                        "idnumber" => get_string("idnumber"),
                        "fullname" => get_string("fullname"),
                    ];
    $infofields = [
                        "" => get_string('none'),
                        "description" => get_string("description"),
                        "contacts" => get_string("teachers"),
                        "idnumber" => get_string("idnumber"),
                    ];
    $handler = \core_customfield\handler::get_handler('core_course', 'course');

    foreach ($handler->get_categories_with_fields() as $cat) {
        $catname = $cat->get_formatted_name();
        foreach ($cat->get_fields() as $field) {
            $visibility = $field->get_configdata_property("visibility");
            if ($visibility > 0) {
                // Only include fields that are visible to Teachers, or Everyone.
                $fieldname = $field->get_formatted_name();
                $fieldid = $field->get("shortname");
                $displayfields["customfield_".$fieldid] = $catname.": ".$fieldname;
                $infofields["customfield_".$fieldid] = $catname.": ".$fieldname;
            }
        }
    }
    $page->add(new admin_setting_configselect('local_treestudyplan/display_field',
            get_string('setting_display_field', 'local_treestudyplan'),
            get_string('settingdesc_display_field', 'local_treestudyplan'),
            "shortname",
            $displayfields
        ));

    $page->add(new admin_setting_configcheckbox('local_treestudyplan/courseprogressbar',
        get_string('setting_courseprogressbar', 'local_treestudyplan'),
        get_string('settingdesc_courseprogressbar', 'local_treestudyplan'),
        false,
    ));

    // Default image for study plans.
    $page->add(new admin_setting_configstoredfile('local_treestudyplan/defaulticon',
        get_string('setting_defaulticon', 'local_treestudyplan'),
        get_string('settingdesc_defaulticon', 'local_treestudyplan'),
        'defaulticon', 0,
        [
            'maxfiles' => 1,
            'accepted_types' => ['.jpg', '.png']]
    ));

    $page->add(new admin_setting_configcheckbox('local_treestudyplan/timelessperiods',
        get_string('setting_timelessperiods', 'local_treestudyplan'),
        get_string('settingdesc_timelessperiods', 'local_treestudyplan'),
        false,
    ));

    $page->add(new admin_setting_configcheckbox('local_treestudyplan/hivizdropslots',
        get_string('setting_hivizdropslots', 'local_treestudyplan'),
        get_string('settingdesc_hivizdropslots', 'local_treestudyplan'),
        false,
    ));

    $page->add(new admin_setting_configcheckbox('local_treestudyplan/toolboxleft',
        get_string('setting_toolboxleft', 'local_treestudyplan'),
        get_string('settingdesc_toolboxleft', 'local_treestudyplan'),
        true,
    ));
    $page->add(new admin_setting_configcheckbox('local_treestudyplan/toolboxcoursesonly',
        get_string('setting_toolboxcoursesonly', 'local_treestudyplan'),
        get_string('settingdesc_toolboxcoursesonly', 'local_treestudyplan'),
        false,
    ));

    $page->add(new admin_setting_configcheckbox('local_treestudyplan/showprevnextarrows',
        get_string('setting_showprevnextarrows', 'local_treestudyplan'),
        get_string('settingdesc_showprevnextarrows', 'local_treestudyplan'),
        true,
    ));

    // Info fields.
    $page->add(new admin_setting_heading('local_treestudyplan/infofields_heading',
        get_string('setting_infofields_heading', 'local_treestudyplan'),
        get_string('settingdesc_infofields_heading', 'local_treestudyplan')
    ));

    $positions = [  "above" => get_string('infofield_position_above', 'local_treestudyplan'),
                    "below" => get_string("infofield_position_below", 'local_treestudyplan'),
                ];

    for ($i = 1; $i <= 5; $i++) {
        $page->add(new admin_setting_configselect('local_treestudyplan/courseinfo'.$i.'_field',
            get_string('setting_infofield'.$i.'_field', 'local_treestudyplan'),
            get_string('settingdesc_infofield'.$i.'_field', 'local_treestudyplan'),
            "",
            $infofields
        ));
        $page->add(new admin_setting_configselect('local_treestudyplan/courseinfo'.$i.'_position',
            get_string('setting_infofield'.$i.'_position', 'local_treestudyplan'),
            get_string('settingdesc_infofield'.$i.'_position', 'local_treestudyplan'),
            "below",
            $positions
        ));
        $page->add(new admin_setting_configtextarea('local_treestudyplan/courseinfo'.$i.'_title',
            get_string('setting_infofield'.$i.'_title', 'local_treestudyplan'),
            get_string('settingdesc_infofield'.$i.'_title', 'local_treestudyplan'),
            "Information $i|en\nInformatie $i|nl"
        ));
    }

    // COMPETENCY AGGREGATON DEFAULTS.
    $page->add(new admin_setting_configselect('local_treestudyplan/competency_displayname',
        get_string('setting_competency_displayname', 'local_treestudyplan'),
        get_string('settingdesc_competency_displayname', 'local_treestudyplan'),
        "idnumber",
        ["shortname" => get_string("name", "core", ),
         "idnumber" => get_string("idnumber", "core", ),
         "description" => get_string("description", "core", )]
    ));

    $page->add(new admin_setting_configselect('local_treestudyplan/competency_detailfield',
        get_string('setting_competency_detailfield', 'local_treestudyplan'),
        get_string('settingdesc_competency_detailfield', 'local_treestudyplan'),
        "shortname",
        ["" => get_string("none", "core", ),
         "shortname" => get_string("name", "core", ),
         "idnumber" => get_string("idnumber", "core", ),
         "description" => get_string("description", "core", )]
    ));

    $page->add(new admin_setting_heading('local_treestudyplan/competency_aggregation_heading',
        get_string('setting_competency_heading', 'local_treestudyplan'),
        get_string('settingdesc_competency_heading', 'local_treestudyplan')
    ));

    $page->add(new admin_setting_configtext('local_treestudyplan/competency_thresh_completed',
        get_string('setting_competency_thresh_completed', 'local_treestudyplan'),
        get_string('settingdesc_competency_thresh_completed', 'local_treestudyplan'),
        "66",
        PARAM_INT
    ));

    $page->add(new admin_setting_configcheckbox('local_treestudyplan/competency_support_failed',
        get_string('setting_competency_support_failed', 'local_treestudyplan'),
        get_string('settingdesc_competency_support_failed', 'local_treestudyplan'),
        true,
    ));

    // BISTATE AGGREGATON DEFAULTS.
    $page->add(new admin_setting_heading('local_treestudyplan/bistate_aggregation_heading',
        get_string('setting_bistate_heading', 'local_treestudyplan'),
        get_string('settingdesc_bistate_heading', 'local_treestudyplan')
    ));

    $page->add(new admin_setting_configtext('local_treestudyplan/bistate_thresh_excellent',
        get_string('setting_bistate_thresh_excellent', 'local_treestudyplan'),
        get_string('settingdesc_bistate_thresh_excellent', 'local_treestudyplan'),
        "100",
        PARAM_INT
    ));

    $page->add(new admin_setting_configtext('local_treestudyplan/bistate_thresh_good',
        get_string('setting_bistate_thresh_good', 'local_treestudyplan'),
        get_string('settingdesc_bistate_thresh_good', 'local_treestudyplan'),
        "80",
        PARAM_INT
    ));

    $page->add(new admin_setting_configtext('local_treestudyplan/bistate_thresh_completed',
        get_string('setting_bistate_thresh_completed', 'local_treestudyplan'),
        get_string('settingdesc_bistate_thresh_completed', 'local_treestudyplan'),
        "66",
        PARAM_INT
    ));

    $page->add(new admin_setting_configcheckbox('local_treestudyplan/bistate_support_failed',
        get_string('setting_bistate_support_failed', 'local_treestudyplan'),
        get_string('settingdesc_bistate_support_failed', 'local_treestudyplan'),
        true,
    ));

    $page->add(new admin_setting_configcheckbox('local_treestudyplan/bistate_accept_pending_submitted',
        get_string('setting_bistate_accept_pending_submitted', 'local_treestudyplan'),
        get_string('settingdesc_bistate_accept_pending_submitted', 'local_treestudyplan'),
        false,
    ));

    // Add settings page to the admin settings category.
    $ADMIN->add('local_treestudyplan', $page);

    /**************************************
     *
     * Settings page: Cohort sync
     *
     *************************************/

    $pagecsync = new admin_settingpage('local_treestudyplan_settings_cohortsync',
        get_string('settingspage_csync', 'local_treestudyplan', null, true));

    // Description heading.
    $pagecsync->add(new admin_setting_heading('local_treestudyplan/csync_heading',
        get_string('setting_csync_heading', 'local_treestudyplan'),
        get_string('settingdesc_csync_heading', 'local_treestudyplan')
    ));

    // Enable/disable cohort sync.
    $pagecsync->add(new admin_setting_configcheckbox('local_treestudyplan/csync_enable',
        get_string('setting_csync_enable_field', 'local_treestudyplan'),
        get_string('settingdesc_csync_enable_field', 'local_treestudyplan'),
        false
    ));

    // Enable/disable autoremove.
    $pagecsync->add(new admin_setting_configcheckbox('local_treestudyplan/csync_autoremove',
        get_string('setting_csync_autoremove_field', 'local_treestudyplan'),
        get_string('settingdesc_csync_autoremove_field', 'local_treestudyplan'),
        true
    ));

    // Enable/disable remembering previously added cohort syncs so they're not automatically deleted.
    $pagecsync->add(new admin_setting_configcheckbox('local_treestudyplan/csync_remember_manual_csync',
        get_string('setting_csync_remember_manual_csync_field', 'local_treestudyplan'),
        get_string('settingdesc_csync_remember_manual_csync_field', 'local_treestudyplan'),
        true
    ));

    // Enable/disable group creation.
    $pagecsync->add(new admin_setting_configcheckbox('local_treestudyplan/csync_creategroup',
        get_string('setting_csync_creategroup_field', 'local_treestudyplan'),
        get_string('settingdesc_csync_creategroup_field', 'local_treestudyplan'),
        true
    ));

    // Sync users too yes/no?.
    $pagecsync->add(new admin_setting_configcheckbox('local_treestudyplan/csync_users',
        get_string('setting_csync_users_field', 'local_treestudyplan'),
        get_string('settingdesc_csync_users_field', 'local_treestudyplan'),
        true
    ));

    // Select csync enrol role.
    if (!during_initial_install()) {
        $options = get_default_enrol_roles(context_system::instance());
        $student = get_archetype_roles('student');
        $student = reset($student);
        $pagecsync->add(new admin_setting_configselect('local_treestudyplan/csync_roleid',
        get_string('setting_csync_role_field', 'local_treestudyplan'),
        get_string('settingdesc_csync_role_field', 'local_treestudyplan'),
        $student->id ?? null, $options));
    }

    // Add settings page2 to the admin settings category.
    $ADMIN->add('local_treestudyplan', $pagecsync);

    /**************************************
     *
     * Grade and scale interpretation
     *
     *************************************/
    $ADMIN->add('local_treestudyplan', new admin_externalpage(
        'local_treestudyplan_gradeconfig',
        get_string('cfg_grades', 'local_treestudyplan', null, true),
        $CFG->wwwroot . '/local/treestudyplan/cfg-grades.php'));

    /**************************************
     *
     * Manage mandatory studyplan shares
     *
     *************************************/
    if (get_config("local_treestudyplan", "enableplansharing")) {
        $ADMIN->add('local_treestudyplan', new admin_externalpage(
            'local_treestudyplan_manageshares',
            get_string('cfg_manageshares', 'local_treestudyplan', null, true),
            $CFG->wwwroot . '/local/treestudyplan/cfg-manageshares.php'));

        $ADMIN->add('local_treestudyplan', new admin_externalpage(
            'local_treestudyplan_uploadshares',
            get_string('cfg_uploadshares', 'local_treestudyplan', null, true),
            $CFG->wwwroot . '/local/treestudyplan/cfg-uploadshares.php'));
    }
}
