# Moodle studyplan plugin

Plugin to organize a curriculum into an easy to read graphical representation of courses and student progress therein.

The studyplan plugin extends Moodle with the ability to show students and teachers an overview of their curriculum and results therein.
By showing students an easy to read graphical overview of their progress over multiple courses, students are more in control of their own
learning process than by just listing results alone

## Installing
Install the plugin by adding the zip file manually to the installed plugins in your Moodle version

## Configuration post install

### Dynamic Navigation links
The studyplan plugin will automatically add links to the flat navigation bat used in Moodle 3.11 and below
However, Moodle 4.0-4.2 use a new "primary navigation" bar, and does not yet support customizing the primary navigation bar (it is a planned feature though)

Use the following workaround:
You can add custom primary menu items in **Site administration** -> **Appearance** -> **Theme settings**
That page contains an item called Custom menu items". Add the following into that area to custimize it

```Mijn studieplan|/local/treestudyplan/myreport.php||nl
Studieplannen|/local/treestudyplan/view-plan.php||nl
Studieplannen beheren|/local/treestudyplan/edit-plan.php||nl
My study plan|/local/treestudyplan/myreport.php||en
Study plans|/local/treestudyplan/view-plan.php||en
Manage Study plans|/local/treestudyplan/edit-plan.php||en
```

The studyplan plugin wil automatically hide the primary navigation items that are not applicable for the current user.

### Role configuration
While the studyplan management rights are added by default to the **manager** role, and students can always see the studyplans they are associated with, the faculty members' right to view the studyplans is not added to any default role. You should make a separate role for faculty that is allowed to view the study plans (or integrate it in an existing role), grant the roght *local/treestudyplan:viewuserreports* to that role, and assign the role to all users that should have this right in a given context.
The recommended roles below give an example of that.

(See **Advanced** -> **Roles and permissions** in the documentation for more details about the different roled)

#### Recommended roles
It is recommended to create the following new roles:
- **Studyplan Manager** (*studyplanmanager*)
  Context types: *System*, *Category*
  *Capabilities*
  - **Manage studyplans** (*local/treestudyplan:editstudyplan*)
- **Studyplan Viewer** (*studyplanviewer*)
  Context types: *System*, *Category*
  *Capabilities*
  - **View study plan of others** (*local/treestudyplan:viewuserreports*)

Then assign the role **studyplanmanager** in a specific category context, or the system context to all users who should be able to create and edit studyplans in that specific context
Assign the role **studyplanviewer** to all users who should be able to view the teacher view of the studyplan and view the specific results of users associated with that studyplan.

## Further Configuration
After installing the plugin you can find the main configuration in **Site administration** -> **Courses** -> **Studyplans**

## Documentation / User manual
After installing the plugin, the detailed user manual can be found under **Site administration** -> **Courses** -> **Studyplans** -> **Studyplan plugin documentation**
Alternatively, you can unpack this ZIP file and open the **doc/index.html** file.
(Note that viewing the html files directly will not five the optimal experience, since fontawesome tags and bootstrap styles will not be properly rendered)

## Development
To build a release zip, you can use the script **./build.sh**. This script calls grunt to build the javascript minified files where needed and creates a relase zip file with the current plugin version (as defined in *version.php*) in the directory **/build**


