define("local_treestudyplan/util/fitty",["exports"],(function(_exports){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0;var _default=(w=>{if(!w)return;const toArray=nl=>[].slice.call(nl),DrawState_IDLE=0,DrawState_DIRTY_CONTENT=1,DrawState_DIRTY_LAYOUT=2,DrawState_DIRTY=3;let fitties=[],redrawFrame=null;const requestRedraw="requestAnimationFrame"in w?function(){let options=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{sync:!1};w.cancelAnimationFrame(redrawFrame);const redrawFn=()=>redraw(fitties.filter((f=>f.dirty&&f.active)));if(options.sync)return redrawFn();redrawFrame=w.requestAnimationFrame(redrawFn)}:()=>{},redrawAll=type=>options=>{fitties.forEach((f=>f.dirty=type)),requestRedraw(options)},redraw=fitties=>{fitties.filter((f=>!f.styleComputed)).forEach((f=>{f.styleComputed=computeStyle(f)})),fitties.filter(shouldPreStyle).forEach(applyStyle);const fittiesToRedraw=fitties.filter(shouldRedraw);fittiesToRedraw.forEach(calculateStyles),fittiesToRedraw.forEach((f=>{applyStyle(f),markAsClean(f)})),fittiesToRedraw.forEach(dispatchFitEvent)},markAsClean=f=>f.dirty=DrawState_IDLE,calculateStyles=f=>{f.vertical?(f.availableHeight=f.element.parentNode.clientHeight,f.currentHeight=f.element.scrollHeight,f.previousFontSize=f.currentFontSize,f.currentFontSize=Math.min(Math.max(f.minSize,f.availableHeight/f.currentHeight*f.previousFontSize),f.maxSize)):(f.availableWidth=f.element.parentNode.clientWidth,f.currentWidth=f.element.scrollWidth,f.previousFontSize=f.currentFontSize,f.currentFontSize=Math.min(Math.max(f.minSize,f.availableWidth/f.currentWidth*f.previousFontSize),f.maxSize)),f.whiteSpace=f.multiLine&&f.currentFontSize===f.minSize?"normal":"nowrap"},shouldRedraw=f=>f.vertical?f.dirty!==DrawState_DIRTY_LAYOUT||f.dirty===DrawState_DIRTY_LAYOUT&&f.element.parentNode.clientHeight!==f.availableHeight:f.dirty!==DrawState_DIRTY_LAYOUT||f.dirty===DrawState_DIRTY_LAYOUT&&f.element.parentNode.clientWidth!==f.availableWidth,computeStyle=f=>{const style=w.getComputedStyle(f.element,null);return f.currentFontSize=parseFloat(style.getPropertyValue("font-size")),f.display=style.getPropertyValue("display"),f.whiteSpace=style.getPropertyValue("white-space"),!0},shouldPreStyle=f=>{let preStyle=!1;return!f.preStyleTestCompleted&&(/inline-/.test(f.display)||(preStyle=!0,f.display="inline-block"),"nowrap"!==f.whiteSpace&&(preStyle=!0,f.whiteSpace="nowrap"),f.preStyleTestCompleted=!0,preStyle)},applyStyle=f=>{f.element.style.whiteSpace=f.whiteSpace,f.element.style.display=f.display,f.element.style.fontSize=f.currentFontSize+"px"},dispatchFitEvent=f=>{f.element.dispatchEvent(new CustomEvent("fit",{detail:{oldValue:f.previousFontSize,newValue:f.currentFontSize,scaleFactor:f.currentFontSize/f.previousFontSize}}))},fit=(f,type)=>options=>{f.dirty=type,f.active&&requestRedraw(options)},destroy=f=>()=>{fitties=fitties.filter((_=>_.element!==f.element)),f.observeMutations&&f.observer.disconnect(),f.element.style.whiteSpace=f.originalStyle.whiteSpace,f.element.style.display=f.originalStyle.display,f.element.style.fontSize=f.originalStyle.fontSize},subscribe=f=>()=>{f.active||(f.active=!0,requestRedraw())},unsubscribe=f=>()=>f.active=!1,observeMutations=f=>{f.observeMutations&&(f.observer=new MutationObserver(fit(f,DrawState_DIRTY_CONTENT)),f.observer.observe(f.element,f.observeMutations))},defaultOptions={minSize:16,maxSize:512,multiLine:!0,vertical:!1,observeMutations:"MutationObserver"in w&&{subtree:!0,childList:!0,characterData:!0}};function fittyCreate(elements,options){const fittyOptions=Object.assign({},defaultOptions,options),publicFitties=elements.map((element=>{const f=Object.assign({},fittyOptions,{element:element,active:!0});return(f=>{f.originalStyle={whiteSpace:f.element.style.whiteSpace,display:f.element.style.display,fontSize:f.element.style.fontSize},observeMutations(f),f.newbie=!0,f.dirty=!0,fitties.push(f)})(f),{element:element,fit:fit(f,DrawState_DIRTY),unfreeze:subscribe(f),freeze:unsubscribe(f),unsubscribe:destroy(f)}}));return requestRedraw(),publicFitties}function fitty(target){let options=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};return"string"==typeof target?fittyCreate(toArray(document.querySelectorAll(target)),options):fittyCreate([target],options)[0]}let resizeDebounce=null;const onWindowResized=()=>{w.clearTimeout(resizeDebounce),resizeDebounce=w.setTimeout(redrawAll(DrawState_DIRTY_LAYOUT),fitty.observeWindowDelay)},events=["resize","orientationchange"];return Object.defineProperty(fitty,"observeWindow",{set:enabled=>{const method=(enabled?"add":"remove")+"EventListener";events.forEach((e=>{w[method](e,onWindowResized)}))}}),fitty.observeWindow=!0,fitty.observeWindowDelay=100,fitty.fitAll=redrawAll(DrawState_DIRTY),fitty})("undefined"==typeof window?null:window);return _exports.default=_default,_exports.default}));

//# sourceMappingURL=fitty.min.js.map