define("local_treestudyplan/util/mform-helper",["exports","core/ajax","core/fragment","core/templates","core/notification","./string-helper","./debugger"],(function(_exports,_ajax,_fragment,_templates,_notification,_stringHelper,_debugger){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_notification=_interopRequireDefault(_notification),_debugger=_interopRequireDefault(_debugger);var _default={install(Vue){let debug=new _debugger.default("treestudyplan-mform-helper"),strings=(0,_stringHelper.loadStrings)({mform:{save:"save@core",cancel:"cancel@core"}});Vue.component("mform",{props:{name:{type:String},params:{type:Object},title:{type:String,default:""},variant:{type:String,default:"primary"},type:{type:String,default:"link"}},data:()=>({content:"",loading:!0,uuid:void 0!==crypto.randomUUID?crypto.randomUUID():"10000000-1000-4000-8000-100000000000".replace(/[018]/g,(c=>(c^crypto.getRandomValues(new Uint8Array(1))[0]&15>>c/4).toString(16))),text:strings.mform,submitok:!1,observer:null,inputs:[],saving:!1}),computed:{},methods:{openForm(){this.$refs.editormodal.show()},onShown(){const self=this;debug.info(`Loading form "${self.name}" with params`,self.params),self.loading=!1,(0,_ajax.call)([{methodname:"local_treestudyplan_get_mform",args:{formname:self.name,params:JSON.stringify(self.params)}}])[0].then((data=>{const modalbody=self.$refs.editormodal.$refs.body;modalbody.style.scrollBehavior="smooth",new ResizeObserver(((entries,ro)=>{setTimeout((()=>{debug.info("Scrolling modal to top",modalbody),modalbody.scrollTo(0,0)}),100),ro.disconnect()})).observe(modalbody);const html=data.html;self.loading=!1;const js=(0,_fragment.processCollectedJavascript)(data.javascript);(0,_templates.replaceNodeContents)(self.$refs.content,html,js),self.initListenChanges()})).catch(_notification.default.exception)},onSave(bvModalEvent){const self=this;let form=this.$refs.content.getElementsByTagName("form")[0];form.dispatchEvent(new Event("save-form-state"));const formdata=new FormData(form),data=new URLSearchParams(formdata).toString();this.checkSave()&&(bvModalEvent.preventDefault(),this.saving=!0,(0,_ajax.call)([{methodname:"local_treestudyplan_submit_mform",args:{formname:self.name,params:JSON.stringify(self.params),formdata:data}}])[0].then((response=>{const updatedplan=JSON.parse(response.data);self.$nextTick((()=>{debug.info("Attempting hide"),self.$refs.editormodal.hide()})),self.saving=!1,self.$emit("saved",updatedplan,formdata)})).catch(_notification.default.exception).catch((()=>{self.saving=!1})))},checkSave(){let canSave=!0;return this.inputs.forEach((el=>{el.focus(),el.blur(),el.classList.contains("is-invalid")&&(canSave=!1)}),this),this.submitok=canSave,canSave},initListenChanges(){const content=this.$refs.content;this.inputs=content.querySelectorAll("input.form-control"),setTimeout(this.checkSave,100),this.observer&&this.observer.disconnect(),this.observer=new MutationObserver((mutationList=>{for(const mix in mutationList){const mutation=mutationList[mix];"attributes"===mutation.type&&"class"===mutation.attributeName&&this.checkSave()}})),this.inputs.forEach((el=>{this.observer.observe(el,{attributes:!0})}),this)}},unmount(){this.observer&&this.observer.disconnect()},template:'\n            <span class=\'mform-container\'>\n                <b-button :variant="variant" v-if=\'type == "button"\' @click.prevent=\'openForm\'\n                    ><slot><i class=\'fa fa-gear\'></i></slot></b-button>\n                <a variant="variant" v-else href=\'#\' @click.prevent=\'openForm\'\n                    ><slot><i class=\'fa fa-gear\'></i></slot></a>\n                <b-modal\n                    ref="editormodal"\n                    scrollable\n                    centered\n                    size="xl"\n                    :id="\'modal-\'+uuid"\n                    @shown="onShown"\n                    @ok="onSave"\n                    :ok-disabled="!submitok"\n                    :title="title"\n                    ><div :class="\'s-mform-content\'" ref="content"\n                        ><div class="d-flex justify-content-center mb-3"\n                            ><b-spinner variant="primary"></b-spinner\n                        ></div\n                    ></div>\n                    <template #modal-ok>\n                        <span v-if="!saving">{{ text.save }}</span>\n                        <span v-else class=\'spinner-border spinner-border-sm\'><span class=\'sr-only\'>Saving...</span></span>\n                    </template>\n                </b-modal>\n            </span>\n            '})}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=mform-helper.min.js.map