/* eslint no-unused-vars: warn */
/* eslint max-len: ["error", { "code": 160 }] */
/* eslint capitalized-comments: "off" */
/* eslint-env es6*/

import {toPx} from "./css-calc";
import fitty from "./fitty";

export default {
    install(Vue/* ,options */) {
        Vue.component('fittext', {
        props: {
            maxsize: {
                type: String,
                'default': "512px",
            },
            minsize: {
                type: String,
                'default': "10px",
            },
            vertical: Boolean,
            singleline: Boolean,
            dynamic: Boolean,
        },
        data() {
            return {
                resizeObserver: null,
                mutationObserver: null,
            };
        },
        computed: {
            rootStyle() {
                if (this.vertical) {
                    return `height: 100%;`;
                } else {
                    return `width: 100%;`;
                }
            }
        },
        methods: {
        },
        mounted() {
            const self = this;
            // If the content could change after initial presentation,
            // Use the fitty method. It is slightly worse on multiline horizontal text,
            // but better supports content that can change later on.
            const elem = self.$refs.text;
            fitty(elem,
                {
                minSize: toPx(elem, self.minsize),
                maxSize: toPx(elem, self.maxsize),
                vertical: self.vertical,
                multiline: !self.singleline,
            });
        },
        unmounted() {
            if (this.mutationObserver) {
                this.mutationObserver.disconnect();
            }
            if (this.resizeObserver) {
                this.resizeObserver.disconnect();
            }
        },
        template: `
        <div class='q-fittext' ref='container' :style="rootStyle + ';min-height:0;min-width:0;'">
            <span :style="'display:block; white-space:'+ ((singleline)?'nowrap':'normal')+';' + rootStyle" class='q-fittext-text' ref='text'><slot></slot>
            </span
        ></div>
        `,
        });
    },
};