/**
 * Convert a text field into an integer only text field
 * @param {string} id The Id of the form field
 * @param {bool} unsigned Allow only unsigned values
 * @param {bool} nonzero Do not allow zero values
 */
export function textInteger(id, unsigned = false, nonzero = false) {
    const element = document.getElementById(id);

    if (element) {
        element.addEventListener("input", () => {
            var val = element.value;
            if (val != '') {
                if ((isNaN(val) && !(!unsigned && val == '-')) || (unsigned && val < 0) || (nonzero && val == 0)) {
                    // Set input value empty
                    if (unsigned) {
                        element.value = val.replace(/[^0-9]/g, '');
                        if (nonzero && val == 0) {
                            element.value = '';
                        }
                    } else {
                        element.value = val.replace(/[^0-9-]/g, '').replace(/(.{1})(-)/g, '$1');
                    }
                    return false;
                } else {
                    return true;
                }
            }
            return null;
        });
    }
}