<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Displays the form and processes the form submission.
 *
 * @package    local_treestudyplan
 * @copyright  2025 P.M. Kuipers
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once("../../config.php");
require_once($CFG->libdir . '/adminlib.php');
require_once($CFG->libdir . '/csvlib.class.php');

use local_treestudyplan\form\uploadshares_form;
use local_treestudyplan\local\tools\uploadshares_processor;
use local_treestudyplan\local\tools\uploadshares_tracker;
use core\context\system as context_system;

// Globals.
global $CFG, $OUTPUT, $USER, $SITE, $PAGE;

// Ensure only administrators have access.
$homeurl = new moodle_url('/');
require_login();
if (!is_siteadmin()) {
    redirect($homeurl, get_string('adminonly', 'badges', 5));
}

// URL Parameters.
// There are none.

// Heading ==========================================================.

$title = get_string('uploadshares', 'local_treestudyplan');
$heading = get_string('uploadshares', 'local_treestudyplan');
$url = new moodle_url('/local/treestudyplan/cfg-uploadshares.php');
// Check if user has capability to manage this.
$systemcontext = context_system::instance();
require_capability('local/treestudyplan:manageshares', $systemcontext);


admin_externalpage_setup('local_treestudyplan_uploadshares'); // Sets the navbar & expands navmenu.

// Set up the form.
$form = new uploadshares_form(null, ['fromdefault' => '']);
if ($form->is_cancelled()) {
    redirect($homeurl);
}

echo $OUTPUT->header();

// Display or process the form.
if ($data = $form->get_data()) {
    // Process the CSV file.
    $importid = csv_import_reader::get_new_iid('local_treestudyplan_uploadshares');
    $cir = new csv_import_reader($importid, 'local_treestudyplan_uploadshares');
    $content = $form->get_file_content('csvfile');
    $readcount = $cir->load_csv_content($content, $data->encoding, $data->delimiter_name);
    unset($content);
    if ($readcount === false) {
        throw new \moodle_exception(get_string('csvfileerror', 'tool_uploadcourse', $url . " " . $cir->get_error()));
    } else if ($readcount == 0) {
        throw new \moodle_exception(get_string('csvemptyfile', 'error', $url . " " . $cir->get_error()));
    }

    // We've got a live file with some entries, so process it.
    $processor = new uploadshares_processor($cir);
    echo $OUTPUT->heading(get_string('uploadshares_results', 'local_treestudyplan'));
    $processor->execute(new uploadshares_tracker(uploadshares_tracker::OUTPUT_HTML));

    echo $OUTPUT->continue_button($url);
} else {
    // Display the form.
    echo $OUTPUT->heading($heading);
    $form->display();
    echo $OUTPUT->footer();
    die();
}

// Footer.
echo $OUTPUT->footer();
