<?php
// This file is part of the Studyplan plugin for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Form to edit invitations to view the user's studyplans
 * @package    local_treestudyplan
 * @copyright  2025 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_treestudyplan\form;

use local_treestudyplan\shareservice;

use core\context\system as context_system;

defined('MOODLE_INTERNAL') || die();
require_once("$CFG->libdir/formslib.php");

/**
 * Form to edit invitations to view the user's studyplans
 */
class selectuser_form extends \moodleform {
    // Add elements to form.

    /** @var string */
    protected $label;

    /**
     * Create the form while providing the correct defaults for our type of forms
     * @param string $label Label for this form
     */
    public function __construct($label = null) {
        if (isset($label)) {
            $this->label = $label;
        } else {
            $this->label = get_string('selectauser', 'core_grades');
        }
        parent::__construct();
    }

    /**
     * Setup form
     */
    public function definition() {
        global $CFG;
        $context = context_system::instance();
        $mform = $this->_form; // Don't forget the underscore!

        $options = [
            'ajax' => 'local_treestudyplan/form-user-selector',
            'multiple' => false,
            'perpage' => $CFG->maxusersperpage,
            'userfields' => implode(',', \core_user\fields::get_identity_fields($context, true)),
            'valuehtmlcallback' => function($value) {
                global $DB, $OUTPUT;
                $user = $DB->get_record('user', ['id' => (int)$value], '*', IGNORE_MISSING);
                $details = shareservice::get_user_details($user);
                return $OUTPUT->render_from_template(
                    'local_treestudyplan/form/form-user-selector-suggestion', $details);
            },
        ];
        $mform->addElement('autocomplete', 'userid', $this->label, [], $options);
        $mform->disable_form_change_checker();
    }

    /**
     * Set the initialiy selected user
     * @param mixed $user User record of user to initially show
     * @return void
     */
    public function set_selected_user($user) {
        $this->set_data(["userid" => $user->id]);
    }

    /**
     * Custom validation should be added here.
     * @param array $data Supplied user data
     * @param array $files Any uploaded files
     * @return array validation data
     */
    public function validation($data, $files) {
        return [];
    }

    /**
     * Get supplied user data
     * @return object The supplied data
     */
    public function get_data() {
        $data = parent::get_data();
        return $data;
    }
}
