<?php
// This file is part of the Studyplan plugin for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * No file description
 * @package    local_treestudyplan
 * @copyright  2023 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_treestudyplan\form;
use MoodleQuickForm_text;
use MoodleQuickForm;

defined('MOODLE_INTERNAL') || die();
global $CFG;
require_once($CFG->libdir . "/form/text.php");

/**
 * Class to handle integer only form field.
 */
class text_integer extends MoodleQuickForm_text {
    /**
     * Accepts a renderer
     *
     * @param object $renderer An HTML_QuickForm_Renderer object
     * @param bool $required Whether an element is required
     * @param string $error An error message associated with an element
     */
    public function accept(&$renderer, $required = false, $error = null) {
        global $OUTPUT;
        $elementname = $this->getName();
        // Make sure the element has an id.
        $this->_generateId();
        $advanced = isset($renderer->_advancedElements[$elementname]);
        $elementcontext = $this->export_for_template($OUTPUT);

        $helpbutton = '';
        if (method_exists($this, 'getHelpButton')) {
            $helpbutton = $this->getHelpButton();
        }
        $label = $this->getLabel();

        $unsigned = (isset($this->_attributes['unsigned']) && $this->_attributes['unsigned']);
        $nonzero = (isset($this->_attributes['nonzero']) && $this->_attributes['nonzero']);
        $context = [
                'element' => $elementcontext,
                'label' => $label,
                'unsigned' => ($unsigned) ? true : false ,
                'nonzero' => ($nonzero) ? true : false ,
                'required' => $required,
                'advanced' => $advanced,
                'helpbutton' => $helpbutton,
                'error' => $error,
        ];
        $html = $OUTPUT->render_from_template('local_treestudyplan/form/element_text_integer', $context);
        if ($renderer->_inGroup) {
            $this->_groupElementTemplate = $html;
        }
        if (($renderer->_inGroup) && !empty($renderer->_groupElementTemplate)) {
            $renderer->_groupElementTemplate = $html;
        } else if (!isset($renderer->_templates[$elementname])) {
            $renderer->_templates[$elementname] = $html;
        }

        if (in_array($elementname, $renderer->_stopFieldsetElements) && $renderer->_fieldsetsOpen > 0) {
            $renderer->_html .= $renderer->_closeFieldsetTemplate;
            $renderer->_fieldsetsOpen--;
        }
        $renderer->_html .= $html;
    }

    /**
     * Register the element
     */
    public static function register() {
        global $CFG;
        MoodleQuickForm::registerElementType(
            // The custom element is named `course_competency_rule`.
            // This is the element name used in the `addElement()` function.
            'text_integer',

            // This is where it's definition is defined.
            // This does not currently support class auto-loading.
            "$CFG->dirroot/local/treestudyplan/classes/form/text_integer.php",

            // The class name of the element.
            'local_treestudyplan\form\text_integer'
        );
    }
}
