define("local_treestudyplan/page-result-overview",["exports","core/ajax","core/notification","./vue/vue","./util/debugger","./util/string-helper","./studyplan-report-components","./report-viewer-components","./modedit-modal","./portal-vue/portal-vue.esm","./bootstrap-vue/bootstrap-vue"],(function(_exports,_ajax,_notification,_vue,_debugger,_stringHelper,_studyplanReportComponents,_reportViewerComponents,_modeditModal,_portalVue,_bootstrapVue){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.init=function(selector,studyplanid,pageid,contextname,studyplanname,pagename,firstperiod,lastperiod){if(void 0===pageid||!Number.isInteger(Number(pageid))||void 0===studyplanid||!Number.isInteger(Number(studyplanid)))return void debug.error("Error: studyplan id and page id not provided as integer numbers to script.",studyplanid,pageid,firstperiod,lastperiod);studyplanid=Number(studyplanid),pageid=Number(pageid);new _vue.default({el:selector,data:{structure:null,studyplan:null,page:null,text:strings.studyplanReport,contextname:(0,_stringHelper.decodeHtml)(contextname),studyplanname:(0,_stringHelper.decodeHtml)(studyplanname),pagename:(0,_stringHelper.decodeHtml)(pagename)},created(){this.loadStructure(pageid,firstperiod,lastperiod)},methods:{loadStructure(pageid,firstperiod,lastperiod){const self=this;this.structure=null,(0,_ajax.call)([{methodname:"local_treestudyplan_get_report_structure",args:{pageid:pageid,firstperiod:firstperiod,lastperiod:lastperiod}}])[0].then((response=>{self.structure=response,self.studyplan=response.studyplan,self.page=response.page})).catch(_notification.default.exception)},selectedPage(e){debug.info("SelectedPage",e);const pageid=e.target.value;this.loadStructure(pageid)},selectedFirstPeriod(e){debug.info("selectedFirstPeriod",e);let f=e.target.value,l=this.structure.lastperiod;l<f&&(l=f),this.loadStructure(this.page.id,f,l)},selectedLastPeriod(e){debug.info("selectedLastPeriod",e);let f=this.structure.firstperiod,l=e.target.value;l<f&&(l=f),this.loadStructure(this.page.id,f,l)}},template:"\n        <div class=\"local_treestudyplan_result_overview\">\n            <h3><b><span v-html=\"contextname\"></span></b> / <span v-html=\"studyplanname\"></span></h3>\n            <h4 v-if=\"pagename != studyplanname\"><span v-html=\"pagename\"></span></h4>\n            <div class='vue-loader' v-if='!structure'>\n                <div class='spinner-border text-primary' role='status'>\n                    <span class='sr-only'>Loading...</span>\n                </div>\n            </div>\n            <template v-else>\n                <div class='container q-pageperiodselection'>\n                    <div class='row'>\n                        <div class='col-sm-2 q-label'>{{text.page}}</div>\n                        <div class='col-sm-6'>\n                            <select class='custom-select' :value='page.id' @change='selectedPage'>\n                                <template v-if='studyplan'>\n                                    <option v-for='p in studyplan.pages'\n                                        :key='p.id'\n                                        :value='p.id'\n                                        :selected='(page.id == p.id) ? true : false'\n                                        ><span v-html=\"p.display.fullname\"></span></option>\n                                </template>\n                                <option v-else disabled>{{text.loading}}</option>\n                            </select>\n                        </div>\n                    </div>\n                    <div class='row'>\n                        <div class='col-sm-2 q-label' >{{text.period}} ({{text.from}} / {{text.to}})</div>\n                        <div class='col-sm-2'>\n                            <select class='custom-select' @change='selectedFirstPeriod'>\n                                <template v-if='page'>\n                                    <option v-for='p in page.perioddesc'\n                                        :key='p.id'\n                                        :value='p.period'\n                                        :selected='(structure.firstperiod == p.period) ? true : false'\n                                        ><span v-html=\"p.display.fullname\"></span></option>\n                                </template>\n                                <option v-else disabled>{{text.loading}}</option>\n                            </select>\n                        </div>\n                        <div class='col-sm-2 '>\n                            <select class='custom-select' @change='selectedLastPeriod'>\n                                <template v-if='page'>\n                                    <template v-for='p in page.perioddesc'>\n                                        <option v-if='p.period >= structure.firstperiod'\n                                            :key='p.id'\n                                            :value='p.period'\n                                            :selected='(structure.lastperiod == p.period) ? true : false'\n                                            ><span v-html=\"p.display.fullname\"></span></option>\n                                    </template>\n                                </template>\n                                <option v-else disabled>{{text.loading}}</option>\n                            </select>\n                        </div>\n                    </div>\n                </div>\n                <q-studyplanreport :structure='structure' ></q-studyplanreport>\n            </template>\n        </div>"})},_notification=_interopRequireDefault(_notification),_vue=_interopRequireDefault(_vue),_debugger=_interopRequireDefault(_debugger),_studyplanReportComponents=_interopRequireDefault(_studyplanReportComponents),_reportViewerComponents=_interopRequireDefault(_reportViewerComponents),_modeditModal=_interopRequireDefault(_modeditModal),_portalVue=_interopRequireDefault(_portalVue),_bootstrapVue=_interopRequireDefault(_bootstrapVue),_vue.default.use(_studyplanReportComponents.default),_vue.default.use(_reportViewerComponents.default),_vue.default.use(_modeditModal.default),_vue.default.use(_portalVue.default),_vue.default.use(_bootstrapVue.default);let debug=new _debugger.default("treestudyplanviewer"),strings=(0,_stringHelper.loadStrings)({studyplanReport:{studyplan:"studyplan",page:"studyplanpage",periods:"periods",period:"period",loading:"loading@core",all:"all@core",from:"from@core",to:"to@core"}})}));

//# sourceMappingURL=page-result-overview.min.js.map