define("local_treestudyplan/simpleline/simpleline",["exports","../util/css-calc"],(function(_exports,_cssCalc){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.SimpleLine=void 0;const specsCopy=(to,from)=>{for(const ix in to)from.hasOwnProperty(ix)&&("object"==typeof to[ix]&&"object"==typeof from[ix]?Array.isArray(to[ix])&&Array.isArray(from[ix])?to[ix]=Array.from(from[ix]):specsCopy(to[ix],from[ix]):to[ix]=from[ix])},debounce=(func,delay)=>{let timer;return function(){for(var _len=arguments.length,args=new Array(_len),_key=0;_key<_len;_key++)args[_key]=arguments[_key];const context=this;clearTimeout(timer),timer=setTimeout((()=>{func.apply(context,args)}),delay)}},getElementPosition=(el,reference)=>{if(!(el&&el instanceof HTMLElement))return{x:0,y:0};if(reference&&reference instanceof HTMLElement||(reference=document.querySelector("body")),el.offsetParent===reference)return{x:el.offsetLeft,y:el.offsetTop};{const elR=el.getBoundingClientRect(),refR=reference.getBoundingClientRect();return{x:elR.left-refR.left,y:elR.top-refR.top}}};class SimpleLine{static idCounter=0;constructor(start,end,config){if(this.svg=null,this.id=SimpleLine.idCounter++,this.setConfig(config),start instanceof HTMLElement)this.start=start;else{if(!("string"==typeof start||this.start instanceof String))return void console.error("Start element not string or dom element",start);if(this.startSelector=start,this.start=document.querySelector(start),!(this.start instanceof HTMLElement))return void console.error("Cannot find start element:",start)}if(end instanceof HTMLElement)this.end=end;else{if(!("string"==typeof end||this.end instanceof String))return void console.error("End element not string or dom element",start);if(this.endSelector=end,this.end=document.querySelector(end),!(this.end instanceof HTMLElement))return void console.error("Cannot find end element:",end)}this.resizeObserver=new ResizeObserver(debounce((()=>{this.update()}),20)),this.resizeObserver.observe(this.start),this.resizeObserver.observe(this.end),this.mutationObserver=new MutationObserver((function(mutationsList){mutationsList.forEach((function(mutation){mutation.removedNodes.forEach((function(removedNode){this&&(removedNode!=this.start&&removedNode!=this.end||(console.warning("Element removed",removedNode),this.remove()))}))}))})),this.mutationObserver.observe(this.start.parentElement,{subtree:!1,childList:!0}),this.mutationObserver.observe(this.end.parentElement,{subtree:!1,childList:!0}),this.positionCheck(),this.specs.autorefresh>0&&(this.refreshTimer=setInterval((()=>{this.positionCheck()}),this.specs.autorefresh)),this.active=!0,this.update()}setConfig(config){this.specs||(this.specs={autorefresh:10,class:"",color:"",anchors:{start:["middle","right"],end:["middle","left"]},gravity:{start:1,end:1},stroke:"4px"}),config&&"object"==typeof config&&specsCopy(this.specs,config),this.svg&&(clearInterval(this.refreshTimer),this.specs.autorefresh>0&&(this.refreshTimer=setInterval((()=>{this.positionCheck()}),this.specs.autorefresh)),this.update())}get cssClass(){return this.specs.class}set cssClass(cssClass){this.specs.class=cssClass,this.update()}positionCheck(){const startPos={x:this.start.offsetLeft,y:this.start.offsetTop},endPos={x:this.end.offsetLeft,y:this.end.offsetTop};let needUpdate=!1;this.startPos&&(needUpdate=needUpdate||this.startPos.x!=startPos.x||this.startPos.y!=startPos.y),this.startPos=startPos,this.endPos&&(needUpdate=needUpdate||this.endPos.x!=endPos.x||this.endPos.y!=endPos.y),this.endPos=endPos,needUpdate&&this.update()}getContainer(){let container=this.start.offsetParent;return container||("fixed"==getComputedStyle(this.start).position?container=document.querySelector("body"):console.error("Start element has no offsetParent. likely ")),container}getAnchorPoint(anchor){let x,dirX,y,dirY,el=this.start;return"start"!=anchor&&(anchor="end",el=this.end),this.specs.anchors[anchor].includes("left")?(x=0,dirX=-1):this.specs.anchors[anchor].includes("right")?(x=el.offsetWidth-1,dirX=1):(x=el.offsetWidth/2,dirX=0),this.specs.anchors[anchor].includes("top")?(y=0,dirY=-1):this.specs.anchors[anchor].includes("bottom")?(y=el.offsetHeight-1,dirY=1):(y=el.offsetHeight/2,dirY=0),{x:x,y:y,dir:{x:dirX,y:dirY}}}svgDefs(){const defs=document.createElementNS("http://www.w3.org/2000/svg","defs"),marker=document.createElementNS("http://www.w3.org/2000/svg","marker");marker.setAttribute("id",`simpleline-${this.id}-arrow`),marker.setAttribute("markerUnits","strokeWidth"),marker.setAttribute("viewBox","-8 -8 16 16"),marker.setAttribute("orient","auto"),marker.setAttribute("markerWidth","4"),marker.setAttribute("markerHeight","4"),defs.appendChild(marker);const polygon=document.createElementNS("http://www.w3.org/2000/svg","polygon");return polygon.setAttribute("fill","currentColor"),polygon.setAttribute("points","-8,-8 8,0 -8,8 -5,0"),marker.append(polygon),defs}update(){if(!this.active)return;const container=this.getContainer();if(!container)return;this.svg&&this.svg instanceof SVGElement?container!==this.svg.offsetParent&&container.appendChild(this.svg):(this.svg=document.createElementNS("http://www.w3.org/2000/svg","svg"),this.svg.setAttribute("id",`simpleline-${this.id}`),this.svg.setAttribute("class",`simpleline ${this.specs.class}`),this.svg.style.position="absolute",this.svg.style.pointerEvents="none",container.appendChild(this.svg),this.svg.appendChild(this.svgDefs()));const startAnchor=this.getAnchorPoint("start"),endAnchor=this.getAnchorPoint("end"),strokeWpx=(0,_cssCalc.toPx)(this.svg,this.specs.stroke);endAnchor.x+=endAnchor.dir.x*strokeWpx*1.5,endAnchor.y+=endAnchor.dir.y*strokeWpx*1.5;const elStartPos=getElementPosition(this.start,container),elEndPos=getElementPosition(this.end,container),w=Math.max(elStartPos.x+startAnchor.x,elEndPos.x+endAnchor.x)-Math.min(elStartPos.x+startAnchor.x,elEndPos.x+endAnchor.x),h=Math.max(elStartPos.y+startAnchor.y,elEndPos.y+endAnchor.y)-Math.min(elStartPos.y+startAnchor.y,elEndPos.y+endAnchor.y),weight=Math.sqrt(h*h+w*w)/2,cStartPos={x:elStartPos.x+startAnchor.x,y:elStartPos.y+startAnchor.y,dirx:elStartPos.x+startAnchor.x+startAnchor.dir.x*this.specs.gravity.start*weight,diry:elStartPos.y+startAnchor.y+startAnchor.dir.y*this.specs.gravity.start*weight},cEndPos={x:elEndPos.x+endAnchor.x,y:elEndPos.y+endAnchor.y,dirx:elEndPos.x+endAnchor.x+endAnchor.dir.x*this.specs.gravity.end*weight,diry:elEndPos.y+endAnchor.y+endAnchor.dir.y*this.specs.gravity.end*weight},margin=isNaN(this.specs.stroke)?25:5*this.specs.stroke,bounds_x=Math.min(cStartPos.x,cEndPos.x,cStartPos.dirx,cEndPos.dirx)-margin,bounds_y=Math.min(cStartPos.y,cEndPos.y,cStartPos.diry,cEndPos.diry)-margin,bounds_w=Math.max(cStartPos.x,cEndPos.x,cStartPos.dirx,cEndPos.dirx)-Math.min(cStartPos.x,cEndPos.x,cStartPos.dirx,cEndPos.dirx)+2*margin,bounds_h=Math.max(cStartPos.y,cEndPos.y,cStartPos.diry,cEndPos.diry)-Math.min(cStartPos.y,cEndPos.y,cStartPos.diry,cEndPos.diry)+2*margin,startPos_x=cStartPos.x-bounds_x,startPos_y=cStartPos.y-bounds_y,startPos_dirx=cStartPos.dirx-bounds_x,startPos_diry=cStartPos.diry-bounds_y,endPos_x=cEndPos.x-bounds_x,endPos_y=cEndPos.y-bounds_y,endPos_dirx=cEndPos.dirx-bounds_x,endPos_diry=cEndPos.diry-bounds_y;this.svg.setAttribute("viewBox",`0 0 ${bounds_w}, ${bounds_h}`),this.svg.setAttribute("width",`${bounds_w}px`),this.svg.setAttribute("height",`${bounds_h}px`),this.svg.style.color=this.specs.color,this.svg.style.left=`${bounds_x}px`,this.svg.style.top=`${bounds_y}px`,this.svg.style.width=`${bounds_w}px`,this.svg.style.height=`${bounds_h}px`,this.line||(this.line=document.createElementNS("http://www.w3.org/2000/svg","path"),this.line.setAttribute("marker-end",`url(#simpleline-${this.id}-arrow)`),this.svg.appendChild(this.line));let strokeWidth=this.specs.stroke;isNaN(strokeWidth)||0==strokeWidth||(strokeWidth=`${strokeWidth}px`),this.line.style.stroke="currentColor",this.line.style.fill="none",this.line.style.strokeWidth=strokeWidth,this.line.setAttribute("d",`M ${startPos_x} ${startPos_y}\n             C ${startPos_dirx} ${startPos_diry}, ${endPos_dirx} ${endPos_diry}, ${endPos_x} ${endPos_y}`)}remove(){this.svg.remove(),this.svg=null,this.line=null,clearInterval(this.refreshTimer),this.resizeObserver.disconnect(),this.mutationObserver.disconnect(),this.active=!1}}_exports.SimpleLine=SimpleLine}));

//# sourceMappingURL=simpleline.min.js.map