define("local_treestudyplan/treestudyplan-components",["exports","./util/string-helper","./util/date-helper","./util/fittext-vue","./util/settings"],(function(_exports,_stringHelper,_dateHelper,_fittextVue,_settings){var obj;Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_fittextVue=(obj=_fittextVue)&&obj.__esModule?obj:{default:obj};var _default={install(Vue){Vue.use(_fittextVue.default);let strings=(0,_stringHelper.loadStrings)({studyplancard:{open:"open",noenddate:"noenddate",idnumber:"studyplan_idnumber",description:"studyplan_description",completed:"completed",details:"studyplan_details",suspended:"suspended"},details:{details:"studyplan_details"},extrafields:{show:"show@core"},prevnext:{prev:"prev@core",previous:"previous@core",next:"next@core",select:"selectanoptions@core"}});const ItemEventBus=new Vue;Vue.component("s-studyplan-card",{props:{value:{type:Object},open:{type:Boolean},ignoresuspend:{type:Boolean,default:!1}},data:()=>({text:strings.studyplancard}),computed:{timeless(){const plan=this.value;return!(plan.pages&&0!=plan.pages.length&&!plan.pages[0].timeless)},timing(){return(0,_dateHelper.studyplanTiming)(this.value)},dates(){const dates=(0,_dateHelper.studyplanDates)(this.value);return{start:(0,_dateHelper.formatDate)(dates.start),end:dates.end?(0,_dateHelper.formatDate)(dates.end):this.text.noenddate}},suspended(){return this.value.suspended&&!this.ignoresuspend}},methods:{onOpenClick(e){this.$emit("open",e)}},template:"\n            <b-card\n                :class=\"'s-studyplan-card timing-' + timing + (suspended?' s-suspended':'')\"\n            >\n                <template #header></template>\n                <div class='s-studyplan-card-content'>\n                    <div class='s-studyplan-card-icon'><img :src='value.icon'></div>\n                    <div class='s-studyplan-card-info'>\n                        <div class='s-studyplan-card-titlebar'>\n                            <b-card-title>\n                                <a class='title' v-if='open && !suspended'\n                                    href='#' @click.prevent='onOpenClick($event)'><span v-html=\"value.display.name\"></span></a>\n                                <template v-else><span v-html=\"value.display.name\"></span></template>\n                                <div v-if=\"suspended\" class='text-danger'\n                                    ><fittext maxsize=\"12pt\">{{text.suspended}}</fittext></div>\n                            </b-card-title>\n                            <div class='s-studyplan-card-titleslot'><slot name='title'></slot></div>\n                        </div>\n                        <div class='s-studyplan-card-idnumber' v-if='value.idnumber'>\n                        {{ text.idnumber }}: {{ value.idnumber }}\n                        </div>\n                        <s-progress-bar\n                            v-if='!suspended && value.progress !== undefined && value.progress !== null'\n                            v-model=\"value.progress\"\n                        ></s-progress-bar>\n                    </div>\n\n                </div>\n                <slot></slot>\n                <template #footer>\n                    <span v-if=\"!timeless\" :class=\"'t-timing-'+timing\" v-html=\"dates.start + ' - '+ dates.end\"></span>\n                    <span class=\"s-studyplan-card-buttons\">\n                    <slot name='footer'></slot>\n                    <s-studyplan-details\n                        v-model=\"value\"\n                        v-if=\"value.description\"\n                    ><i class='fa fa-info-circle'></i></s-studyplan-details>\n                    <b-button style=\"float:right;\" v-if='open && !suspended' variant='primary'\n                        @click.prevent='onOpenClick($event)'>{{ text.open }}</b-button>\n                    </span>\n                </template>\n            </b-card>\n            "}),Vue.component("s-progress-bar",{props:{value:{type:Number},min:{type:Number,default:()=>0},max:{type:Number,default:()=>1}},data:()=>({text:strings.studyplancard}),computed:{width_completed(){if(this.value){return 100*((this.value-this.min)/(this.max-this.min))}return 0},width_incomplete(){if(this.value){return 100*(1-(this.value-this.min)/(this.max-this.min))}return 100},percentage_complete(){if(this.value){const v=(this.value-this.min)/(this.max-this.min);return Math.round(100*v)+"%"}return"0%"}},template:"\n            <div class='s-studyplan-card-progress' >\n                <div class=\"s-studyplan-card-progressbar\"\n                ><span v-if=\"width_completed > 0\"\n                    :style=\"{width: width_completed+'%'}\"\n                    class='s-studyplan-card-progress-segment s-studyplan-card-progress-completed'\n                ></span\n                ><span :style=\"{width: width_incomplete+'%'}\"\n                    class='s-studyplan-card-progress-segment s-studyplan-card-progress-incomplete'\n                ></span\n                ></div>\n                <div class=\"s-studyplan-card-progresstext\">\n                    {{ percentage_complete}} {{ text.completed.toLowerCase() }} \n                </div>\n        </div>\n            "}),Vue.component("s-studyline-header-heading",{props:{identifier:{type:Number,default:()=>0}},data:()=>({layerHeights:{}}),created(){ItemEventBus.$on("headerHeightChange",this.onHeaderHeightChange)},computed:{},methods:{onHeaderHeightChange(newheight,identifier){this.identifier==identifier&&this.$refs.main&&(this.$refs.main.style.height=`${newheight}px`)}},template:'\n            <div class="s-studyline-header-heading" ref="main" :data-id="identifier"><slot></slot></div>\n            '}),Vue.component("s-studyline-header-period",{props:{value:{type:Object},identifier:{type:Number,default:()=>0},mode:{type:String,default:"view"}},mounted(){const self=this;1==self.value.period&&(self.resizeListener=new ResizeObserver((()=>{if(self.$refs.main){const size=self.$refs.main.getBoundingClientRect();ItemEventBus.$emit("headerHeightChange",size.height,self.identifier)}})).observe(self.$refs.main))},unmounted(){this.resizeListener&&this.resizeListener.disconnect()},computed:{startdate(){return(0,_dateHelper.formatDate)(this.value.startdate)},enddate(){return(0,_dateHelper.formatDate)(this.value.enddate)},current(){if(this.value&&this.value.startdate&&this.value.enddate){const now=new Date,pstart=new Date(this.value.startdate),pend=new Date(this.value.enddate);return now>=pstart&&now<pend}return!1}},data:()=>({}),template:'\n            <div :class="\'s-studyline-header-period \'" ref="main" :data-id="identifier"\n                ><p><abbr :id="\'s-period-\'+value.id" :title="value.fullname"><span v-html="value.display.shortname"></span></abbr>\n                <b-tooltip\n                    :target="\'s-period-\'+value.id" triggers="hover"\n                    ><span v-html="value.display.fullname"></span><br>\n                    <span v-if="!value.timeless" class="s-studyline-header-period-datespan">\n                        <span class="date">{{ startdate }}</span> - <span class="date">{{ enddate }}</span>\n                    </span>\n                </b-tooltip>\n                <slot></slot\n                ><p v-if="!value.timeless && value.startdate > 0"\n                    class="s-studyline-header-period-datespan small">\n                    <span class="date">{{ startdate }}</span>\n                     - <span class="date" v-if="value.enddate > 0">{{ enddate }}</span><span class="date" v-else>&infin;</span>\n                </p>\n                <div v-if="current && mode == \'view\'" class=\'s-studyline-period-highlight\'></div>\n            </div>\n            '}),Vue.component("s-studyplan-details",{props:{value:{type:Object},variant:{type:String,default:()=>"info"},pill:{type:Boolean,default:()=>!1},size:{type:String,default:()=>""}},data:()=>({text:strings.details}),template:'\n            <span>\n                <b-button \n                    :size="size"\n                    :pill="pill"\n                    :variant="variant" \n                    v-b-modal="\'modal-description-\'+value.id"\n                ><slot><i class=\'fa fa-info-circle\'></i>\n                {{ text.details}}</slot>\n                </b-button>\n                <b-modal\n                    scrollable\n                    centered\n                    ok-only\n                    content-class="s-studyplan-details"\n                    :id="\'modal-description-\'+value.id"\n                    >\n                    <template #modal-title>\n                        <span v-html="value.display.name"></span>\n                    </template>\n                    <b-container>\n                        <b-row>\n                            <b-col cols="4"><div class=\'s-studyplan-card-icon\'><img :src=\'value.icon\'></div></b-col>\n                            <b-col cols="8" class="pl-1">\n                                <span v-html="value.display.description"></span>\n                            </b-col>\n                        </b-row>\n                    </b-container>\n                </b-modal>\n            </span>\n            '}),Vue.component("s-course-extrafields",{props:{value:{type:Array},variant:{type:String,default:()=>"info"},position:{type:String,default:()=>"below"},size:{type:String,default:()=>""}},data:()=>({text:strings.extrafields}),computed:{fields(){const fields=[];for(const ix in this.value){const field=this.value[ix];field.position==this.position&&field.value&&field.value.length>0&&fields.push(field)}return fields}},methods:{displaydate:field=>(0,_dateHelper.formatDate)(field.value,!1)},template:'\n            <div :class="\'s-course-extrafields \' + ((fields.length>0)?position:\'empty\')">\n                <table v-if="fields.length > 0">\n                    <tr v-for="field in fields">\n                        <td><span class=\'title\' v-if=\'field.title\'>{{ field.title}}</span></td>\n                        <td>\n                        <span v-if=\'field.type == "date"\' class="value date">{{ displaydate(field) }}</span>\n                        <span v-else-if=\'field.type == "checkbox"\' \n                        :class="\'value \' + (field.checked?\'true\':\'false\')">{{ field.value }}</span>\n                        <span v-else-if=\'field.type == "textarea"\'>\n                            <a  class=\'text-info\' \n                                @click.prevent.stop=""\n                                href=\'#\' \n                                v-b-modal="field.courseid+\'_\'+field.fieldname">{{text.show}}...</a>\n                            <b-modal\n                                :id="field.courseid+\'_\'+field.fieldname"\n                                :title="field.title""\n                                scrollable\n                                centered\n                                ok-only\n                                ><span v-html="field.value"></span\n                            ></b-modal>\n                        </span>\n                        <span v-else class="value"><span v-html="field.value"></span></span>\n                        </td>\n                    </tr>\n                </table>\n            </div>\n            '}),Vue.component("s-prevnext-selector",{props:{value:{type:Object,default:()=>null},options:{type:Array},grouped:{type:Boolean,default:!1},titlefield:{type:String,default:"title"},labelfield:{type:String,default:"label"},optionsfield:{type:String,default:"options"},defaultselectable:{type:Boolean,default:!1},variant:{type:String,default:""},arrows:{type:Boolean,default:!1}},data:()=>({settings:_settings.settings,text:strings.prevnext}),computed:{fields(){const f=[];if(this.defaultselectable&&f.push(null),this.grouped)for(const gix in this.options){const group=this.options[gix];for(const ix in group[this.optionsfield]){const v=group[this.optionsfield][ix];f.push(v)}}else for(const ix in this.options){const v=this.options[ix];f.push(v)}return f},bubblevalue:{get(){return this.value?this.value:null},set(v){this.$emit("input",v||null)}}},methods:{atFirst(){return!(this.fields.length>0)||this.fields[0]==this.value},atLast(){if(this.fields.length>0){const l=this.fields.length-1;return this.fields[l]==this.value}return!0},prev(){if(this.fields.length>0){const index=this.fields.indexOf(this.value);index>0&&(this.$emit("input",this.fields[index-1]),this.$emit("change",this.fields[index-1]))}},next(){if(this.fields.length>0){const index=this.fields.indexOf(this.value),l=this.fields.length-1;index>=0&&index<l&&(this.$emit("input",this.fields[index+1]),this.$emit("change",this.fields[index+1]))}},selectedchanged(value){this.$emit("change",value)}},template:'\n            <div :class="\'s-prevnext-selector \'">\n                <template v-if="settings.showprevnextarrows"\n                ><b-button :variant=\'variant\' @click="prev" :disabled="atFirst()"\n                    ><i v-if=\'arrows\' class=\'fa fa-caret-left s-prevnext-arrow\'></i\n                    ><template v-else>{{text.prev}}</template></b-button\n                >&nbsp;</template\n                ><b-form-select v-model="bubblevalue"\n                    @change=\'selectedchanged\'\n                    ><b-form-select-option\n                            :disabled="!defaultselectable"\n                            :value="null"\n                            :class="(defaultselectable)?\'font-italic text-primary \':\'font-italic\'"\n                            ><slot name="defaultlabel">{{text.select}}</slot></b-form-select-option\n                    ><template v-if="grouped"\n                        ><template v-for="(g,gi) in this.options"\n                            ><b-form-select-option-group\n                                v-if="g[optionsfield] && g[optionsfield].length > 0"\n                                :label="g[labelfield]"\n                                ><b-form-select-option \n                                    v-for="(o,i) in g[optionsfield]" \n                                    :key="i"\n                                    :value="o"\n                                    ><slot :value="o">{{o[titlefield]}}</slot></b-form-select-option>\n                            </b-form-select-option-group\n                        ></template\n                    ></template\n                    ><template v-else>\n                        <b-form-select-option \n                            v-for="(o,i) in this.options" \n                            :key="i"\n                            :value="o"\n                            ><slot :value="o">{{o[titlefield]}}</slot></b-form-select-option\n                    ></template\n                ></b-form-select\n                ><template v-if="settings.showprevnextarrows"\n                >&nbsp;<b-button :variant=\'variant\' @click="next" :disabled="atLast()"\n                    ><i v-if=\'arrows\' class=\'fa fa-caret-right s-prevnext-arrow\'></i\n                    ><template v-else>{{text.next}}</template></b-button\n                ></template\n            ></div>\n            '})}};return _exports.default=_default,_exports.default}));

//# sourceMappingURL=treestudyplan-components.min.js.map