/* eslint-disable */
/*
Compiled from ts into js by PMKuipers @ 2023) from source
at https://github.com/alexsasharegan/vue-functional-data-merge
Below is copy of licens in original project
*/
/*
The MIT License (MIT)

Copyright (c) 2017 Alex Regan

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

const pattern = {
    kebab: /-(\w)/g,
    styleProp: /:(.*)/,
    styleList: /;(?![^(]*\))/g,
};
function camelReplace(_substr, match) {
    return match.toUpperCase();
}
function camelCase(str) {
    return str.replace(pattern.kebab, camelReplace);
}
function parseStyle(style) {
    let styleMap = {};
    for (let s of style.split(pattern.styleList)) {
        let [key, val] = s.split(pattern.styleProp);
        key = key.trim();
        if (!key) {
            continue;
        }
        // May be undefined if the `key: value` pair is incomplete.
        val = val.trim();
        styleMap[camelCase(key)] = val;
    }
    return styleMap;
}
function mergeData() {
    let mergeTarget = {};
    let i = arguments.length;
    let prop;
    // Allow for variadic argument length.
    while (i--) {
        // Iterate through the data properties and execute merge strategies
        // Object.keys eliminates need for hasOwnProperty call
        for (prop of Object.keys(arguments[i])) {
            if (arguments[i][prop] == null) {
                continue;
            }
            switch (prop) {
                case "class": {
                    let classes = [];
                    {
                        let value = mergeTarget["class"];
                        if (Array.isArray(value)) {
                            classes = value;
                        }
                    }
                    // Repackaging in an array allows Vue runtime
                    // to merge class/style bindings regardless of type.
                    mergeTarget["class"] = classes.concat(arguments[i]["class"]);
                    continue;
                }
                // merge style by concatenating arrays
                case "style": {
                    let styles = [];
                    {
                        let value = mergeTarget.style;
                        if (Array.isArray(value)) {
                            styles = value;
                        }
                    }
                    let thisStyle = [];
                    if (Array.isArray(arguments[i].style)) {
                        thisStyle = arguments[i].style;
                    }
                    else {
                        thisStyle.push(arguments[i].style);
                    }
                    for (let j = 0; j < thisStyle.length; j++) {
                        let s = thisStyle[j];
                        if (typeof s === "string") {
                            thisStyle[j] = parseStyle(s);
                        }
                    }
                    mergeTarget[prop] = styles.concat(thisStyle);
                    continue;
                }
                case "id":
                case "key":
                case "ref":
                case "keepAlive": {
                    if (!mergeTarget[prop]) {
                        mergeTarget[prop] = arguments[i][prop];
                    }
                    continue;
                }
            }
            if (prop.startsWith("on") && prop !== "on") {
                // Object, the properties of which to merge via array merge strategy (array concatenation).
                // Callback merge strategy merges callbacks to the beginning of the array,
                // so that the last defined callback will be invoked first.
                // This is done since to mimic how Object.assign merging
                // uses the last given value to assign.
                // Concat function to array of functions if callback present.
                if (mergeTarget[prop] && !Array.isArray(mergeTarget[prop])) {
                    // Insert current iteration data in beginning of merged array.
                    mergeTarget[prop] = [mergeTarget[prop], arguments[i][prop]];
                    continue;
                }
                let targetValue = mergeTarget[prop];
                let thisValue = arguments[i][prop];
                // The `else` condition falls through to a simple assignment.
                if (Array.isArray(targetValue)) {
                    if (Array.isArray(thisValue)) {
                        targetValue.push(...thisValue);
                    }
                    else {
                        targetValue.push(thisValue);
                    }
                    continue;
                }
            }
            mergeTarget[prop] = arguments[i][prop];
        }
    }
    return mergeTarget;
}
export { mergeData };
