/* eslint-env es6*/
// Put this file in path/to/plugin/amd/src
// You can call it anything you like

/**
 * Initialize grade cfg page
 */
export function init() {
    { const
        intRx = /\d/,
        integerChange = (event) => {
          if ((event.key.length > 1) || intRx.test(event.key)
          ) {
              return;
            }
          event.preventDefault();
        };

      for (let input of document.querySelectorAll('input[type="number"][step="1"][min="0"]')) {
        input.addEventListener("keydown", integerChange);
      }

    }

    { const
        decimal = /^[0-9]*?\.[0-9]*?$/,
        intRx = /\d/,
        floatChange = (event) => {
          if ((event.key.length > 1) || ((event.key === ".") && (!event.currentTarget.value.match(decimal)))
                || intRx.test(event.key)
          ) {
              return;
            }
          event.preventDefault();
        };

      for (let input of document.querySelectorAll('input[type="number"][min="0"]:not([step])')) {
        input.addEventListener("keydown", floatChange);
      }
      for (let input of document.querySelectorAll('input[type="text"].float')) {
        input.addEventListener("keydown", floatChange);
      }

    }


}

