/* eslint no-var: "error" */
/* eslint no-unused-vars: "off" */
/* eslint linebreak-style: "off" */
/* eslint no-trailing-spaces: "off" */
/* eslint promise/no-nesting: "off" */
/* eslint max-depth: ["error", 6]*/
/* eslint-env es6*/
// Put this file in path/to/plugin/amd/src
// You can call it anything you like

import {call} from 'core/ajax';
import notification from 'core/notification';

import Vue from './vue/vue';

import Debugger from './util/debugger';
import {loadStrings} from './util/string-helper';
import {processStudyplan} from './studyplan-processor';
import {studyplanTiming} from './util/date-helper';
import {addBrowserButtonEvent} from './util/browserbuttonevents';

import EditorComponents from './studyplan-editor-components';
Vue.use(EditorComponents);

import TSComponents from './treestudyplan-components';
Vue.use(TSComponents);

import RVComponents from './report-viewer-components';
Vue.use(RVComponents);

import ModalComponents from './modedit-modal';
Vue.use(ModalComponents);

import PortalVue from './portal-vue/portal-vue.esm';
Vue.use(PortalVue);
import BootstrapVue from './bootstrap-vue/bootstrap-vue';
Vue.use(BootstrapVue);


let debug = new Debugger("treestudyplancoach");

let strings = loadStrings({
    coach: {
        back: "back",
        selectstudentBtn: "selectstudent_btn",
        coacheditmode: "coacheditmode",
        showoverview: "showoverview",
    },
});

/**
 * Initialize the Page
 * @param {string} selector The selector used to match html element to code
 */
export function init(selector) {
    let app = new Vue({
        el: selector,
        data: {
            selected: {
                planid: 0,
                studentid: 0,
            },
            displayedstudyplan: null,
            activestudyplan: null,
            associatedstudents: [],
            selectedstudent: null,
            studentstudyplan: null,
            loadingstudyplan: false,
            studyplans: [],
            text: strings.coach,
            toolbox: {
                right: true,
            },
            usedcontexts: [],
            editmode: false,
        },
        async mounted() {
            call([{
                methodname: 'local_treestudyplan_list_coaching_studyplans',
                args: {}
            }])[0].then(function(response) {
                const timingval = {present: 0, past: 1, future: 2};
                response.sort((a, b) => {
                    const timinga = studyplanTiming(a);
                    const timingb = studyplanTiming(b);

                    const t = timingval[timinga] - timingval[timingb];
                    if (t == 0) {
                        // Sort by name if timing is equal
                        return a.name.localeCompare(b.name);
                    } else {
                        return t;
                    }
                });
                app.studyplans = response;
                // Load studyplan from hash if applicable
                const hash = window.location.hash.replace('#', '');
                const parts = hash.split("-");

                if (!!parts && parts.length > 0 && parts[0] != '') {
                    for (let idx in app.studyplans) {
                        if (app.studyplans[idx].id == parts[0]) {
                            app.selectStudyplan(app.studyplans[idx], parts[1], false);
                            break;
                        }
                    }
                }
                return;
            }).catch(notification.exception);
            addBrowserButtonEvent(this.navChanged, this.navChanged);
        },
        computed: {
            studentcount() {
                let count = 0;
                for (const group of app.associatedstudents) {
                    count += group.users.length;
                }
                return count;
            }
        },
        methods: {
            navChanged() {
                const hash = window.location.hash.replace('#', '');
                const parts = hash.split("-");
                debug.log("Navigation changed", hash, parts);

                if (!!parts && parts.length > 0) {
                    const planid = Number(parts[0]);
                    const studentid = (parts.length > 1) ? Number(parts[1]) : 0;

                    debug.log("Selected ids", planid, studentid, this.selected.planid, this.selected.studentid);
                    if (planid == 0) {
                        if (planid != this.selected.planid) {
                            this.closeStudyplan(false);
                        }
                    } else if (this.selected.planid != planid || (studentid == 0 && this.selected.studentid != 0)) {
                        debug.info("Requested plan changed - loading studyplan");
                        for (let idx in app.studyplans) {
                            const plan = this.studyplans[idx];
                            if (Number(plan.id) == planid) {
                                this.selectStudyplan(plan, studentid, false);
                                break;
                            }
                        }
                    } else if (this.selected.studentid != studentid) {
                        for (const group of app.associatedstudents) {
                            for (const student of group.users) {
                                if (Number(student.id) == studentid) {
                                    app.showStudentView(student, false);
                                    break;
                                }
                            }
                        }
                    }
                }
            },
            closeStudyplan(updatehash = true) {
                app.selected.planid = 0;
                app.selected.studentid = 0;
                app.activestudyplan = null;
                app.associatedstudents = [];
                app.studentstudyplan = [];
                app.displayedstudyplan = null;
                if (updatehash) {
                    window.location.hash = '';
                }
            },

            selectStudyplan(studyplan, studentid, updatehash = true) {
                app.selected.planid = Number(studyplan.id);
                app.selected.studentid = studentid ? Number(studentid) : 0;
                // Fetch studyplan
                const self = this;
                self.loadingstudyplan = true;
                self.associatedstudents = [];
                self.selectedstudent = null;
                self.studentstudyplan = null;
                call([{
                    methodname: 'local_treestudyplan_get_studyplan_resultmap',
                    args: {id: studyplan.id}
                }])[0].then((response) => {
                    self.activestudyplan = processStudyplan(response, true);

                    call([{
                        methodname: 'local_treestudyplan_all_associated_grouped',
                        args: {'studyplan_id': studyplan.id}
                    }])[0].then(function(response) {
                        self.associatedstudents = response;
                        let foundstudent = false;
                        if (studentid) {
                            for (const group of self.associatedstudents) {
                                for (const student of group.users) {
                                    if (student.id == studentid) {
                                        foundstudent = true;
                                        self.showStudentView(student);
                                        break;
                                    }
                                }
                            }
                        }
                        if (!foundstudent) {
                            // Select first student available.
                            for (const group of self.associatedstudents) {
                                for (const student of group.users) {
                                    foundstudent = true;
                                    self.showStudentView(student);
                                    break;
                                }
                            }
                        }
                        if (!foundstudent) {
                            // Update hash with just the studyplan if no student was available for display
                            app.selected.studentid = 0;
                            if (updatehash) {
                                window.location.hash = app.activestudyplan.id;
                            }
                            self.displayedstudyplan = self.activestudyplan;
                            self.loadingstudyplan = false;
                        }
                        return;
                    }).catch(notification.exception);
                    return;
                }).catch(function(error) {
                    notification.exception(error);
                    app.loadingstudyplan = false;
                });
            },
            showStudentView(student, updatehash = true) {
                app.selected.studentid = student ? Number(student.id) : 0;
                if (student) {
                    app.selectedstudent = student;
                    app.studentstudyplan = null;
                    app.loadingstudyplan = true;
                    call([{
                        methodname: 'local_treestudyplan_get_user_studyplan',
                        args: {userid: student.id, studyplanid: app.activestudyplan.id}
                    }])[0].then((response) => {
                        app.studentstudyplan = processStudyplan(response, false);
                        app.displayedstudyplan = app.studentstudyplan;
                        app.loadingstudyplan = false;
                        if (updatehash) {
                            window.location.hash = app.activestudyplan.id + "-" + student.id;
                        }
                        return;
                    }).catch(function(error) {
                        notification.exception(error);
                        app.loadingstudyplan = false;
                    });
                } else {
                    this.showOverview(updatehash);
                }
            },
            showOverview(updatehash = true) {
                debug.info("Switch to overview", updatehash);
                app.selected.studentid = 0;
                app.selectedstudent = null;
                app.studentstudyplan = null;
                app.displayedstudyplan = app.activestudyplan;
                if (updatehash) {
                    window.location.hash = app.activestudyplan.id;
                }
            }

        },
        template: `
        <div class="t-studyplan-limit-width">
            <div class="m-buttonbar" style="margin-bottom: 1em;">
                <template v-if="displayedstudyplan">
                    <a href='#' @click.prevent='closeStudyplan'
                        ><i style='font-size: 150%;' class='fa fa-chevron-left'></i> {{text.back}}</a>
                    <s-studyplan-details
                        v-model="displayedstudyplan"
                        v-if="displayedstudyplan.description"
                    ></s-studyplan-details>
                    <div class="flex-grow-1"><!-- Spacer to align student selector right --></div>
                    <span>{{text.selectstudentBtn}}</span>
                    <s-prevnext-selector
                        :options="associatedstudents"
                        title="firstname"
                        v-model="selectedstudent"
                        defaultselectable
                        grouped
                        optionsfield='users'
                        arrows
                        @change="showStudentView"
                        class="ml-2"
                        variant="primary"
                        >
                        <template v-slot="{value}">{{value.firstname}} {{value.lastname}}</template>
                        <template #defaultlabel><span class='text-primary'>{{text.coacheditmode}}</span></template>
                    </s-prevnext-selector>
                </template>
            </div>
            <div class='t-studyplan-container'>
                <h2 v-if='displayedstudyplan&& selectedstudent'
                    ><span v-if="studentcount > 1">{{selectedstudent.firstname}} {{selectedstudent.lastname}} - </span
                    >{{displayedstudyplan.name}}</h2>
                <h2 v-else-if='displayedstudyplan'>{{text.showoverview}} - {{displayedstudyplan.name}}</h2>
                <template v-if="!loadingstudyplan && displayedstudyplan">
                    <r-studyplan v-if="selectedstudent"
                            v-model='displayedstudyplan'
                            coaching
                    ></r-studyplan>
                    <t-studyplan
                        v-else
                        v-model='displayedstudyplan'
                        coaching
                    ></t-studyplan>
                </template>
                <div v-else-if='loadingstudyplan' class="spinner-border text-primary" role="status">
                    <span class="sr-only">Loading...</span>
                </div>
                <div v-else class='t-studyplan-notselected'>
                    <b-card-group deck>
                        <s-studyplan-card
                            v-for='(studyplan, planindex) in studyplans'
                            :key='studyplan.id'
                            v-model='studyplans[planindex]'
                            open
                            @open='selectStudyplan(studyplan)'
                            ></s-studyplan-card>
                    </b-card-group>
                </div>
            </div>
        </div>
        `,
    });
}
