/* eslint no-unused-vars: "off" */
/* eslint-env es6*/
// Put this file in path/to/plugin/amd/src
// You can call it anything you like

import Vue from './vue/vue';

import {loadStrings} from './util/string-helper';

import RVComponents from './report-viewer-components';
Vue.use(RVComponents);
import PortalVue from './portal-vue/portal-vue.esm';
Vue.use(PortalVue);
import BootstrapVue from './bootstrap-vue/bootstrap-vue';
Vue.use(BootstrapVue);
import Debugger from './util/debugger';

let strings = loadStrings({
    myreport: {
        manageInvites: "manage_invites",
    },
});

/**
 * Initialize the Page
 * @param {string} selector The selector used to match html element to code
 * @param {string} type Type of page to show
 * @param {string} key Invitekey or userid of another user
 * @param {boolean} enableplansharing True if studyplan sharing is enabled
 */
 export function init(selector, type = "own", key, enableplansharing) {
    let app = new Vue({
        el: selector,
        data: {
            studyplans: [],
            type: type,
            invitekey: (type == "invited") ? key : "",
            text: strings.myreport,
            enableplansharing: enableplansharing,
        },
        methods: {
        },
        template: `
        <div class="local_treestudyplan_myreport">
            <div v-if="enableplansharing" class="m-buttonbar" style="margin-bottom: 1em; text-align: right;">
                <a class="btn btn-primary" href="invitations.php" id="manage_invites">
                &nbsp;<i class="fa fa-share"></i>&nbsp;{{text.manageInvites}}</a>
            </div>
            <r-report      v-if="type == 'teaching'" type='teaching' teachermode ></r-report>
            <r-report v-else-if="type == 'invited'" type='invited' :invitekey='invitekey'></r-report>
            <r-report v-else type='own'></r-report>
        </div>`
    });

}

