/* eslint no-var: "error"*/
/* eslint no-console: "off"*/
/* eslint-env es6*/

import Config from "core/config";

/**
 * Start a new debugger
 * @param {*} handle The string to attach to all messages from this debugger
 * @returns {object} Debugger object
 */
export default function(handle) {
    let outputEnabled = Config.developerdebug;
    if (outputEnabled) {
        console.warn(`In development environment. Debugger output enabled for ${handle}`);
    } else {
        console.warn(`In production environment. Debugger output disabled for ${handle}`);
    }

    return {
        write() {
            if (outputEnabled) {
                let args = Array.prototype.slice.call(arguments);
                args.unshift(handle + ": ");
                console.info.apply(console, args);
            }
        },
        log() {
            if (outputEnabled) {
                let args = Array.prototype.slice.call(arguments);
                args.unshift(handle + ": ");
                console.log.apply(console, args);
            }
        },
        info() {
            if (outputEnabled) {
                let args = Array.prototype.slice.call(arguments);
                args.unshift(handle + ": ");
                console.info.apply(console, args);
            }
        },
        warn() {
            if (outputEnabled) {
                let args = Array.prototype.slice.call(arguments);
                args.unshift(handle + ": ");
                console.warn.apply(console, args);
            }
        },
        error() {
            if (outputEnabled) {
                let args = Array.prototype.slice.call(arguments);
                args.unshift(handle + ": ");
                console.error.apply(console, args);
            }
        },
        time() {
            if (outputEnabled) {
                let args = Array.prototype.slice.call(arguments);
                args.unshift(handle + ": ");
                console.time.apply(console, args);
            }
        },
        timeEnd() {
            if (outputEnabled) {
                let args = Array.prototype.slice.call(arguments);
                args.unshift(handle + ": ");
                console.timeEnd.apply(console, args);
            }
        },
        timeLog() {
            if (outputEnabled) {
                let args = Array.prototype.slice.call(arguments);
                args.unshift(handle + ": ");
                console.timeLog.apply(console, args);
            }
        },
        timeStamp() {
            if (outputEnabled) {
                let args = Array.prototype.slice.call(arguments);
                args.unshift(handle + ": ");
                console.timeStamp.apply(console, args);
            }
        },
        enable() {
            outputEnabled = true;
        },
        disable() {
            outputEnabled = false;
        }
    };

}
