/* eslint no-var: "error" */
/* eslint-env es6*/

import {call} from 'core/ajax';
import notification from 'core/notification';

// Prepare default values
export const settings = {
    "hivizdropslots": false,
    "toolboxleft": false,
    "toolboxcoursesonly": false,
    "enablebadges": false,
    "badges_allowcoursebadges": false,
    "showprevnextarrows": false,
    "enableplansharing": false,
    "defaultaggregation": "core",
};

/**
 * Refresh settings from server
 * @returns {Object} The settings object
 */
export function refreshsettings() {
    call([{
        methodname: 'local_treestudyplan_getsettings',
        args: {}
    }])[0].then((response) => {
        for (const key in response) {
            settings[key] = response[key];
        }
        return settings;
    }).catch(notification.exception);
}

// Preload settings.
refreshsettings();