<?php
// This file is part of the Studyplan plugin for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Edit an existing or new invitation to view a studyplan
 * @package    local_treestudyplan
 * @copyright  2023 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once("../../config.php");
require_once($CFG->libdir . '/adminlib.php');
require_once("./lib.php");
require_once($CFG->libdir . '/weblib.php');

require_login();

use local_treestudyplan\form\editmanagedshare_form;
use local_treestudyplan\local\tools\invitation_tools;
use core\context\system as context_system;

$systemcontext = context_system::instance();
// Check if user has capability to manage this.
require_capability('local/treestudyplan:manageshares', $systemcontext);

$add    = optional_param('add', '', PARAM_ALPHANUM);     // Module name.
$update = optional_param('update', 0, PARAM_INT);
$resend = optional_param('resend', 0, PARAM_INT);
$delete = optional_param('delete', 0, PARAM_INT);

$PAGE->set_url("/local/treestudyplan/edit-manageinvite.php");
$PAGE->set_pagelayout('base');
$PAGE->set_context($systemcontext);

if ($update > 0) {
    $PAGE->set_title(get_string('invite_desc_edit', 'local_treestudyplan'));
    $PAGE->set_heading(get_string('invite_desc_edit', 'local_treestudyplan'));
} else {
    $PAGE->set_title(get_string('invite_desc_new', 'local_treestudyplan'));
    $PAGE->set_heading(get_string('invite_desc_new', 'local_treestudyplan'));
}

if ($CFG->debugdeveloper) {
    $PAGE->requires->css(new moodle_url($CFG->wwwroot . '/local/treestudyplan/styles.css'));
}
print $OUTPUT->header();

if (!empty($add)) {
    $data = [
     'add' => 1,
    ];
} else if (!empty($update)) {
    $data = $DB->get_record("local_treestudyplan_invit", ['id' => $update]);

    $data->update = $update;
    if (empty($data)) {
        throw new \moodle_exception('invalidaction', 'local_treestudyplan');
        exit;
    }
} else if (!empty($resend)) {
    $data = $DB->get_record("local_treestudyplan_invit", ['id' => $resend]);
    $data->resend = $resend;
    if (empty($data)) {
        throw new \moodle_exception('invalidaction', 'local_treestudyplan');
        exit;
    }

    // Do some resending of an invitation.
    invitation_tools::send_invite($data->id);
    redirect("$CFG->wwwroot/local/treestudyplan/cfg-manageshares.php?userid={$data->user_id}&sent={$resend}");
    print $OUTPUT->footer();
    exit;
} else if (!empty($delete)) {
    $data = $DB->get_record("local_treestudyplan_invit", ['id' => $delete]);
    if (empty($data)) {
        throw new \moodle_exception('invalidaction', 'local_treestudyplan');
        exit;
    }
    $DB->delete_records('local_treestudyplan_invit', ['id' => $data->if]);

    redirect("$CFG->wwwroot/local/treestudyplan/cfg-manageshares.php?userid={$data->user_id}");
    print $OUTPUT->footer();
    exit;
} else {
    throw new \moodle_exception('invalidaction', 'local_treestudyplan');
}

$mform = new editmanagedshare_form();
$mform->set_data($data);

if ($mform->is_cancelled()) {
    redirect("$CFG->wwwroot/local/treestudyplan/cfg-manageshares.php?userid={$data->user_id}");
} else if ($data = $mform->get_data()) {
    if (!empty($data->update)) {
        $id = $data->update;
        $data->id = $id;
        $DB->update_record('local_treestudyplan_invit', $data);
        redirect("$CFG->wwwroot/local/treestudyplan/cfg-manageshares.php?userid={$data->user_id}");
    } else if (!empty($data->add)) {
        $id = $DB->insert_record("local_treestudyplan_invit", $data, true);

        // Send invitaion mail.
        invitation_tools::send_invite($id);
        // Redirect back to the overview page.
        redirect("$CFG->wwwroot/local/treestudyplan/cfg-manageshares.php?userid={$data->user_id}&sent={$id}");
    } else if (!empty($data->resend)) {
        exit;
    } else if (!empty($data->delete)) {
        exit;
    } else {
        throw new \moodle_exception("invaliddata", 'local_treestudyplan');
    }
    exit;
} else {
    $data = null;
    $mform->display();
}

print $OUTPUT->footer();
