<?php
// This file is part of the Studyplan plugin for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Helper functions for web services
 * @package    local_treestudyplan
 * @copyright  2023 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_treestudyplan\local\helpers;
use core\formatting;
use core\context\system as context_system;

/**
 * Class containing helper functions for webservices
 */
class formatter {
    /** @var formatting */
    private static $formatting = null;

    /**
     * Undocumented function
     *
     * @return formatting
     */
    private static function get_formatting(): formatting {
        global $PAGE;
        if (self::$formatting == null) {
            if (empty($PAGE->context)) {
                $PAGE->set_context(context_system::instance());
            }
            self::$formatting = new formatting();
            self::$formatting->set_filterall(true);
            self::$formatting->set_forceclean(false);
            self::$formatting->set_striptags(false);
        }
        return self::$formatting;
    }

    /**
     * Given a string, return the string processed by filters.
     *
     * @param string $text
     * @return string
     */
    public static function format_string($text) {
        $formatting = self::get_formatting();
        return $formatting->format_string($text);
    }

    /**
     * Given text in a variety of format codings, this function returns the text with filters applied
     *
     * @param string $text
     * @return string
     */
    public static function format_text($text) {
        $formatting = self::get_formatting();
        return $formatting->format_text($text);
    }
}
