<?php
// This file is part of the Studyplan plugin for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Base class to scan submissions in activities
 * @package    local_treestudyplan
 * @copyright  2023 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_treestudyplan\local\ungradedscanners;

use grade_item;

/**
 * Base class for activity scanners
 */
abstract class scanner_base {
    /** @var grade_item */
    protected $gi;

    /**
     * Create new object based on grade_item
     * @param grade_item $gi The grade item for this activity
     */
    public function __construct(grade_item $gi) {
        $this->gi = $gi;
    }

    /**
     * Count the number of students wit ungraded submissions in this activity
     * @param array $courseuserids
     * @return int Number of students with ungraded submissions
     */
    abstract public function count_ungraded($courseuserids = []);

    /**
     * Count the number of students wit (all) graded submissions in this activity
     * @param array $courseuserids
     * @return int Number of students with graded submission
     */
    abstract public function count_graded($courseuserids = []);

    /**
     * Check if specified user has ungraded submission in this activity
     * @param mixed $userid User id of user to check
     * @return bool If specified user has ungraded submissions in this activity
     */
    abstract public function has_ungraded_submission($userid);

}
