<?php
// This file is part of the Studyplan plugin for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Background task to refresh the list of associaded teachers with studyplans
 * @package    local_treestudyplan
 * @copyright  2023 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_treestudyplan\task;
defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot.'/course/externallib.php');

use local_treestudyplan\studyplan;
use local_treestudyplan\teachingfinder;

/**
 * Background task to refresh the list of associaded teachers with studyplans
 */
class cleanup extends \core\task\scheduled_task {
    /**
     * Maximum time a result is valid before refreshing
     * @var int
     */
    const CACHE_TIME = 4 * 60 * 60; // 2 hours.

    /**
     * Return the task's name as shown in admin screens.
     *
     * @return string
     */
    public function get_name() {
        return get_string('cleanup_name', 'local_treestudyplan');
    }

    /**
     * Execute the task.
     */
    public function execute() {
        \mtrace("Verify studyplan contexts exist");
        $studyplans = studyplan::find_all();
        foreach ($studyplans as $plan) {
            // Context call automatically reverts studyplan to system context if the context cannot be found.
            $plan->context();
        }

    }
}
