<?php
// This file is part of the Studyplan plugin for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Entry point for Coach
 * @package    local_treestudyplan
 * @copyright  2023 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once("../../config.php");
require_once($CFG->libdir . '/weblib.php');

use core\context\system as context_system;

$systemcontext = context_system::instance();

$PAGE->set_url("/local/treestudyplan/coach.php", []);
require_login();

$PAGE->set_pagelayout('base');
$PAGE->set_context($systemcontext);
$PAGE->set_title(get_string('coaching_plans', 'local_treestudyplan'));
$PAGE->set_heading(get_string('coaching_plans', 'local_treestudyplan'));

if (! (\get_config("local_treestudyplan", "enablecoach"))) {
    throw new \moodle_exception("error:coachdisabled", "local_treestudyplan");
}

// Load page specific css.
$PAGE->requires->css(new moodle_url($CFG->wwwroot . '/local/treestudyplan/css/bootstrap-vue/bootstrap-vue.css'));
if ($CFG->debugdeveloper) {
    $PAGE->requires->css(new moodle_url($CFG->wwwroot . '/local/treestudyplan/styles.css'));
}

print $OUTPUT->header();
print $OUTPUT->render_from_template('local_treestudyplan/coach', []);
print $OUTPUT->footer();
