<?php
// This file is part of the Studyplan plugin for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Webservice function register
 * @package    local_treestudyplan
 * @copyright  2023 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$functions = [
    /***************************
     * Studyplan functions
     ***************************/
    'local_treestudyplan_list_studyplans' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'list_studyplans',
        'description'   => 'List available studyplans',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan, local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_studyplan_map' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'get_studyplan_map',
        'description'   => 'Retrieve studyplan map',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_studyplan_resultmap' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'get_studyplan_resultmap',
        'description'   => 'Retrieve studyplan result map',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_studyline_map' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'get_studyline_map',
        'description'   => 'Retrieve studyline map',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_add_studyplan' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'add_studyplan',
        'description'   => 'Add studyplan',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_add_studyline' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'add_studyline',
        'description'   => 'Add studyline',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_edit_studyplan' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'edit_studyplan',
        'description'   => 'Edit studyplan',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_edit_studyline' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'edit_studyline',
        'description'   => 'Edit studyline',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_delete_studyplan' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'delete_studyplan',
        'description'   => 'Delete studyplan',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_delete_studyplanpage' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'delete_studyplanpage',
        'description'   => 'Delete studyplan page',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_delete_studyline' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'delete_studyline',
        'description'   => 'Delete studyline',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_reorder_studylines' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'reorder_studylines',
        'description'   => 'Reorder studylines',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_get_studyitem' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'get_studyitem',
        'description'   => 'Retrieve study item',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_add_studyitem' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'add_studyitem',
        'description'   => 'Add study item',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_edit_studyitem' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'edit_studyitem',
        'description'   => 'Edit study item',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_reorder_studyitems' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'reorder_studyitems',
        'description'   => 'Reorder study items',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],

    'local_treestudyplan_delete_studyitem' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'delete_studyitem',
        'description'   => 'Delete study item',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_connect_studyitems' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'connect_studyitems',
        'description'   => 'Connect study items',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_disconnect_studyitems' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'disconnect_studyitems',
        'description'   => 'Disconnect study items',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    /***************************
     * Badge functions
     ***************************/

    'local_treestudyplan_list_badges' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'list_badges',
        'description'   => 'List available site badges',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_search_badges' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'search_badges',
        'description'   => 'Search available site badges',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_search_related_badges' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'search_related_badges',
        'description'   => 'Search badges related to courses in the studyplan',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],

    /***************************
     * Association functions
     ***************************/
    'local_treestudyplan_list_cohort' => [
        'classname'     => '\local_treestudyplan\associationservice',
        'methodname'    => 'list_cohort',
        'description'   => 'List available cohorts',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_find_user' => [
        'classname'     => '\local_treestudyplan\associationservice',
        'methodname'    => 'find_user',
        'description'   => 'Find user',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_connect_cohort' => [
        'classname'     => '\local_treestudyplan\associationservice',
        'methodname'    => 'connect_cohort',
        'description'   => 'Connect cohort to studyplan',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_disconnect_cohort' => [
        'classname'     => '\local_treestudyplan\associationservice',
        'methodname'    => 'disconnect_cohort',
        'description'   => 'Disconnect cohort from study plan',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_connect_user' => [
        'classname'     => '\local_treestudyplan\associationservice',
        'methodname'    => 'connect_user',
        'description'   => 'Connect user to study plan',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_disconnect_user' => [
        'classname'     => '\local_treestudyplan\associationservice',
        'methodname'    => 'disconnect_user',
        'description'   => 'Disconnect user from studyplan',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_associated_users' => [
        'classname'     => '\local_treestudyplan\associationservice',
        'methodname'    => 'associated_users',
        'description'   => 'List users associated with a studyplan',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_associated_cohorts' => [
        'classname'     => '\local_treestudyplan\associationservice',
        'methodname'    => 'associated_cohorts',
        'description'   => 'List cohorts associated with a studyplan',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_associated_coaches' => [
        'classname'     => '\local_treestudyplan\associationservice',
        'methodname'    => 'associated_coaches',
        'description'   => 'List coaches associated with a studyplan',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_find_coach' => [
        'classname'     => '\local_treestudyplan\associationservice',
        'methodname'    => 'find_coach',
        'description'   => 'Find available coach',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_connect_coach' => [
        'classname'     => '\local_treestudyplan\associationservice',
        'methodname'    => 'connect_coach',
        'description'   => 'Connect coach to study plan',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_disconnect_coach' => [
        'classname'     => '\local_treestudyplan\associationservice',
        'methodname'    => 'disconnect_coach',
        'description'   => 'Disconnect coach from studyplan',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    /***************************
     * Category mapping
     ***************************/
    'local_treestudyplan_search_courses' => [
        'classname'     => '\local_treestudyplan\courseservice',
        'methodname'    => 'search_courses',
        'description'   => 'Search courses',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_map_categories' => [
        'classname'     => '\local_treestudyplan\courseservice',
        'methodname'    => 'map_categories',
        'description'   => 'List available root categories',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_category' => [
        'classname'     => '\local_treestudyplan\courseservice',
        'methodname'    => 'get_category',
        'description'   => 'Get details for specified category',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_include_grade' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'include_grade',
        'description'   => 'Include gradable in result',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan, local/treestudyplan:selectowngradables',
        'loginrequired' => true,
    ],
    'local_treestudyplan_require_competency' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'require_competency',
        'description'   => 'Mark competency as required in course outcome',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan, local/treestudyplan:selectowngradables',
        'loginrequired' => true,
    ],
    'local_treestudyplan_all_associated' => [
        'classname'     => '\local_treestudyplan\associationservice',
        'methodname'    => 'all_associated',
        'description'   => 'List associated users',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    'local_treestudyplan_all_associated_grouped' => [
        'classname'     => '\local_treestudyplan\associationservice',
        'methodname'    => 'all_associated_grouped',
        'description'   => 'List associated users by group',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    /***************************
     * Studyplan functions
     ***************************/
    'local_treestudyplan_list_aggregators' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'list_aggregators',
        'description'   => 'List available aggregators',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_force_studyplan_scale' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'force_studyplan_scale',
        'description'   => 'Change all associated gradables to the chosen scale if possible',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:forcescales',
        'loginrequired' => true,
    ],
    'local_treestudyplan_list_scales' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'list_scales',
        'description'   => 'List system scales',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:forcescales',
        'loginrequired' => true,
    ],
    'local_treestudyplan_duplicate_plan' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'duplicate_plan',
        'description'   => 'Copy studyplan',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_export_plan' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'export_plan',
        'description'   => 'Export studyplan',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_export_page' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'export_page',
        'description'   => 'Export studyplan page',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_import_plan' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'import_plan',
        'description'   => 'Import study plan',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_import_pages' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'import_pages',
        'description'   => 'Import study plan pages',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_import_studylines' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'import_studylines',
        'description'   => 'Import study plan',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_period' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'get_period',
        'description'   => 'Get period name and timing',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_edit_period' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'edit_period',
        'description'   => 'Edit period name and timing',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_submit_cm_editform' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'submit_cm_editform',
        'description'   => 'Submit course module edit form',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_list_available_categories' => [
        'classname'     => '\local_treestudyplan\courseservice',
        'methodname'    => 'list_available_categories',
        'description'   => 'Get categories hosting  a studyplan',
        'type'          => 'read',
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_scan_badge_progress' => [
        'classname'     => '\local_treestudyplan\courseservice',
        'methodname'    => 'scan_badge_progress',
        'description'   => 'Scan progress of students in attaining badge',
        'type'          => 'read',
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_scan_completion_progress' => [
        'classname'     => '\local_treestudyplan\courseservice',
        'methodname'    => 'scan_completion_progress',
        'description'   => 'Scan progress of students in attaining completions',
        'type'          => 'read',
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_scan_grade_progress' => [
        'classname'     => '\local_treestudyplan\courseservice',
        'methodname'    => 'scan_grade_progress',
        'description'   => 'Scan progress of students in attaining grades',
        'type'          => 'read',
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_cascade_cohortsync' => [
        'classname'     => '\local_treestudyplan\associationservice',
        'methodname'    => 'cascade_cohortsync',
        'description'   => 'Sync cohortsync to studyplan association',
        'type'          => 'read',
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_course_period_timing' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'course_period_timing',
        'description'   => 'Chenge course start and end times to match period',
        'type'          => 'read',
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_set_studyitem_span' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'set_studyitem_span',
        'description'   => 'Change the span of a course item',
        'type'          => 'read',
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_mform' => [
        'classname'     => '\local_treestudyplan\utilityservice',
        'methodname'    => 'get_mform',
        'description'   => 'Get a studyplan specific form',
        'type'          => 'read',
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_submit_mform' => [
        'classname'     => '\local_treestudyplan\utilityservice',
        'methodname'    => 'submit_mform',
        'description'   => 'Submit a studyplan specific form through ajax',
        'type'          => 'read',
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_bulk_course_timing' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'bulk_course_timing',
        'description'   => 'Change course start/end dates to match that of the studyplan period',
        'type'          => 'write',
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'ajax'          => true,
        'loginrequired' => true,
    ],
    'local_treestudyplan_list_user_studyplans' => [
        'classname'     => '\local_treestudyplan\studentstudyplanservice',
        'methodname'    => 'list_user_studyplans',
        'description'   => 'List user studyplans',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_user_studyplan' => [
        'classname'     => '\local_treestudyplan\studentstudyplanservice',
        'methodname'    => 'get_user_studyplan',
        'description'   => 'Retrieve user studyplan',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    'local_treestudyplan_list_invited_studyplans' => [
        'classname'     => '\local_treestudyplan\studentstudyplanservice',
        'methodname'    => 'list_invited_studyplans',
        'description'   => 'List studyplans for user from invite',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => false,
    ],
    'local_treestudyplan_get_invited_studyplan' => [
        'classname'     => '\local_treestudyplan\studentstudyplanservice',
        'methodname'    => 'get_invited_studyplan',
        'description'   => 'Retrieve studyplan for user from invite',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => false,
    ],
    'local_treestudyplan_list_own_studyplans' => [
        'classname'     => '\local_treestudyplan\studentstudyplanservice',
        'methodname'    => 'list_own_studyplans',
        'description'   => 'List studyplans for current user',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_own_studyplan' => [
        'classname'     => '\local_treestudyplan\studentstudyplanservice',
        'methodname'    => 'get_own_studyplan',
        'description'   => 'Retrieve studyplan for current user',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_list_teaching_studyplans' => [
        'classname'     => '\local_treestudyplan\studentstudyplanservice',
        'methodname'    => 'list_teaching_studyplans',
        'description'   => 'List studyplans for current user as teacher',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_teaching_studyplan' => [
        'classname'     => '\local_treestudyplan\studentstudyplanservice',
        'methodname'    => 'get_teaching_studyplan',
        'description'   => 'Retrieve studyplan for current user as teacher',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_list_coaching_studyplans' => [
        'classname'     => '\local_treestudyplan\studentstudyplanservice',
        'methodname'    => 'list_coaching_studyplans',
        'description'   => 'List studyplans for current user as coach',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    /***************************
     * Studyplan report functions
     ***************************/
    'local_treestudyplan_get_report_structure' => [
        'classname'     => '\local_treestudyplan\reportservice',
        'methodname'    => 'get_report_structure',
        'description'   => 'Retrieve studyplan report structure',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_report_data' => [
        'classname'     => '\local_treestudyplan\reportservice',
        'methodname'    => 'get_report_data',
        'description'   => 'Retrieve studyplan report data for student ',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    'local_treestudyplan_get_report_details' => [
        'classname'     => '\local_treestudyplan\reportservice',
        'methodname'    => 'get_report_details',
        'description'   => 'Retrieve studyplan report details for student ',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:viewuserreports',
        'loginrequired' => true,
    ],
    /***************************
     * Studyline enrollment functions
     ***************************/
    'local_treestudyplan_list_roles' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'list_roles',
        'description'   => 'Retrieve list of available roles in the studyplan\'s context',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:editstudyplan',
        'loginrequired' => true,
    ],
    'local_treestudyplan_line_enrol_self' => [
        'classname'     => '\local_treestudyplan\studentstudyplanservice',
        'methodname'    => 'line_enrol_self',
        'description'   => 'Enroll yourself in a study line',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_line_enrol_students' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'line_enrol_students',
        'description'   => 'Enroll a student in a study line',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_line_unenrol_students' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'line_unenrol_students',
        'description'   => 'Enrol a student in a study line',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:lineunenrol',
        'loginrequired' => true,
    ],
    'local_treestudyplan_list_line_enrolled_students' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'list_line_enrolled_students',
        'description'   => 'Show students enrolled in an enrollable study line',
        'type'          => 'write',
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    /***************************
     * Utility functions
     ***************************/
    'local_treestudyplan_count_templates' => [
        'classname'     => '\local_treestudyplan\studyplanservice',
        'methodname'    => 'count_templates',
        'description'   => 'Count number of templates',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],
    'local_treestudyplan_getsettings' => [
        'classname'     => '\local_treestudyplan\utilityservice',
        'methodname'    => 'getsettings',
        'description'   => 'Get some studypln related settings',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => '',
        'loginrequired' => true,
    ],

    /***************************
     * Share API Functions
     ***************************/
    'local_treestudyplan_find_users' => [
        'classname'     => '\local_treestudyplan\shareservice',
        'methodname'    => 'find_users',
        'description'   => 'Find potential users',
        'type'          => 'read',
        'ajax'          => true,
        'capabilities'  => 'local/treestudyplan:manageshares',
        'loginrequired' => true,
    ],
];
