<?php
// This file is part of the Studyplan plugin for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Entry point for students to manage invitations to view their study plan
 * @package    local_treestudyplan
 * @copyright  2023 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once("../../config.php");
require_once($CFG->libdir . '/weblib.php');
require_once($CFG->dirroot . '/grade/querylib.php');
use core\context\system as context_system;

$systemcontext = context_system::instance();

$PAGE->set_url("/local/treestudyplan/invitations.php", []);
require_login();

$PAGE->set_pagelayout('base');
$PAGE->set_context($systemcontext);
$PAGE->set_title(get_string('manage_invites', 'local_treestudyplan'));
$PAGE->set_heading(get_string('manage_invites', 'local_treestudyplan'));

// Load javascripts.
$PAGE->requires->js_call_amd('local_treestudyplan/tool-actionhrefs', 'init');

// Check if we have a sent confirmation.
$sent = optional_param('sent', '', PARAM_INT);
if (!empty($sent)) {
    $invite = $DB->get_record('local_treestudyplan_invit', ['id' => $sent]);
    \core\notification::success(get_string('invite_resent_msg', 'local_treestudyplan', $invite));
};

if (!get_config("local_treestudyplan", "enableplansharing")) {
    $PAGE->set_title(get_string('accessdenied', 'admin'));
    $PAGE->set_heading(get_string('accessdenied', 'admin'));

    print $OUTPUT->header();
    print $OUTPUT->render_from_template('local_treestudyplan/error', [
        "title" => get_string('accessdenied', 'admin'),
        "message" => get_string('error:invitationsdisabled', 'local_treestudyplan'),
    ]);
    print $OUTPUT->footer();

    exit; // Just in case some code is added after this if statement erroneously later.
} else {
    print $OUTPUT->header();
    $haslocked = false;
    $invites = $DB->get_records('local_treestudyplan_invit', ['user_id' => $USER->id]);
    $now = (new \DateTime("now", \core_date::get_user_timezone_object()))->getTimestamp();
    foreach ($invites as $invit) {
        if (empty($invit->unlockdate)) {
            $invit->lock = false;
            $invit->unlocked = true;
        } else {
            if (intval($invit->unlockdate) < $now) {
                $invit->unlocked = true;
            } else {
                $invit->unlocked = false;
            }
            $invit->lock = true;
            $haslocked = true;
        }
    }
    $data = [
        "invites" => array_values($invites),
        "hasinvites" => boolval(count($invites) > 0),
        "haslocked" => $haslocked,
        "invitedurl" => "{$CFG->wwwroot}/local/treestudyplan/invited.php",
    ];
    print $OUTPUT->render_from_template('local_treestudyplan/invitations', $data);
    print $OUTPUT->footer();
}
