<?php
// This file is part of the Study plan plugin for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * English language file
 * @package    local_treestudyplan
 * @copyright  2023 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string["add_association"] = 'Add';
$string["advanced_backup"] = 'Backup to file';
$string["advanced_backup_page"] = 'Backup active studyplan page ';
$string["advanced_backup_plan"] = 'Backup studyplan';
$string["advanced_backup_restore"] = 'Backup and restore';
$string["advanced_bulk_course_timing"] = 'Sync course timing to periods';
$string["advanced_bulk_course_timing_desc"] = 'Synchronize the start and end date of all courses in the currently active studyplan page to periods in which they are placed.';
$string["advanced_cascade_cohortsync"] = "Cascade cohort sync";
$string["advanced_cascade_cohortsync_desc"] = "Add cohort sync enrolment to each course in this study plan for all cohorts linked to this study plan";
$string["advanced_cascade_cohortsync_title"] = "Cascade cohort sync";
$string["advanced_confirm_header"] = 'Are you sure';
$string["advanced_converted"] = 'converted';
$string["advanced_course_manipulation_title"] = 'Course manipulation';
$string["advanced_create_from_template"] = "Create from template";
$string["advanced_error"] = 'error';
$string["advanced_export"] = 'Export to file';
$string["advanced_export_csv_page"] = 'Export current page as CSV';
$string["advanced_export_csv_plan"] = 'Export studyplan CSV';
$string["advanced_failed"] = 'failed';
$string["advanced_force_scale_button"] = 'Apply';
$string["advanced_force_scale_confirm"] = 'Are you sure you want to set all associated gradable\'s to this scale?';
$string["advanced_force_scale_desc"] = 'Change all gradable objectives associated with this study plan to scale grading with the selected scale. This will only affect gradable\'s that do not already have grades.';
$string["advanced_force_scale_title"] = 'Force scales';
$string["advanced_import_from_file"] = "Load from file";
$string["advanced_locked"] = 'locked';
$string["advanced_multiple"] = 'multiple';
$string["advanced_pick_scale"] = 'Pick scale';
$string["advanced_purge"] = "Delete";
$string["advanced_purge_page"] = "Delete active page";
$string["advanced_purge_page_expl"] = "Delete the currently active study plan page. This is not recoverable";
$string["advanced_purge_plan"] = "Delete entire study plan";
$string["advanced_purge_plan_expl"] = "Delete the entire study plan. This is not recoverable";
$string["advanced_restore"] = 'Restore from file';
$string["advanced_restore_lines"] = 'Import content from a studyplan page backup';
$string["advanced_restore_pages"] = 'Import pages from a studyplan backup';
$string["advanced_skipped"] = 'skipped';
$string["advanced_tools"] = 'Advanced';
$string["advanced_tools_heading"] = 'Advanced tools';
$string["advanced_warning"] = 'These advanced tools should be used with the utmost care. Make sure you know what you are doing when using them';
$string["advanced_warning_title"] = 'Warning';
$string["aggregation_all"] = "Complete all ";
$string["aggregation_any"] = "Complete one or more ";
$string["aggregation_one"] = "Achieve ";
$string["aggregation_overall_all"] = "Complete all of the following to complete this course";
$string["aggregation_overall_any"] = "Complete one or more of the following to complete this course";
$string["aggregation_overall_one"] = "Complete the following to complete this course";
$string["allgraded"] = 'All graded';
$string["associate_coaches"] = 'Search coaches to add';
$string["associate_cohorts"] = 'Search cohorts to add';
$string["associate_users"] = 'Search users to add';
$string["associated_coaches"] = 'Linked coaches';
$string["associated_cohorts"] = 'Linked cohorts';
$string["associated_users"] = 'Linked users';
$string["associations"] = 'Associations';
$string["associations_empty"] = 'No active associations';
$string["associations_search"] = 'Search';
$string["autocohortsync_name"] = 'Study plan automatic cohort sync cascading';
$string["back"] = "Back";
$string["badgedisabled"] = "This badge is currently not available";
$string["badgeinfo"] = "Badge details";
$string["badgeissuedstats"] = "Issuing progress";
$string["badges"] = 'Badges';
$string["badgesearchinstruction"] = 'Type 3 or more characters to search badges';
$string["bistate_aggregator_desc"] = 'Objectives are completed or not (e.g. not started, in progress or failed). Required objectives for completion are supported. You can configure for each study plan how many attained objectives result in a completed, good or excellent module score';
$string["bistate_aggregator_title"] = 'Manual: Completed + Required objectives';
$string["cfg_grades"] = 'Configure grade & scale interpretation';
$string["cfg_grades_desc"] = '';
$string["cfg_grades_desc_head"] = 'Configure how results for objectives are presented.';
$string["cfg_grades_grades"] = 'Configure point grade interpretation';
$string["cfg_grades_scales"] = 'Configure scale grade interpretation';
$string["cfg_help"] = "Study plan plugin documentation";
$string["cfg_manageshares"] = 'Manage mandatory studyplan sharing.';
$string["cfg_plans"] = 'Manage study plans';
$string["cfg_uploadshares"] = 'Upload mandatory studyplan sharing.';
$string["choose_aggregation_style"] = 'Choose aggregation style';
$string["cleanup_name"] = "Regular maintenance tasks for study plans";
$string["coacheditmode"] = "Edit content";
$string["coaches"] = 'Coaches';
$string["coaching_plans"] = "Coaching study plans";
$string["cohorts"] = 'Cohorts';
$string["competency_aggregator_desc"] = 'Use the competencies linekd to the course';
$string["competency_aggregator_title"] = 'Course competencies';
$string["competency_details"] = 'Details';
$string["competency_heading"] = 'Competency';
$string["competency_not_configured"] = "Course competencies have not yet been configured.";
$string["completed"] = 'Completed';
$string["completed_fail"] = 'Failed';
$string["completed_pass"] = 'Passed';
$string["completion_completed"] = "Completed";
$string["completion_completed_badge"] = "Issued";
$string["completion_excellent"] = "Excellent";
$string["completion_failed"] = "Failed";
$string["completion_good"] = "Good";
$string["completion_incomplete"] = "Not started";
$string["completion_incomplete_badge"] = "Not issued";
$string["completion_not_configured"] = "Course completion has not yet been configured.";
$string["completion_not_enabled"] = 'Completion is not enabled in this course';
$string["completion_passed"] = "Passed";
$string["completion_pending"] = "Pending review";
$string["completion_progress"] = "In progress";
$string["condition_50"] = 'Half of entries need to be completed';
$string["condition_67"] = '2/3 of entries need to be completed';
$string["condition_all"] = 'All entries need to be completed';
$string["condition_any"] = 'One or more entries need to be completed';
$string["condition_default"] = 'Default for this item';
$string["configure_competency"] = "Configure course competencies";
$string["configure_completion"] = "Configure course completion";
$string["confirm_cancel"] = 'Cancel';
$string["confirm_ok"] = 'Confirm';
$string["context"] = 'Category';
$string["core_aggregator_desc"] = 'Use Moodle core completion';
$string["core_aggregator_title"] = 'Moodle course completion';
$string["course-invalid"] = "Error";
$string["course_period_span"] = 'Spans';
$string["course_period_span_desc"] = 'If the space directly after this course is free, the course can be expanded to span multiple periods.';
$string["course_timing_desc"] = 'The start and end date of the course do not match the start and end date of it\'s period(s) in the study plan.';
$string["course_timing_hidewarning"] = 'Hide this warning next time';
$string["course_timing_off"] = 'Course timing does not match period timing. Click here to correct.';
$string["course_timing_ok"] = 'Course timing matches period timing';
$string["course_timing_question"] = 'Do you want to update the course\'s start and end time to match that of the period(s)?';
$string["course_timing_rememberchoice"] = 'Remember my choice for future date mismatches';
$string["course_timing_title"] = 'Course timing does not match period timing';
$string["course_timing_warning"] = 'You do not have permission to automatically update this course start and end date. Automatic timing update not available';
$string["courses"] = 'Courses';
$string["coursetiming_future"] = "Upcoming course";
$string["coursetiming_past"] = "Past course";
$string["coursetiming_present"] = "Current course";
$string["csvcolumnmissing"] = 'There are missing mandatory columns in your CSV file: {$a}. Double-check the spelling of the column names.';
$string["currentpage"] = "Currently active page:";
$string["dateexpire"] = "Expires on";
$string["dateissued"] = "Issued on";
$string["default_line_name"] = 'Courses';
$string["default_line_shortname"] = 'Courses';
$string['defaultaggregation'] = 'Default aggregation';
$string["delete_association"] = 'Delete';
$string["drophere"] = "Drop here";
$string["duration"] = 'Duration';
$string["edit_plan"] = 'Edit study plan';
$string["editmode_modules_hidden"] = 'Modules hidden in edit mode';
$string["error"] = "Error";
$string["error:cannotviewcategory"] = 'Error: You do not have access to view this category or context: {$a}';
$string["error:coachdisabled"] = "The coach page has been disabled by the system administrator";
$string["error:invalid_invitekey"] = "You need an invitation to view data via this portal";
$string["error:invitationsdisabled"] = "Sharing studyplans with 3rd parties has been disabled on this site.";
$string["error:nocategoriesvisible"] = 'Error: You have no viewing permissions in any category. Therefore the course list remains empty.';
$string["error:nostudyplaneditaccess"] = 'Error: You do not have access to manage study plans in this category or context: {$a}';
$string["error:nostudyplanviewaccess"] = 'Error: You do not have access to view study plans in this category or context: {$a}';
$string["error:nosuchcompetency"] = 'Warning: This competency no longer exists';
$string["error:usernotassociated"] = 'Error: Requested student is not associated with this studyplan';
$string["flow"] = 'Flow';
$string["grade_include"] = 'Include';
$string["grade_points"] = 'Maximum grade points';
$string["grade_require"] = 'Require';
$string["graded"] = 'Graded';
$string["incomplete"] = 'Not started';
$string["individuals"] = 'Individuals';
$string["infofield_position_above"] = 'Above course results';
$string["infofield_position_below"] = 'Below course results';
$string["infofield_position_footer"] = 'Footer';
$string["infofield_position_header"] = 'Header ';
$string["invalid_invitekey_title"] = "Invite key required";
$string["invite_button_new"] = "New invite";
$string["invite_confirm_delete"] = 'Are your sure tou want to delete/revoke the invite for {$a}?';
$string["invite_confirm_resend"] = 'Are your sure you want to send the invite link to {$a} again?';
$string["invite_date"] = "Date created";
$string["invite_desc_edit"] = "Edit an existing invitation";
$string["invite_desc_new"] = "Create a new invitation";
$string["invite_description"] = "You can invite your parents or guardians to view your results. Those who receive your sharing link can view your grades until you revoke the invite.<br>Your educational institution may send out shares that are mandatory until a specific date. If so, they will be indicated here, but you cannot edit or delete them until that date has arrived.";
$string["invite_email"] = "Email";
$string["invite_identifier"] = "Institute tag";
$string["invite_locked_error"] = "You cannot edit or delete this invitation, because it is locked.";
$string["invite_mail_managed_text"] = '<p>Dear {$a->invitee}, </p> <p>We\'d like to invite you to view the study plan and progess for {$a->user}.</p> <p>The link below gives you access at any time to view the most recent results. Feel free to bookmark this link in your browser.</p> <p>Click the link below to view the study plan:<br> <a href="{$a->link}">{$a->link}</a></p> <p>Kind regards, The Administration</p>';
$string["invite_mail_subject"] = 'Shared grade card of {$a->sender}';
$string["invite_mail_text"] = '<p>Dear {$a->invitee}, </p> <p>I\'d like to invite you to view my study plan and progess.</p> <p>The link below gives you access at any time to view the most recent results. Feel free to bookmark this link in your browser.</p> <p>Click the link below to view the study plan:<br> <a href="{$a->link}">{$a->link}</a></p> <p>Kind regards, <br> {$a->sender}</p>';
$string["invite_manage_description"] = 'In this page you can manage mandatory studyplan shares, for example if your organization is legally required to share student progress with parents or guardians. To account for multiple scenarios, these mandatory shares have an expiration date. This can be set to e.g. the age of majority for the student. After the exiration date, the invitation acts as a normal share and can be edited or deleted by the user.';
$string["invite_manage_nomadatoryshares"] = 'There are currently no mandatory shares for this user.';
$string["invite_manage_nouserselected"] = 'Select a user to view and manage their registered mandatory shares';
$string["invite_manage_resent_msg"] = 'The invitation for {$a->username} to {$a->name}&lt;{$a->email}&gt; has been sent';
$string["invite_manage_selectuser"] = 'Select user to view shares';
$string["invite_manage_tablecaption"] = 'Mandatory studyplan shares';
$string["invite_name"] = "Invitee name";
$string["invite_notlocked"] = "Not locked";
$string["invite_resent_msg"] = 'The invitation to {$a->name} &lt;{$a->email}&gt; has been sent';
$string["invite_selectuser"] = "Select user";
$string["invite_table_empty"] = "No active invites";
$string["invite_tablecaption"] = "Active invites";
$string["invite_tooltip_delete"] = "Delete invite";
$string["invite_tooltip_edit"] = "Edit invite";
$string["invite_tooltip_resend"] = "Resend invite";
$string["invite_tooltip_testlink"] = "See how your results are shown";
$string["invite_unlock_date"] = "Invite locked until";
$string["invite_unlocked"] = "Unlocked";
$string["item_configuration"] = "Configure study item";
$string["item_delete_message"] = 'Are you sure you want to delete the {item} {name} from studyline {line} in {period}?';
$string["line_can_enrol"] = 'You can register for this line';
$string["line_cannot_enrol"] = 'You cannot register yourself for this line';
$string["line_enrol"] = 'Register';
$string["line_enrol_question"] = 'Do you want to register yourself for {$a}?';
$string["line_enrol_student_question"] = 'Do you want to register {$a} in this line?';
$string["line_enrollable:0"] = 'No registration needed';
$string["line_enrollable:1"] = 'Registration by students themselves.';
$string["line_enrollable:2"] = 'Registration by user with role';
$string["line_enrollable:3"] = 'Registration by students themeselves or user with role';
$string["line_enrolled"] = 'Registered';
$string["line_enrolled_in"] = 'Registered in {$a}';
$string["line_enrollment"] = 'Registration';
$string["line_enrollments"] = 'Registrations';
$string["line_is_enrolled"] = 'You are registered for this line';
$string["line_notenrolled"] = 'Not registered';
$string["line_unenrol"] = 'Unregister';
$string["line_unenrol_student_question"] = 'Do you want to unregister {$a} from this line?';
$string["link_coach"] = "Coaching studyplans";
$string["link_editplan"] = "Manage study plans";
$string["link_myreport"] = "My study plan";
$string["link_studyplans"] = "Study plans";
$string["link_viewplan"] = "Study plans";
$string["manage_invites"] = 'Share study plan access';
$string["min_completed"] = 'Completion threshold';
$string["min_progress"] = 'Progression threshold';
$string["myreport_teachermode"] = 'Study plans I am teaching';
$string["name"] = 'Name';
$string["nav_invited"] = "View study plan by invitation";
$string["no_form_data"] = "The provided information was incorrect. Likely you uploaded an icon in an unsupported format. Please check your input data and try again.";
$string["no_templates"] = "There are no templates available. Mark a study plan as template to enable template based creation.";
$string["noenddate"] = "Ongoing";
$string["nogrades"] = 'No grades';
$string["not_enrolled"] = "Not enrolled";
$string["open"] = "Open";
$string["overall"] = 'Course';
$string["overviewreport:all"] = 'Result overview';
$string["overviewreport:period"] = 'Result overview for this period';
$string["period"] = 'Period';
$string["period_default_fullname"] = 'Period {$a}';
$string["period_default_shortname"] = 'P{$a}';
$string["period_edit"] = 'Change period details';
$string["periods"] = 'Periods';
$string["pluginname"] = 'Study plans';
$string["privacy:metadata"] = 'This plugin stores a link between users and their associated study plans. It also needs to store an email address and user provided handle, which may be a name, to send invitations to view the study plan to whomever the user chooses by email.';
$string["privacy:metadata:coach"] = 'Links a user as coach to a study plan';
$string["privacy:metadata:coach:studyplan_id"] = 'The study plan';
$string["privacy:metadata:coach:user_id"] = 'The UserID of the user';
$string["privacy:metadata:invit"] = 'The currently active invitations to view the study plan';
$string["privacy:metadata:invit:date"] = 'Date the invitation was created';
$string["privacy:metadata:invit:email"] = 'Email address of the invitations recipient';
$string["privacy:metadata:invit:identifier"] = 'Tag provided by the educational institute for this invitation';
$string["privacy:metadata:invit:name"] = 'Name/Handle entered by the user for the invitations recipient';
$string["privacy:metadata:invit:unlockdate"] = 'If provided, invitation cannot be edited or deleted by user until this moment.';
$string["privacy:metadata:invit:user_id"] = 'UserID of the user who shared their study plan';
$string["privacy:metadata:lineuser"] = 'Registers a user as enrolled in a line within a studyplan';
$string["privacy:metadata:lineuser:enrolled"] = 'Wether th user is enrolled or not';
$string["privacy:metadata:lineuser:enrolledby"] = 'Optional userid of another user who enrolled the user in this line';
$string["privacy:metadata:lineuser:line_id"] = 'The study line the user is enrolled in (or not)';
$string["privacy:metadata:lineuser:timeenrolled"] = 'The moment of enrolment';
$string["privacy:metadata:lineuser:user_id"] = 'The UserID of the user';
$string["privacy:metadata:teachers"] = 'Cached table for linking teachers to study plans';
$string["privacy:metadata:teachers:studyplan_id"] = 'The study plan in which the teacher teaches at least one course';
$string["privacy:metadata:teachers:teacher_id"] = 'The UserID of the teacher';
$string["privacy:metadata:user"] = 'Links between individual users and study plans';
$string["privacy:metadata:user:studyplan_id"] = 'The study plan';
$string["privacy:metadata:user:user_id"] = 'The UserID of the user';
$string["refreshteacherlist_name"] = "Refresh teacher's study plan list";
$string["report"] = 'Progress report';
$string["report_index"] = 'View student progress reports';
$string["report_invited"] = 'Progress report for {$a}';
$string["required"] = 'Required';
$string["required_goal"] = 'Required objective';
$string['result'] = 'Result';
$string["results"] = 'Results';
$string["search"] = "Search";
$string["select_conditions"] = 'Completion condition';
$string["select_grades"] = 'Grades included in report';
$string["select_scaleitem"] = 'Choose...';
$string["selected"] = 'Select';
$string["selectstudent"] = "Choose student";
$string["selectstudent_btn"] = "Select view";
$string["selectstudent_details"] = "Pick a student from the list below to see their progress in this study plan";
$string["send"] = "Send";
$string["setting_aggregation_mode"] = "Default aggregation style";
$string["setting_bistate_accept_pending_submitted"] = 'Accept submitted but ungraded result as "progress"';
$string["setting_bistate_heading"] = 'Defaults for Completed + Required objectives';
$string["setting_bistate_support_failed"] = 'Support "Failed" result';
$string["setting_bistate_thresh_completed"] = 'Threshold for completed (%)';
$string["setting_bistate_thresh_excellent"] = 'Threshold for excellent (%)';
$string["setting_bistate_thresh_good"] = 'Threshold for good (%)';
$string["setting_bistate_thresh_progress"] = 'Threshold for progress (%)';
$string["setting_competency_detailfield"] = 'Competency detail field';
$string["setting_competency_displayname"] = 'Competency display title';
$string["setting_competency_heading"] = 'Defults for course competencies ';
$string["setting_competency_support_failed"] = 'Support "Failed" result';
$string["setting_competency_thresh_completed"] = 'Threshold for completed (%)';
$string["setting_continueperiodnumberingnewpage"] = 'Continue periode numbering on new page';
$string["setting_copystudylinesnewpage"] = 'Copy study lines of last page to new page';
$string["setting_courseprogressbar"] = 'Show progress bar in course';
$string["setting_csync_autoremove_field"] = 'Automatic deletion';
$string["setting_csync_creategroup_field"] = 'Create groups';
$string["setting_csync_enable_field"] = 'Automatic cohort sync';
$string["setting_csync_heading"] = 'Automatically create a cohort sync in all courses linked to a study plan for all cohorts linked to a study plan.';
$string["setting_csync_remember_manual_csync_field"] = 'Remember existing cohort-syncs';
$string["setting_csync_role_field"] = 'Role';
$string["setting_csync_users_field"] = 'Enroll linked users';
$string["setting_defaulticon"] = 'Default studyplan image';
$string["setting_display_field"] = 'Course display name';
$string["setting_display_heading"] = 'Display';
$string["setting_enablecoach"] = 'Enable coach role';
$string["setting_enableplansharing"] = 'Enable sharing of study plan';
$string["setting_feature_heading"] = 'Features';
$string["setting_hivizdropslots"] = 'High visibility drop fields';
$string["setting_infofield1_field"] = 'Add course details from field (1)';
$string["setting_infofield1_position"] = 'Position of course info field (1)';
$string["setting_infofield1_title"] = 'Title for course details from field (1).';
$string["setting_infofield2_field"] = 'Add course details from field (2)';
$string["setting_infofield2_position"] = 'Position of course info field (2)';
$string["setting_infofield2_title"] = 'Title for course details from field (2).';
$string["setting_infofield3_field"] = 'Add course details from field (3)';
$string["setting_infofield3_position"] = 'Position of course info field (3)';
$string["setting_infofield3_title"] = 'Title for course details from field (3).';
$string["setting_infofield4_field"] = 'Add course details from field (4)';
$string["setting_infofield4_position"] = 'Position of course info field (4)';
$string["setting_infofield4_title"] = 'Title for course details from field (4).';
$string["setting_infofield5_field"] = 'Add course details from field (5)';
$string["setting_infofield5_position"] = 'Position of course info field (5)';
$string["setting_infofield5_title"] = 'Title for course details from field (5).';
$string["setting_infofields_heading"] = 'Extra course information fields';
$string["setting_limitcourselist"] = 'Limit course list to study plan category';
$string["setting_primary_nav_combine"] = 'Combine primary navigation menu links under one dropdown';
$string["setting_primary_nav_items"] = 'Add studyplan links to primary navigation menu';
$string["setting_showprevnextarrows"] = 'Show arrows next to student selector dropdowns';
$string["setting_timelessperiods"] = 'Timeless periods and pages';
$string["setting_toolboxcoursesonly"] = 'Show only the courses in the toolbox';
$string["setting_toolboxleft"] = 'Toolbar left side by default';
$string["settingdesc_aggregation_mode"] = "Choose a default aggregation style for new study plans";
$string["settingdesc_bistate_accept_pending_submitted"] = 'If enabled, submitted but ungraded objectives will still count toward progress. If disabled, only graded objectives will count';
$string["settingdesc_bistate_heading"] = 'Set the defaults for this aggregation method';
$string["settingdesc_bistate_support_failed"] = 'When the course end date has passed, mark course as "Failed" instead of "Progress"';
$string["settingdesc_bistate_thresh_completed"] = 'Minimum percentage of objectives completed for result "Completed"';
$string["settingdesc_bistate_thresh_excellent"] = 'Minimum percentage of objectives completed for result "Excellent"';
$string["settingdesc_bistate_thresh_good"] = 'Minimum percentage of objectives completed for result "Good"';
$string["settingdesc_bistate_thresh_progress"] = 'Minimum percentage of objectives that should not be failed in order to qualify for progress result. <br><strong>Only relevant if "Failed" results are supported</strong>';
$string["settingdesc_competency_detailfield"] = 'The competency field used for competency details';
$string["settingdesc_competency_displayname"] = 'The competency field used as it\'s title in the studyplan';
$string["settingdesc_competency_heading"] = 'Set the defaults for this aggregation method';
$string["settingdesc_competency_support_failed"] = 'When the course end date has passed, mark course as "Failed" instead of "Progress"';
$string["settingdesc_competency_thresh_completed"] = 'Minimum percentage of proficient competencies for result "Completed';
$string["settingdesc_continueperiodnumberingnewpage"] = 'When creating a new page, the default name of the periods will continue the existing sequence (e.g. P5, P6, P7, P8) instead of starting a new sequence (P1, P2, P3, P4)';
$string["settingdesc_copystudylinesnewpage"] = 'When creating a new page, fill it with an empty copy of the study lines from the last page.';
$string["settingdesc_courseprogressbar"] = 'Show a progress bar in the course pop-up.';
$string["settingdesc_csync_autoremove_field"] = 'Delete synchronization from courses once a cohort is removed from the study plan.';
$string["settingdesc_csync_creategroup_field"] = 'Create a group in the course for each cohort sync.';
$string["settingdesc_csync_enable_field"] = 'Enable automatic cohort sync.';
$string["settingdesc_csync_heading"] = '';
$string["settingdesc_csync_remember_manual_csync_field"] = 'Mark cohort syncs that were manually created earlier, so they won\'t be removed during auto sync if cohorts are removed from the study plan.';
$string["settingdesc_csync_role_field"] = 'The role to use for automatic cohort sync enrollment created in courses.';
$string["settingdesc_csync_users_field"] = 'Also enrol all users that are explicitly linked to a study plan in that study plan\'s courses.';
$string["settingdesc_defaulticon"] = 'Configure default image to show for a study plans if no specific image is set.';
$string["settingdesc_display_field"] = 'Select the field to use for the display name of a course in the study plan.';
$string["settingdesc_display_heading"] = 'Study plan display settings.';
$string["settingdesc_enablecoach"] = 'The coach role allows one coach specific access to one study plan with limited access to modify it.';
$string["settingdesc_enableplansharing"] = 'Allow students to share access to the study plan with others through a unique link.';
$string["settingdesc_feature_heading"] = 'Configure studyplan features.';
$string["settingdesc_hivizdropslots"] = 'Give the drop fields when editing a study plan extra visibility.';
$string["settingdesc_infofield1_field"] = 'Information field to show';
$string["settingdesc_infofield1_position"] = 'Where to place this info field in the course pop-up screen';
$string["settingdesc_infofield1_title"] = 'Title for course info field. One line per language. End with "|<langcode>"  to localize. Leave empty to set no title';
$string["settingdesc_infofield2_field"] = 'Information field to show';
$string["settingdesc_infofield2_position"] = 'Where to place this info field in the course pop-up screen';
$string["settingdesc_infofield2_title"] = 'Title for course info field. One line per language. End with "|<langcode>"  to localize. Leave empty to set no title';
$string["settingdesc_infofield3_field"] = 'Information field to show';
$string["settingdesc_infofield3_position"] = 'Where to place this info field in the course pop-up screen';
$string["settingdesc_infofield3_title"] = 'Title for course info field. One line per language. End with "|<langcode>"  to localize. Leave empty to set no title';
$string["settingdesc_infofield4_field"] = 'Information field to show';
$string["settingdesc_infofield4_position"] = 'Where to place this info field in the course pop-up screen';
$string["settingdesc_infofield4_title"] = 'Title for course info field. One line per language. End with "|<langcode>"  to localize. Leave empty to set no title';
$string["settingdesc_infofield5_field"] = 'Information field to show';
$string["settingdesc_infofield5_position"] = 'Where to place this info field in the course pop-up screen';
$string["settingdesc_infofield5_title"] = 'Title for course info field. One line per language. End with "|<langcode>"  to localize. Leave empty to set no title';
$string["settingdesc_infofields_heading"] = 'Select up to 5 fields or custom fields to add to the course pop-up.';
$string["settingdesc_limitcourselist"] = 'Limit the list of available courses for a study plan to the category the studyplan is located in.';
$string["settingdesc_primary_nav_combine"] = 'Combine all available primary navigation links for the studyplan plugin under one dropdown item, if there are multiple links';
$string["settingdesc_primary_nav_items"] = 'Add links for the studyplan to the primary menu. Note that if you disable this, you will have to add your own links to the studyplan pages.';
$string["settingdesc_showprevnextarrows"] = 'Show arrows for previous and next student in the student selector in coach and view mode.';
$string["settingdesc_timelessperiods"] = 'Do not include timing info in periods or pages.';
$string["settingdesc_toolboxcoursesonly"] = 'Hide the badges and flow tabs in the toolbox and show only the courses.';
$string["settingdesc_toolboxleft"] = 'Show the course and component toolbar on the left by default, instead of the right side of the screen.';
$string["settingspage"] = 'Study plan settings';
$string["settingspage_csync"] = 'Synchronize linked cohorts and users to courses';
$string["share_badge"] = "Share badge";
$string["share_report"] = 'Share';
$string["showoverview"] = "Teacher view";
$string["student_from_plan_enrolled"] = 'student in this study plan is enrolled in the course';
$string["student_not_tracked"] = 'Not enrolled in this course';
$string["students_from_plan_enrolled"] = 'students in this study plan are enrolled in the course';
$string["studyitem_confirm_remove"] = 'Are you sure you want to remove module {$a}?';
$string["studyline_add"] = 'Add study line';
$string["studyline_color"] = 'Background color';
$string["studyline_confirm_remove"] = 'Are you sure you want to remove study line {$a}?';
$string["studyline_edit"] = 'Edit study line';
$string["studyline_editmode"] = 'Edit study lines';
$string["studyline_enrollable"] = 'Registration';
$string["studyline_enrolroles"] = 'Allowed roles';
$string["studyline_name"] = 'Full name';
$string["studyline_name_ph"] = '';
$string["studyline_remove"] = 'Remove study line';
$string["studyline_shortname"] = 'Short name';
$string["studyline_shortname_ph"] = '';
$string["studyplan_add"] = 'Add study plan';
$string["studyplan_confirm_remove"] = 'Are you sure you want to remove study plan page {$a}?';
$string["studyplan_context"] = 'Category';
$string["studyplan_description"] = 'Description';
$string["studyplan_description_ph"] = '';
$string["studyplan_details"] = 'About';
$string["studyplan_duration"] = 'Duration';
$string["studyplan_edit"] = 'Edit study plan';
$string["studyplan_emptytemplate"] = "Empty study plan";
$string["studyplan_enddate"] = 'End date of plan';
$string["studyplan_fromtemplate"] = 'Based on template';
$string["studyplan_future"] = "Upcoming study plans";
$string["studyplan_icon"] = "Image for this studyplan";
$string["studyplan_idnumber"] = 'ID Number';
$string["studyplan_idnumber_ph"] = '';
$string["studyplan_name"] = 'Full name';
$string["studyplan_name_ph"] = '';
$string["studyplan_noneselected"] = "Pick a study plan";
$string["studyplan_past"] = "Past study plans";
$string["studyplan_periods"] = 'Number of periods in plan';
$string["studyplan_present"] = "Current study plans";
$string["studyplan_remove"] = 'Remove study plan';
$string["studyplan_report"] = 'Studyplan result overview';
$string["studyplan_select"] = "Study plan:";
$string["studyplan_select_placeholder"] = "Select study plan";
$string["studyplan_shortname"] = 'Short name';
$string["studyplan_shortname_ph"] = '';
$string["studyplan_slots"] = 'Number of columns in plan';
$string["studyplan_startdate"] = 'Start date of plan';
$string["studyplan_suspend"] = 'Suspend study plan';
$string["studyplan_suspend_details"] = 'Suspend studyplan for all except studyplan managers';
$string["studyplan_template"] = 'Mark as template';
$string["studyplan_template_details"] = 'Mark this studyplan as a possible template for new studyplans';
$string["studyplanpage"] = 'Study plan page';
$string["studyplanpage_add"] = 'Add study plan page';
$string["studyplanpage_confirm_remove"] = 'Are you sure you want to remove study plan page {$a}?';
$string["studyplanpage_edit"] = 'Edit study plan page';
$string["studyplanpage_info_periodsextended"] = 'Warning: You have added periods to the study plan page. These new periods have automatically generated timespans that may lie outside of this pages designated end time. Please verify the correct start and end times for each period.';
$string["studyplanpage_remove"] = 'Remove study plan page';
$string["suspended"] = "Suspended";
$string["tool-badge"] = 'Badge';
$string["tool-finish"] = 'Finish';
$string["tool-junction"] = 'Junction';
$string["tool-start"] = 'Start/continue';
$string["toolbar-right"] = 'Show this bar at the right';
$string["toolbox"] = 'Components';
$string["toolbox_toggle"] = 'Insert components and courses';
$string["treestudyplan:coach"] = "Available as coach";
$string["treestudyplan:configure"] = "Configure study plans";
$string["treestudyplan:editstudyplan"] = "Manage study plans";
$string["treestudyplan:forcescales"] = 'Advanced: Allow study plan manager to force assignment scales to setting (manual modes only)';
$string["treestudyplan:lineunenrol"] = "Manage student registration in lines";
$string["treestudyplan:manageshares"] = "Manage mandatory studyplan sharing";
$string["treestudyplan:selectowngradables"] = 'Teachers can select gradables in their own courses in study plan view mode (manual modes only)';
$string["treestudyplan:viewuserreports"] = "View study plan of others";
$string["tristate_aggregator_desc"] = 'Objectives are graded progress, completed and excellent. Modules can be configured to require a specific amount of completed objectives';
$string["tristate_aggregator_title"] = 'Manual: Progress/Completed/Excellent Classic';
$string["ungraded"] = 'Needs grading';
$string["unknown"] = 'Grading status unknown';
$string["unrated"] = 'Unrated';
$string["unsubmitted"] = 'No submission';
$string["uploadshares"] = 'Upload mandatory studyplan shares';
$string["uploadshares_created"] = 'Number of shares created: {$a}';
$string["uploadshares_errors"] = 'Number of errors: {$a}';
$string["uploadshares_help"] = 'Upload a CSV file of mandatory studplan shares here. The CSV file needs the following columns: <ul><li><b>userid</b> Userid of the user to add the share for.</li><li><b>inviteename</b> Name or title of the share recipient.</li><li><b>inviteemail</b> Email address of the share recipient.</li><li><b>unlockdate</b> The date on which the share is unlocked and the user can modify or delete it themselves.</li><li><b>identifier</b> <i>(optional)</i> An optional identifier tag to this share</li>';
$string["uploadshares_result:created"] = 'Created';
$string["uploadshares_result:dateinvalid"] = 'Invalid date format';
$string["uploadshares_result:datepast"] = 'Unlock date in the past.';
$string["uploadshares_result:emailinvalid"] = 'Invalid email address';
$string["uploadshares_result:exists"] = 'Already exists';
$string["uploadshares_result:updated"] = 'Updated';
$string["uploadshares_result:usernotfound"] = 'User not found';
$string["uploadshares_results"] = 'Upload mandatory shares results';
$string["uploadshares_skipped"] = 'Number of lines skipped: {$a}';
$string["uploadshares_total"] = 'Number of lines handled: {$a}';
$string["uploadshares_updated"] = 'Number of shares updated: {$a}';
$string["users"] = 'Users';
$string["view_completion_report"] = 'View detailed course completion report';
$string["view_feedback"] = 'View feedback';
$string["view_plan"] = 'View study plans';
$string["warning_incomplete_nograderq"] = 'Because the grade is not marked as a requirement, your passing grade is not registering completion.';
$string["warning_incomplete_pass"] = 'The passing grade is not sufficient for completing the assignment, check the completion criteria.';
$string["when"] = "when";
