<?php
// This file is part of the study plan plugin for Moodle
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin version
 * @package    local_treestudyplan
 * @copyright  2023 P.M. Kuipers
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
defined('MOODLE_INTERNAL') || die();

$plugin->component = 'local_treestudyplan';  // Recommended since 2.0.2 (MDL-26035). Required since 3.0 (MDL-48494).
$plugin->version = 2025102401;  // YYYYMMDDHH (year, month, day, iteration).
$plugin->requires = 2024042200; // YYYYMMDDHH (This is the release version for Moodle 4.4).
$plugin->release = "1.3.22";
$plugin->maturity = MATURITY_STABLE;

/* Supported from Moodle 4.4 to 5.0 */
$plugin->supported = [ 405, 501];

$plugin->dependencies = [
    'theme_boost' => 2024042200, // Version of boost theme in Moodle 4.4.
];
