<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This file contains the backup activity for the LabNBook module
 *
 * @package mod_labnbook
 * @copyright   2024 Université Grenoble Alpes
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


defined('MOODLE_INTERNAL') || die();
require_once(dirname(__FILE__) . '/backup_labnbook_stepslib.php');


/**
 * LabNBook backup task class that provides all the settings and steps to perform it
 *
 * @package mod_labnbook
 * @copyright   2024 Université Grenoble Alpes
 * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class backup_labnbook_activity_task extends backup_activity_task {
    /**
     * Server settings
     */
    protected function define_my_settings() {
    }

    /**
     * Define (add) particular steps this activity can have
     */
    protected function define_my_steps() {
        $this->add_step(new backup_labnbook_activity_structure_step('labnbook_structure', 'labnbook.xml'));
    }

    /**
     * Code the transformations to perform in the activity in
     * order to get transportable (encoded) links
     * @param string $content
     */
    public static function encode_content_links($content) {
        global $CFG;

        $base = preg_quote($CFG->wwwroot, "/");

        // Link to the list of labnbook.
        $search = "/(" . $base . "\/mod\/labnbook\/index.php\?id\=)([0-9]+)/";
        $content = preg_replace($search, '$@LABNBOOKINDEX*$2@$', $content);

        return $content;
    }
}
