<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

namespace qbehaviour_certaintywithstudentfbdeferred\output;

use core\output\named_templatable;
use help_icon;
use renderer_base;

/**
 * Renderable widget extending standard help_icon, allowing sending dynamic data to help text string (via standard $a object).
 * @package    qbehaviour_certaintywithstudentfbdeferred
 * @copyright  2025 Astor Bizard
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class dynamic_help_icon extends help_icon implements named_templatable {

    /**
     * @var string|object|array|null Additional data for help text string.
     */
    protected $a;

    /**
     * Constructor.
     * @param string $identifier string for help page title,
     *  string with _help suffix is used for the actual help text.
     *  string with _link suffix is used to create a link to further info (if it exists)
     * @param string $component
     * @param string|object|array|null $a An object, string or number that can be used within translation strings
     */
    public function __construct($identifier, $component, $a = null) {
        parent::__construct($identifier, $component);
        $this->a = $a;
    }

    /**
     * {@inheritDoc}
     * @param renderer_base $output Used to do a final render of any components that need to be rendered for export.
     * @see help_icon::export_for_template()
     */
    public function export_for_template(renderer_base $output) {
        $data = parent::export_for_template($output);

        $customdata = get_formatted_help_string($this->identifier, $this->component, false, $this->a);

        foreach ($customdata as $key => $value) {
            $data->$key = $value;
        }

        return $data;
    }

    /**
     * {@inheritDoc}
     * @param renderer_base $renderer The renderer requesting the template name
     * @see named_templatable::get_template_name()
     */
    public function get_template_name(renderer_base $renderer): string {
        return 'core/help_icon';
    }
}
