/**
 * Defines the behavior of the student's answer form for a vplquestion.
 * @copyright  Astor Bizard, 2019
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("qtype_vplquestion/studentanswer",["jquery","core/modal_factory","core/modal_events","core/templates","qtype_vplquestion/codeeditors","qtype_vplquestion/vplservice","qtype_vplquestion/scriptsloader"],(function($,ModalFactory,ModalEvents,Templates,CodeEditors,VPLService,ScriptsLoader){function str(key){switch(key){case"console":return"[Process";case"connected":case"connecting":case"running":return"running]";case"connection_closed":return"exited]";default:return key}}function makeResultHtml(result,field,level){if(result[field]){var formattedText="";return(text=result[field],map={"&":"&amp;","<":"&lt;",">":"&gt;",'"':"&quot;","'":"&#039;"},text.replace(/[&<>"']/g,(function(c){return map[c]}))).split("\n").forEach((function(line){"-"==line.charAt(0)&&(line='<span class="vpl-test-title font-italic rounded px-1">'+line+"</span>"),formattedText+=line+"\n"})),'<span class="vpl-result-title vpl-title-'+level+' d-block font-weight-bold border border-dark pl-1 mb-1">'+M.util.get_string(field,"qtype_vplquestion")+"</span>"+formattedText.trim()}var text,map;return""}function displayResult(displayId,result){var $display=$("#"+displayId);null===result&&(result=$display.data("result"));var html=makeResultHtml(result,"compilation","error")+makeResultHtml(result,"evaluation","info")+makeResultHtml(result,"execerror","error")+makeResultHtml(result,"evaluationerror","error");html||(html=makeResultHtml(result,"execution","error")),$display[html?"show":"hide"](),$display.html(html)}return{setup:function(questionId,vplId,userId,textareaName,vplVersion){var $textarea=$('textarea[name="'+textareaName+'"]'),$resetAndCorrectionButtons=$("#qvpl_reset_q"+questionId+", #qvpl_correction_q"+questionId);CodeEditors.setupQuestionEditor($textarea,$resetAndCorrectionButtons,$textarea.data("lineoffset")).done((function(){"readonly"!=$textarea.attr("readonly")&&ScriptsLoader.loadVPLTerminal(vplVersion,(function(){var oldPrototype=Terminal.prototype;Terminal=function(data){return data.rows=10,new oldPrototype.constructor(data)},Terminal.prototype=oldPrototype;var wrapperId="terminal_wrapper_q"+questionId,terminal=new VPLTerminal(wrapperId,wrapperId,str);"function"==typeof $("#"+wrapperId).dialog&&$("#"+wrapperId).dialog("option","draggable",!1),terminal.setMessage=function(){};var qvplButtons="#qvpl_buttons_q"+questionId,$globalTerminalWrapper=$("#"+wrapperId).parent();$globalTerminalWrapper.insertAfter(qvplButtons);var oldConnect=terminal.connect;terminal.connect=function(){oldConnect.apply(terminal,arguments),$globalTerminalWrapper.css("top",0).css("left",0),$("body > .ui-widget-overlay.ui-front").first().remove()},$globalTerminalWrapper.find(".ui-dialog-titlebar-close").html('<i class="fa fa-close"></i>').addClass("btn btn-secondary close-terminal");var setupButton=function(action,icon,filestype){var $button=$(qvplButtons+' button[data-action="'+action+'"]'),$icon=$('<i class="fa fa-'+icon+'"></i>');$('<span class="ml-2">').append($icon).appendTo($button);var reenableButtons=function(){$icon.attr("class","fa fa-"+icon),$(".qvpl-buttons *").removeAttr("disabled")};$button.click((function(){$(".qvpl-buttons *").attr("disabled","disabled"),$(".close-terminal").trigger("click"),$icon.attr("class","fa fa-refresh fa-spin"),VPLService.call("save",vplId,questionId,$textarea.val(),filestype).then((function(){return VPLService.call("exec",action,vplId,userId,terminal,(function(result){displayResult("vpl_result_q"+questionId,result),reenableButtons()}))})).fail((function(details){displayResult("vpl_result_q"+questionId,{execerror:details}),reenableButtons()}))}))};setupButton("run","rocket","run"),setupButton("debug","check-square-o","precheck"),setupButton("evaluate","check-square-o","precheck")}))})),Templates.render("qtype_vplquestion/editorpreferencesform",{qid:questionId,installedthemes:JSON.parse(document.querySelector("[data-role=qvpl_installedthemes]").dataset.themes)}).done((function(formHTML){$.when(CodeEditors.getEditorPreferences(),ModalFactory.create({type:ModalFactory.types.SAVE_CANCEL,title:'<i class="fa fa-fw fa-cog icon"></i>'+M.util.get_string("editoroptions","qtype_vplquestion"),body:formHTML})).done((function(prefs,modal){modal.attachToDOM();var $fontSizeInput=modal.getBody().find('[name="vpl_fontsize'+questionId+'"]');$fontSizeInput.val(prefs.fontSize);var $aceThemeInput=modal.getBody().find('[name="vpl_editortheme'+questionId+'"]');$aceThemeInput.val(prefs.aceTheme);var prevFontSize=$fontSizeInput.val();$fontSizeInput.on("input",(function(){var newFontSize=Number($(this).val());isNaN(newFontSize)?$(this).val(prevFontSize):(newFontSize<1?newFontSize=1:newFontSize>48&&(newFontSize=48),$(this).val(newFontSize),prevFontSize=newFontSize,CodeEditors.changeFontSize(newFontSize))})),modal.getBody().find('[data-role="fontsizeincr"]').click((function(){$fontSizeInput.val(Number($fontSizeInput.val())+1),$fontSizeInput.trigger("input")})),modal.getBody().find('[data-role="fontsizedecr"]').click((function(){$fontSizeInput.val(Number($fontSizeInput.val())-1),$fontSizeInput.trigger("input")})),$aceThemeInput.on("change",(function(){CodeEditors.changeTheme($(this).val())})),modal.getRoot().on(ModalEvents.save,(function(){$fontSizeInput.data("save",$fontSizeInput.val()),$aceThemeInput.data("save",$aceThemeInput.val()),CodeEditors.saveEditorPreferences($aceThemeInput.val(),$fontSizeInput.val())})),modal.getRoot().on(ModalEvents.shown,(function(){$fontSizeInput.data("save",$fontSizeInput.val()),$aceThemeInput.data("save",$aceThemeInput.val())})),modal.getRoot().on(ModalEvents.hidden,(function(){$fontSizeInput.val($fontSizeInput.data("save")),$aceThemeInput.val($aceThemeInput.data("save")),CodeEditors.changeFontSize($fontSizeInput.val()),CodeEditors.changeTheme($aceThemeInput.val()),$('[name^="vpl_fontsize"]').val($fontSizeInput.val()),$('[name^="vpl_editortheme"]').val($aceThemeInput.val())})),$("#qvpl_editor_preferences"+questionId).css("visibility","visible").click((function(){modal.show()}))}))}))},displayResult:displayResult}}));

//# sourceMappingURL=studentanswer.min.js.map