/**
 * Charts postprocessing for "Single Quiz" certainty report.
 * @copyright  2025 Astor Bizard, 2024 Loic Delon
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("report_certaintyquizzes/singlequiz",["jquery","core/chartjs","core/notification","core/url","qbehaviour_certaintywithstudentfbdeferred/charts_utility","core/templates"],(function($,ChartJS,Notification,Url,ChartsUtility,Templates){var component="report_certaintyquizzes",behaviourComponent="qbehaviour_certaintywithstudentfbdeferred",courseid=null,quizid=null,attempttype=null;function formatIntervalsChart(chart,chartName,xAxisTitle,usersByInterval){chart.options.scales.y.ticks.stepSize=1,chart.options.scales.y.title.display=!0,chart.options.scales.y.title.text=M.util.get_string("numofstudents",component),chart.options.scales.x.title.display=!0,chart.options.scales.x.title.text=xAxisTitle,chart.options.scales.x.ticks.autoSkip=!1,chart.canvas.onclick=function(evt){const points=chart.getElementsAtEventForMode(evt,"nearest",{intersect:!0},!0);points.length>0&&function(userids,clickedElementIndex,chartName){let sidebar=document.getElementById("charts-sidebar-"+chartName),chartContainer=document.getElementById("charts-content-"+chartName);if(sidebar.dataset.selectedNum==clickedElementIndex)return sidebar.hidden=!0,chartContainer.classList.remove("reducedwidth"),void(sidebar.dataset.selectedNum=-1);sidebar.dataset.selectedNum=clickedElementIndex,$.ajax({url:Url.relativeUrl("/report/certaintyquizzes/ajax/get_user_attempt_data.php"),data:{courseid:courseid,usersids:userids,quizid:quizid,attempttype:attempttype,sortcolumn:"grades"===chartName?"grade":"lucidityindex"}}).then((function(res){if(!res.success)throw new Error(res.error);sidebar.innerHTML=res.response,sidebar.hidden=!1,chartContainer.classList.add("reducedwidth")})).fail(Notification.exception)}(usersByInterval[points[0].index],points[0].index,chartName)},chart.options.plugins.tooltip.callbacks.footer=function(){return M.util.get_string("clickfordetails",behaviourComponent)}}function formatQuestionsCharts(chart){chart.options.scales.x.ticks.autoSkip=!1,chart.options.scales.x.title.display=!0,chart.options.scales.x.title.text=M.util.get_string("question","moodle"),chart.options.scales.y.ticks.stepSize=1,chart.options.scales.y.title.display=!0,chart.options.scales.y.title.text=M.util.get_string("numofstudents",component),chart.canvas.onclick=function(evt){const points=chart.getElementsAtEventForMode(evt,"nearest",{intersect:!0},!0);points.length>0&&function(clickedElementindex){var sidebar=document.getElementById("charts-sidebar-question"),chartsContainer=document.getElementById("charts-content-question"),questionSlot=clickedElementindex+1;if(sidebar.dataset.currentQuestion==questionSlot)return sidebar.hidden=!0,chartsContainer.classList.remove("reducedwidth"),void(sidebar.dataset.currentQuestion=-1);sidebar.dataset.currentQuestion=questionSlot,$.ajax({url:Url.relativeUrl("/report/certaintyquizzes/ajax/get_quiz_question_data.php"),data:{courseid:courseid,quizid:quizid,questionslot:questionSlot,attempttype:attempttype}}).then((function(res){if(!res.success)throw new Error(res.error);for(var questionData=res.response;sidebar.firstChild;)sidebar.firstChild.remove();var container=document.createElement("div");container.classList.add("w-100","border","border-dark","overflow-hidden","bg-white","m-4");var questionSummaryContainer=document.createElement("div");questionSummaryContainer.classList.add("p-3","overflow-auto"),questionSummaryContainer.innerHTML=questionData.questionsummary,container.appendChild(questionSummaryContainer);var chartRole=component+"_answers-chart",chartCanvas=document.querySelector("[data-role="+chartRole+"] .chart-area canvas");if(ChartJS.getChart(chartCanvas)&&ChartJS.getChart(chartCanvas).destroy(),questionData.chartdata.length>0){var chartContainer=document.createElement("div");chartContainer.classList.add("py-2","px-3","border-top","border-dark"),chartContainer.style.minHeight="48vh",Templates.renderForPromise(behaviourComponent+"/loadingchart",{role:chartRole,chartcontext:{chartdata:questionData.chartdata,withtable:!0}}).then((_ref=>{let{html:html,js:js}=_ref;Templates.replaceNodeContents(chartContainer,html,js),ChartsUtility.executeWhenChartLoaded(chartRole,(function(answersChart){answersChart.options.scales.x.ticks.autoSkip=!1,answersChart.options.scales.x.title.display=!0,answersChart.options.scales.x.title.text=M.util.get_string("answer","moodle"),answersChart.options.scales.y.ticks.stepSize=1,answersChart.options.scales.y.title.display=!0;var yAxisTitle=M.util.get_string("numofanswers",behaviourComponent);answersChart.options.scales.y.title.text=yAxisTitle,answersChart.update()}))})).catch(Notification.exception),container.appendChild(chartContainer)}sidebar.appendChild(container),sidebar.hidden=!1,chartsContainer.classList.add("reducedwidth")})).fail(Notification.exception)}(points[0].index)},chart.options.plugins.tooltip.callbacks.footer=function(){return M.util.get_string("clickfordetails",behaviourComponent)}}return{postprocess:function(ajaxData,useridsByGradeInterval,useridsByLucidityInterval,totalStudents){courseid=ajaxData.courseid,quizid=ajaxData.quizid,attempttype=ajaxData.attempttype,ChartJS.defaults.font.size=15,ChartsUtility.executeWhenChartLoaded(component+"_students-by-grade",(function(gradesChart){formatIntervalsChart(gradesChart,"grades",M.util.get_string("gradeover100",component),useridsByGradeInterval),gradesChart.update()})),ChartsUtility.executeWhenChartLoaded(component+"_students-by-lucidity",(function(lucidityChart){formatIntervalsChart(lucidityChart,"lucidity",M.util.get_string("lucidityindex",behaviourComponent),useridsByLucidityInterval),lucidityChart.update()})),ChartsUtility.executeWhenChartLoaded(component+"_grade-by-question-chart",(function(questionsGradesChart){questionsGradesChart.options.scales.y.min=0,questionsGradesChart.options.scales.y.max=totalStudents,formatQuestionsCharts(questionsGradesChart),questionsGradesChart.update()})),ChartsUtility.executeWhenChartLoaded(component+"_certainty-by-question-chart",(function(answerClassesChart){formatQuestionsCharts(answerClassesChart),answerClassesChart.update()}))}}}));

//# sourceMappingURL=singlequiz.min.js.map