<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_certaintyquizzes', language 'en'
 * @package    report_certaintyquizzes
 * @copyright  2025 Astor Bizard, 2024 Loic Delon
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['allusers'] = 'All users';
$string['answercategoriesbyanswer'] = 'Categories by answer';
$string['answercategoriesbyquestion'] = 'Answer categories by question';
$string['attempttype'] = 'Attempt type';
$string['attempttype_help'] = 'Select the attempt that will be considered for each user.';
$string['attempttypebestgrade'] = 'Best attempt';
$string['attempttypefirst'] = 'First attempt';
$string['attempttypelatest'] = 'Last attempt';
$string['attemptxofy'] = '{$a->x} of {$a->y}';
$string['certaintyquizzes:view'] = 'View report for all students';
$string['certaintyquizzes:viewself'] = 'View report for own self';
$string['choicetitle'] = 'Choice {$a->i}: {$a->text}';
$string['choicetitlecorrect'] = 'Choice {$a->i} (correct answer): {$a->text}';
$string['dira'] = '<abbr class="text-info" title="Declared ignorance rate">DIR</abbr>: {$a}';
$string['gradeover100'] = 'Grade over 100';
$string['interval'] = 'Interval';
$string['interval_help'] = 'Select the size of each category for grade and lucidity index.';
$string['numcorrectbyquestion'] = 'Number of correct answers by question';
$string['numofstudents'] = 'Number of students';
$string['numstudentswithcorrectanswer'] = 'Number of students that gave a correct answer';
$string['pluginname'] = 'Certainty behaviour Quizzes reports';
$string['privacy:metadata'] = 'The Certainty behaviour Quizzes reports plugin does not store any personal data.';
$string['selectaquiz'] = 'Select a quiz';
$string['singlequiz'] = 'Single Quiz';
$string['studentsalongcourse'] = 'Evolution along Quizzes';
$string['studentsbygrade'] = 'Number of students by grade interval';
$string['studentsbylucidity'] = 'Number of students by lucidity index interval';
$string['valueforuser'] = '{$a->value} for {$a->user}';
$string['nocertaintyquizincourse'] = 'No quiz with a certainty behaviour found in course.';
$string['noattemptoncertaintyquizzesincourse'] = 'No attempt on quizzes with a certainty behaviour found in course.';
