define("report_certaintyquizzes/singlequiz",["exports","core/chartjs","qbehaviour_certaintywithstudentfbdeferred/charts_utility","core/notification","core/templates","report_certaintyquizzes/repository"],(function(_exports,_chartjs,_charts_utility,_notification,_templates,_repository){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}
/**
   * Charts postprocessing for "Single Quiz" certainty report.
   * @copyright  2025 Astor Bizard, 2024 Loic Delon
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.default=void 0,_chartjs=_interopRequireDefault(_chartjs),_charts_utility=_interopRequireDefault(_charts_utility),_notification=_interopRequireDefault(_notification),_templates=_interopRequireDefault(_templates),_repository=_interopRequireDefault(_repository);const component="report_certaintyquizzes",behaviourComponent="qbehaviour_certaintywithstudentfbdeferred";var courseid=null,quizid=null,questionids=[],usageids=[];function createCloseButton(){return createButton("fa-close","closebuttontitle","moodle")}function createButton(faIcon,str,component){var button=document.createElement("button");button.classList.add("btn","p-0"),button.type="button",button.title=M.util.get_string(str,component),button.ariaLabel=M.util.get_string(str,component);var icon=document.createElement("i");return icon.classList.add("fa",faIcon,"fa-lg"),button.appendChild(icon),button}function closeSidebar(sidebar,chartsContainer,dataAttr){sidebar.hidden=!0,chartsContainer.classList.remove("reducedwidth"),sidebar.dataset[dataAttr]=-1}async function toggleSidebarQuestion(questionIndex){var sidebar=document.getElementById("charts-sidebar-question"),chartsContainer=document.getElementById("charts-content-question"),questionid=questionids[questionIndex];if(sidebar.dataset.currentQuestion!=questionid){sidebar.dataset.currentQuestion=questionid;var questionData=await _repository.default.getQuestionData(courseid,questionid,usageids[questionIndex]),container=document.createElement("div");container.classList.add("w-100","border","border-dark","overflow-hidden","bg-white","m-4");var titleBar=document.createElement("div");titleBar.classList.add("mb-2","align-items-center"),titleBar.style.display="grid",titleBar.style.gridTemplateColumns="auto 1fr auto auto",titleBar.style.gap="1em";var prevButton=createButton("fa-caret-left","previous","moodle");prevButton.onclick=function(){var qindex=questionids.indexOf(questionid);qindex>0&&toggleSidebarQuestion(qindex-1)},titleBar.appendChild(prevButton);var questionTitle=document.createElement("div");questionTitle.classList.add("h6","m-0"),questionTitle.textContent=questionData.questiontitle,titleBar.appendChild(questionTitle);var nextButton=createButton("fa-caret-right","next","moodle");nextButton.onclick=function(){var qindex=questionids.indexOf(questionid);qindex<questionids.length-1&&toggleSidebarQuestion(qindex+1)},titleBar.appendChild(nextButton);var closeButton=createCloseButton();closeButton.onclick=()=>closeSidebar(sidebar,chartsContainer,"currentQuestion"),titleBar.appendChild(closeButton);var questionSummaryContainer=document.createElement("div");questionSummaryContainer.classList.add("p-3"),questionSummaryContainer.appendChild(titleBar);var questionSummarySubContainer=document.createElement("div");questionSummarySubContainer.classList.add("overflow-auto"),questionSummarySubContainer.innerHTML=questionData.questionsummary,questionSummaryContainer.appendChild(questionSummarySubContainer),container.appendChild(questionSummaryContainer),"object"==typeof MathJax&&"object"==typeof MathJax.Hub&&"function"==typeof MathJax.Hub.Queue&&MathJax.Hub.Queue(["Typeset",MathJax.Hub,container]);var chartRole=component+"_answers-chart",chartCanvas=document.querySelector("[data-role="+chartRole+"] .chart-area canvas");if(_chartjs.default.getChart(chartCanvas)&&_chartjs.default.getChart(chartCanvas).destroy(),questionData.chartdata.length>0){var chartContainer=document.createElement("div");chartContainer.classList.add("py-2","px-3","border-top","border-dark"),chartContainer.style.minHeight="48vh",_templates.default.renderForPromise(behaviourComponent+"/loadingchart",{role:chartRole,chartcontext:{chartdata:questionData.chartdata,withtable:!0}}).then((_ref=>{let{html:html,js:js}=_ref;_templates.default.replaceNodeContents(chartContainer,html,js),_charts_utility.default.executeWhenChartLoaded(chartRole,(function(answersChart){answersChart.options.scales.x.ticks.autoSkip=!1,answersChart.options.scales.x.title.display=!0,answersChart.options.scales.x.title.text=M.util.get_string("answer","moodle"),answersChart.options.scales.y.ticks.stepSize=1,answersChart.options.scales.y.title.display=!0,answersChart.options.scales.y.title.text=M.util.get_string("numofanswers",behaviourComponent),answersChart.update()}))})).catch(_notification.default.exception),container.appendChild(chartContainer)}sidebar.replaceChildren(container),sidebar.hidden=!1,chartsContainer.classList.add("reducedwidth")}else closeSidebar(sidebar,chartsContainer,"currentQuestion")}function formatIntervalsChart(chart,chartName,xAxisTitle,attemptsByInterval){chart.options.scales.y.ticks.stepSize=1,chart.options.scales.y.title.display=!0,chart.options.scales.y.title.text=M.util.get_string("numofstudents",component),chart.options.scales.x.title.display=!0,chart.options.scales.x.title.text=xAxisTitle,chart.options.scales.x.ticks.autoSkip=!1,chart.canvas.onclick=function(evt){const points=chart.getElementsAtEventForMode(evt,"nearest",{intersect:!0},!0);points.length>0&&async function(attemptids,clickedElementIndex,chartName){let sidebar=document.getElementById("charts-sidebar-"+chartName),chartContainer=document.getElementById("charts-content-"+chartName);if(sidebar.dataset.selectedNum!=clickedElementIndex){sidebar.dataset.selectedNum=clickedElementIndex;var sortColumn="grades"===chartName?"grade":"lucidityindex",table=await _repository.default.getUsersAttemptsData(courseid,quizid,attemptids,sortColumn),tableContainer=document.createElement("div");tableContainer.classList.add("w-100","position-relative","pt-5","mx-4"),tableContainer.innerHTML=table;var closeButton=createCloseButton();closeButton.style.position="absolute",closeButton.style.top=0,closeButton.style.right=0,closeButton.onclick=()=>closeSidebar(sidebar,chartContainer,"selectedNum"),tableContainer.prepend(closeButton),sidebar.replaceChildren(tableContainer),sidebar.hidden=!1,chartContainer.classList.add("reducedwidth")}else closeSidebar(sidebar,chartContainer,"selectedNum")}(attemptsByInterval[points[0].index],points[0].index,chartName)},chart.options.plugins.tooltip.callbacks.footer=function(){return M.util.get_string("clickfordetails",behaviourComponent)}}function formatQuestionsCharts(chart){chart.options.scales.x.ticks.autoSkip=!1,chart.options.scales.x.title.display=!0,chart.options.scales.x.title.text=M.util.get_string("question","moodle"),chart.options.scales.y.ticks.stepSize=1,chart.options.scales.y.title.display=!0,chart.options.scales.y.title.text=M.util.get_string("numofstudents",component),chart.canvas.onclick=function(evt){const points=chart.getElementsAtEventForMode(evt,"nearest",{intersect:!0},!0);points.length>0&&toggleSidebarQuestion(points[0].index)},chart.options.plugins.tooltip.callbacks.footer=function(){return M.util.get_string("clickfordetails",behaviourComponent)}}_exports.default={postprocess:function(ajaxData,attemptidsByGradeInterval,attemptidsByLucidityInterval,totalAttempts,questionIDs,usageIDs){courseid=ajaxData.courseid,quizid=ajaxData.quizid,questionids=questionIDs,usageids=usageIDs,_chartjs.default.defaults.font.size=15,_charts_utility.default.executeWhenChartLoaded(component+"_students-by-grade",(function(gradesChart){formatIntervalsChart(gradesChart,"grades",M.util.get_string("gradeover100",component),attemptidsByGradeInterval),gradesChart.update()})),_charts_utility.default.executeWhenChartLoaded(component+"_students-by-lucidity",(function(lucidityChart){formatIntervalsChart(lucidityChart,"lucidity",M.util.get_string("lucidityindex",behaviourComponent),attemptidsByLucidityInterval),lucidityChart.update()})),_charts_utility.default.executeWhenChartLoaded(component+"_grade-by-question-chart",(function(questionsGradesChart){questionsGradesChart.options.scales.y.min=0,questionsGradesChart.options.scales.y.max=totalAttempts,formatQuestionsCharts(questionsGradesChart),questionsGradesChart.update()})),_charts_utility.default.executeWhenChartLoaded(component+"_certainty-by-question-chart",(function(answerClassesChart){formatQuestionsCharts(answerClassesChart),answerClassesChart.update()}))}};return _exports.default}));

//# sourceMappingURL=singlequiz.min.js.map