# Certainty behaviour Quizzes report

## Installation

This plugins relies on the [qbehaviour_certaintywithstudentfbdeferred](https://moodle.org/plugins/qbehaviour_certaintywithstudentfbdeferred) plugin, and needs it to be installed.

## Description

This course report allows teachers to have a better overview of how students are using Quizzes with a "certainty" behaviour throughout the course.  
"Certainty" behaviours include ["Certainty with student feedback (deferred)"](https://moodle.org/plugins/qbehaviour_certaintywithstudentfbdeferred) and ["Certainty with student feedback (immediate)"](https://moodle.org/plugins/qbehaviour_certaintywithstudentfeedback) behaviours.  
It also provides a way to inspect multiple choice questions to identify where students make the most dangerous mistakes.

Students can also access the report to view their own progress throughout the course.

## Features of the report

### Evolution along Quizzes report

![Screenshot of navigation showing Evolution along Quizzes report](https://gricad-gitlab.univ-grenoble-alpes.fr/moodle-plugins/moodle-report_certaintyquizzes/-/raw/master/metadata/screenshots/report.png)

This report features charts showing the evolution of grade and lucidity index for students along all Quizzes in the course that use a certainty behaviour. This is meant to track global evolution of these indicators.  
Students can also access this report to see their own evolution.  

### Single Quiz report

![Screenshot of navigation showing Single Quiz report](https://gricad-gitlab.univ-grenoble-alpes.fr/moodle-plugins/moodle-report_certaintyquizzes/-/raw/master/metadata/screenshots/report2.png)

This report features analytics of results for a single Quiz that uses a certainty behaviour.  
Teachers can see grade and lucidity index distribution, as well as a detailed per-question report.  
For multiple choice questions, the detailed report is even enhanced with per-answer details, letting teachers know which answers are often selected and with which certainty level.  
![Screenshot of details for a multiple choice question about Moodle](https://gricad-gitlab.univ-grenoble-alpes.fr/moodle-plugins/moodle-report_certaintyquizzes/-/raw/master/metadata/screenshots/questiondetails.png)

## Related plugins

Quiz behaviours:  
[qbehaviour_certaintywithstudentfbdeferred](https://moodle.org/plugins/qbehaviour_certaintywithstudentfbdeferred)  
[qbehaviour_certaintywithstudentfeedback](https://moodle.org/plugins/qbehaviour_certaintywithstudentfeedback)

Quiz report:  
[quiz_certainty](https://moodle.org/plugins/quiz_certainty)  

## About

This software was developed with the Caseine project, with the support of the following organizations:  
- Université Grenoble Alpes  
- Institut Polytechnique de Grenoble

Contributors:
- Astor Bizard (developer and maintainer)
- Loïc Delon (contributor)
- Julien Douady & Christian Hoffmann (original idea, concept and review)
- Céline Chambon (concept and review)
