<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'report_certaintyquizzes', language 'en'
 * @package    report_certaintyquizzes
 * @copyright  2025 Astor Bizard, 2024 Loic Delon
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['alluserfeedback'] = 'Summary of all comments from user on quizzes';
$string['answercategoriesbyanswer'] = 'Categories by answer';
$string['answercategoriesbyquestion'] = 'Answer categories by question';
$string['answerlabelcorrect'] = '{$a} (correct)';
$string['answerlabelincorrect'] = '{$a} (incorrect)';
$string['attempttype'] = 'Attempt type';
$string['attempttype_help'] = 'Select the attempt that will be considered for each user.';
$string['attempttypeall'] = 'All attempts';
$string['attempttypebestgrade'] = 'Best attempt';
$string['attempttypefirst'] = 'First attempt';
$string['attempttypelatest'] = 'Last attempt';
$string['attemptxofy'] = '{$a->x} of {$a->y}';
$string['certaintyquizzes:view'] = 'View report for all students';
$string['certaintyquizzes:viewself'] = 'View report for own self';
$string['choicetitle'] = 'Choice {$a->i}: {$a->text}';
$string['choicetitlecorrect'] = 'Choice {$a->i} (correct answer): {$a->text}';
$string['choicetitlepercent'] = 'Choice {$a->i} ({$a->percent}): {$a->text}';
$string['dira'] = '<abbr class="text-info" title="Random answers rate">RAR</abbr>: {$a}';
$string['generalfeedbackforattempt'] = 'General comment for this attempt';
$string['generalfeedbackforattempts'] = 'General comments for these attempts';
$string['gradeover100'] = 'Grade over 100';
$string['group'] = 'group filtering';
$string['group_help'] = 'You can use this filter to view only one group. Only groups with actual attempts on Quizzes with certainty behaviours are shown in this list.';
$string['interval'] = 'Interval';
$string['interval_help'] = 'Select the size of each category for grade and lucidity index.';
$string['noattemptinyourgroups'] = 'No attempt on quizzes with a certainty behaviour found in course for users in your groups.';
$string['noattemptoncertaintyquizzesincourse'] = 'No attempt on quizzes with a certainty behaviour found in course.';
$string['noattemptonquiz'] = 'There is no attempt on this Quiz yet.';
$string['nocertaintyquizincourse'] = 'No quiz with a certainty behaviour found in course.';
$string['nofeedbackonanswer'] = 'No student submitted any comment along this answer.';
$string['nofeedbackonquestion'] = 'No student submitted any comment for this question.';
$string['nofeedbackonquiz'] = 'No comment submitted on this quiz.';
$string['nogeneralfeedbackonattempts'] = 'No general comment has been submitted for these attempts.';
$string['numcorrectbyquestion'] = 'Number of correct answers by question';
$string['numofstudents'] = 'Number of students';
$string['numstudentswithcorrectanswer'] = 'Number of students that gave a correct answer';
$string['pluginname'] = 'Certainty behaviour Quizzes reports';
$string['privacy:metadata'] = 'The Certainty behaviour Quizzes reports plugin does not store any personal data.';
$string['selectaquiz'] = 'Select a quiz';
$string['shownames'] = 'Show names';
$string['singlequiz'] = 'Single Quiz';
$string['studentsalongcourse'] = 'Evolution along Quizzes';
$string['studentsbygrade'] = 'Number of students by grade interval';
$string['studentsbylucidity'] = 'Number of students by lucidity index interval';
$string['studentsfeedbackforquestion'] = 'Students comments for this question';
$string['submittedanswer'] = 'Submitted answer';
$string['submittedfeedback'] = 'Submitted comment';
$string['users'] = 'users filtering';
$string['users_help'] = 'You can use this filter to view only one user or group. Only users and groups with actual attempts on Quizzes with certainty behaviours are shown in this list.';
$string['valueforuser'] = '{$a->value} for {$a->user}';
