<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * GovBR-DS file.
 *
 * @package   theme_govbrds
 * @copyright  2018 Fábio Santos {@link https://www.ifrr.edu.br}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['pluginname'] = 'GovBR-DS';
$string['configtitle'] = 'GovBR-DS';

$string['configtitle'] = 'GovBR-DS';
$string['choosereadme'] = 'The GovBR-DS theme is a child theme of Boost. It is based on the digital identity of the Brazilian government.';
$string['configtitle'] = 'GovBR-DS Settings';
$string['generalsettings'] = 'General Settings';

$string['organization'] = 'Organization';
$string['organization_desc'] = 'Name of the institution.';

$string['subordination'] = 'Subordination';
$string['subordination_desc'] = 'Ministry to which it belongs.';

$string['address'] = 'Address';
$string['address_desc'] = 'JSON of the address you want to display in the footer.';

$string['addressm'] = 'Manual Footer';
$string['addressm_desc'] = 'Type something you want to display in the footer.';

$string['boostset'] = 'Theme Configuration';

$string['message_title'] = 'Highlighted Message Title';
$string['message_title_desc'] = 'Title of the highlighted message on the homepage.';

$string['message_content'] = 'Highlighted Message Content';
$string['message_content_desc'] = 'Content of the highlighted message on the homepage.';

$string['homepage'] = 'Homepage';

$string['card1_title'] = 'First Card Title';
$string['card1_title_desc'] = 'Title that will appear on the first card on the homepage.';

$string['card1_content'] = 'First Card Content';
$string['card1_content_desc'] = 'Content that will appear on the first card on the homepage.';

$string['saibamais1'] = 'First Card Link';
$string['saibamais1_desc'] = 'Link the user will be redirected to when clicking "Learn more" on the first card.';

$string['card2_title'] = 'Second Card Title';
$string['card2_title_desc'] = 'Title that will appear on the second card on the homepage.';

$string['card2_content'] = 'Second Card Content';
$string['card2_content_desc'] = 'Content that will appear on the second card on the homepage.';

$string['saibamais2'] = 'Second Card Link';
$string['saibamais2_desc'] = 'Link the user will be redirected to when clicking "Learn more" on the second card.';

$string['card3_title'] = 'Third Card Title';
$string['card3_title_desc'] = 'Title that will appear on the third card on the homepage.';

$string['card3_content'] = 'Third Card Content';
$string['card3_content_desc'] = 'Content that will appear on the third card on the homepage.';

$string['saibamais3'] = 'Third Card Link';
$string['saibamais3_desc'] = 'Link the user will be redirected to when clicking "Learn more" on the third card.';

$string['layout'] = 'Fluid or Fixed Layout';
$string['layout_desc'] = 'This option sets the layout to fluid by default. The fixed layout is still in testing phase.';

$string['accessibility'] = 'Accessibility';
$string['accessibility_desc'] = 'Content of the accessibility page.';

$string['brandcolor'] = 'Brand Color';
$string['brandcolor_desc'] = 'Select a color to apply to links and titles.';

$string['barracodigo'] = 'Government Bar Code';
$string['barracodigo_desc'] = 'Institution code to be added to the Government Bar.';

$string['googlemetasearch'] = 'HTML Tag - Google Search Console';
$string['googlemetasearch_desc'] = 'Copy the meta tag below to be added in the <head> section of your homepage, before the first <body> section.';

$string['footer_returtop'] = "Return to top";
$string['footer_startnav'] = "Start of footer navigation";
$string['footer_endnav'] = "End of footer navigation";

$string['portal_govbar'] = "Portal of the Brazilian Government";
$string['portal_govbar_update'] = "Update your Government Bar";

// BOOST

$string['advancedsettings'] = 'Advanced Settings';
$string['backgroundimage'] = 'Background Image';
$string['backgroundimage_desc'] = 'The image to be displayed as the site background. The image you upload here will replace the default background image in the theme files.';

$string['brandcolor'] = 'Brand Color';
$string['brandcolor_desc'] = 'The highlight color.';

$string['currentinparentheses'] = '(current)';

$string['presetfiles'] = 'Additional Theme Preset Files';
$string['presetfiles_desc'] = 'Preset files can be used to drastically change the theme appearance. See <a href=https://docs.moodle.org/dev/Boost_Presets>Boost presets</a> for info on creating and sharing your own presets, and check the <a href=http://moodle.net/boost>Presets repository</a> for presets shared by others.';

$string['preset'] = 'Theme Preset';
$string['preset_desc'] = 'Choose a preset to change the theme appearance.';

$string['rawscss'] = 'Raw SCSS';
$string['rawscss_desc'] = 'Use this field to provide SCSS or CSS code that will be injected at the end of the stylesheet.';

$string['rawscsspre'] = 'Initial Raw SCSS';
$string['rawscsspre_desc'] = 'Use this field to provide initialization SCSS code. It will be injected before everything else. Most of the time, you’ll use this setting to define variables.';

/* Regions */
$string['region-side-post'] = 'Right';
$string['region-side-pre'] = 'Left';
$string['region-home-left'] = 'Home (Left)';
$string['region-home-middle'] = 'Home (Middle)';
$string['region-home-right'] = 'Home (Right)';
$string['region-footer-left'] = 'Footer (Left)';
$string['region-footer-middle'] = 'Footer (Middle)';
$string['region-footer-right'] = 'Footer (Right)';
$string['region-hidden-dock'] = 'Hidden from users';


$string['privacy:metadata:govbrds_user_setting'] = 'Stores user-specific theme configuration preferences.';
