<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * GovBR-DS Language file.
 *
 * @package    theme_govbrds
 * @copyright  2018 Fábio Santos <fabio.santos@ifrr.edu.br>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['pluginname'] = 'GovBR-DS';
$string['configtitle'] = 'GovBR-DS';

$string['configtitle'] = 'GovBR-DS';
$string['choosereadme'] = 'The GovBR-DS theme is a child theme of Boost. It is based on the digital identity of the Brazilian government.';
$string['configtitle'] = 'GovBR-DS Settings';

// General settings tab
$string['generalsettings'] = 'General Settings';

$string['organization'] = 'Organization';
$string['organization_desc'] = 'Name of the institution.';

$string['subordination'] = 'Subordination';
$string['subordination_desc'] = 'Ministry to which it belongs.';

$string['layout'] = 'Layout';
$string['layout_desc'] = 'Choose the layout for the site.';

$string['logo'] = 'Your Logo';
$string['logo_desc'] = 'Upload the logo image that will be displayed in the website header. The recommended size is 280x80 pixels.';

$string['partners'] = 'Partners Logo';
$string['partners_desc'] = 'Upload the logo image that will be displayed in the website footer. The recommended size is 280x80 pixels.';

$string['organization'] = 'Organization';
$string['organization_desc'] = 'Description of the institution.';

$string['organization_url'] = 'Organization URL';
$string['organization_url_desc'] = 'Link to the institution\'s homepage.';

$string['listcoursestitle'] = 'List Courses Title';
$string['listcoursestitle_desc'] = 'Title for the courses section on the homepage.';

$string['address'] = 'Address';
$string['address_desc'] = 'JSON of the address you want to display in the footer.';

$string['addressm'] = 'Manual Footer';
$string['addressm_desc'] = 'Type something you want to display in the footer.';

$string['boostset'] = 'Theme Configuration';

$string['message_title'] = 'Highlighted Message Title';
$string['message_title_desc'] = 'Title of the highlighted message on the homepage.';

$string['message_content'] = 'Highlighted Message Content';
$string['message_content_desc'] = 'Content of the highlighted message on the homepage.';

// Homepage settings tab
$string['homepage_settings'] = 'Homepage Settings';
$string['homepage'] = 'Homepage';

$string['herohtml'] = 'Hero section';
$string['herohtml_desc'] = 'Content of the hero section on the homepage.';
$string['heroimage'] = 'Hero Image';
$string['heroimage_desc'] = 'Image to be displayed in the hero section. The recommended is .png (PNG-24) without background and size is 450x600 (3x4 proportinal) pixels.';
$string['heroimagealt'] = 'Hero Image Alt Text';
$string['heroimagealt_desc'] = 'Alternative text for the hero image, used for accessibility purposes.';
$string['herocta'] = 'Hero Call to Action (CTA)';
$string['herocta_desc'] = 'Text for the call to action button in the hero section.';
$string['heroctalink'] = 'Hero Call to Action (CTA) Link';
$string['heroctalink_desc'] = 'URL for the call to action button in the hero section.';

$string['features'] = 'Display Features Boxes';
$string['featuresdesc'] = 'Choose whether to display the features boxes section on the homepage.';

$string['featuresheading'] = 'Features Section Heading';
$string['featurescontent'] = 'Features Section Content';

$string['featureheading'] = 'Feature Heading';
$string['featurecontent'] = 'Feature Content';
$string['featureicon'] = 'Feature {$a} Icon';
$string['featureicon_desc'] = 'Choose an icon for feature {$a}. See the list of icons at https://fontawesome.com/icons?d=gallery&m=free.';

$string['feature_btntext'] = 'Feature {$a} Button Text';
$string['feature_btntext_desc'] = 'Text for the button of feature {$a}.'; 
$string['feature_btnurl'] = 'Feature {$a} Button URL';
$string['feature_btnurl_desc'] = 'URL for the button of feature {$a}.';

$string['feature1heading'] = 'Feature 1 Heading';
$string['feature1content'] = 'Feature 1 Content';

$string['feature1icon'] = 'Feature {$a} Icon';
$string['feature2con_desc'] = 'Choose an icon for feature {$a}. See the list of icons at https://fontawesome.com/icons?d=gallery&m=free.';

$string['feature2_btntext'] = 'Feature {$a} Button Text';
$string['feature2_btnurl'] = 'Feature {$a} Button URL';

$string['feature2heading'] = 'Feature 2 Heading';
$string['feature2content'] = 'Feature 2 Content';
$string['feature2icon'] = 'Feature {$a} Icon';
$string['feature2icon_desc'] = 'Choose an icon for feature {$a}. See the list of icons at https://fontawesome.com/icons?d=gallery&m=free.';

$string['feature3_btntext'] = 'Feature {$a} Button Text';
$string['feature3_btnurl'] = 'Feature {$a} Button URL';

$string['feature3heading'] = 'Feature 3 Heading';
$string['feature3content'] = 'Feature 3 Content';
$string['feature3icon'] = 'Feature {$a} Icon';
$string['feature3icon_desc'] = 'Choose an icon for feature {$a}. See the list of icons at https://fontawesome.com/icons?d=gallery&m=free.';

$string['feature3_btntext'] = 'Feature {$a} Button Text';
$string['feature3_btnurl'] = 'Feature {$a} Button URL';

$string['feature4heading'] = 'Feature 4 Heading';
$string['feature4content'] = 'Feature 4 Content';
$string['feature4icon'] = 'Feature {$a} Icon';
$string['feature4icon_desc'] = 'Choose an icon for feature {$a}. See the list of icons at https://fontawesome.com/icons?d=gallery&m=free.';

$string['feature4_btntext'] = 'Feature {$a} Button Text';
$string['feature4_btnurl'] = 'Feature {$a} Button URL';

//Landing template
$string['searchtext'] = 'Search text';
$string['about'] = 'About';
$string['how_do_you_search'] = 'How do you search?';
$string['search'] = 'Search';
$string['search_close'] = 'Close Search';
$string['development_team'] = 'Development Team';
$string['course_details'] = 'Course Details';
$string['related_courses'] = 'Related Courses';
$string['course_deadline'] = 'Course Deadline';
$string['startdate'] = 'Start Date';
$string['enddate'] = 'End Date';
$string['no_related_course'] = 'No related courses';
$string['no_teacher'] = 'No teacher';

// Login template
$string['donthaveanaccount'] = 'Don\'t have an account?';
$string['signinwith'] = 'Sign in with';
$string['loginsettings'] = 'Login Settings';
$string['tab'] = 'Tab';
$string['tabdesc'] = 'A custom menu may be configured here. Enter each menu item on a new line with format: menu text, a link URL and a tooltip title, separated by pipe characters. 
<pre>
eLearn|https://example.com/|Online Study Platform
Mooc|https://example.com/mooc|MOOC Platform
Workspace|https://example.com/workspace|Corporative Training Environment</pre>';

// Navbar template
$string['courses'] = 'Courses';

//Footer template
$string['partners'] = 'Partners';
$string['useful_links'] = 'Useful Links';
$string['contact'] = 'Contact';
$string['address'] = 'Address';
$string['phone'] = 'Phone';
$string['email'] = 'Email';
$string['all_rights_reserved'] = 'All rights reserved';
$string['privacy_policy'] = 'Privacy Policy';
$string['terms_of_use'] = 'Terms of Use';
$string['accessibility'] = 'Accessibility';
$string['sitemap'] = 'Sitemap';
$string['socialnetworks'] = 'Social Networks';
$string['to'] = 'to';


//features template
$string['how_to'] = 'How it works?';

//Header template
$string['brandcolor'] = 'Brand Color';
$string['brandcolor_desc'] = 'Select a color to apply to links and titles.';

// Social settings tab
$string['socialsettings'] = 'Social Settings';
$string['tiktok'] = 'Tik Tok';
$string['tiktokdesc'] = 'Link to your Tik Tok profile.';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'Link to your Facebook profile.';
$string['twitter'] = 'Twitter';
$string['twitterdesc'] = 'Link to your Twitter profile.';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'Link to your LinkedIn profile.';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'Link to your YouTube profile.';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'Link to your Instagram profile.';

// BOOST
$string['advancedsettings'] = 'Advanced Settings';
$string['backgroundimage'] = 'Background Image';
$string['backgroundimage_desc'] = 'The image to be displayed as the site background. The image you upload here will replace the default background image in the theme files.';

$string['brandcolor'] = 'Brand Color';
$string['brandcolor_desc'] = 'The highlight color.';

$string['currentinparentheses'] = '(current)';

$string['presetfiles'] = 'Additional Theme Preset Files';
$string['presetfiles_desc'] = 'Preset files can be used to drastically change the theme appearance. See <a href=https://docs.moodle.org/dev/Boost_Presets>Boost presets</a> for info on creating and sharing your own presets, and check the <a href=http://moodle.net/boost>Presets repository</a> for presets shared by others.';

$string['preset'] = 'Theme Preset';
$string['preset_desc'] = 'Choose a preset to change the theme appearance.';

$string['rawscss'] = 'Raw SCSS';
$string['rawscss_desc'] = 'Use this field to provide SCSS or CSS code that will be injected at the end of the stylesheet.';

$string['rawscsspre'] = 'Initial Raw SCSS';
$string['rawscsspre_desc'] = 'Use this field to provide initialization SCSS code. It will be injected before everything else. Most of the time, you’ll use this setting to define variables.';

/* Regions */
$string['region-side-post'] = 'Right';
$string['region-side-pre'] = 'Left';
$string['region-home-left'] = 'Home (Left)';
$string['region-home-middle'] = 'Home (Middle)';
$string['region-home-right'] = 'Home (Right)';
$string['region-footer-left'] = 'Footer (Left)';
$string['region-footer-middle'] = 'Footer (Middle)';
$string['region-footer-right'] = 'Footer (Right)';
$string['region-hidden-dock'] = 'Hidden from users';
$string['prev_activity'] = 'Previous activity';
$string['next_activity'] = 'Next activity';


$string['privacy:metadata:govbrds_user_setting'] = 'Stores user-specific theme configuration preferences.';
