<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Version details.
 *
 * @package    local
 * @subpackage moodlemobileapp
 * @copyright  2014 Juan Leyva <juanleyvadelgado@gmail.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['appstoredescription'] = 'NOTE: This official Moodle Mobile app will ONLY work with Moodle sites that have been set up to allow it.  Please talk to your Moodle administrator if you have any problems connecting.

If your Moodle site has been configured correctly, you can use this app to:

- browse the content of your courses, even when offline
- receive instant notifications of messages and other events
- quickly find and contact other people in your courses
- upload images, audio, videos and other files from your mobile device
- view your course grades
- and more!

Please see http://docs.moodle.org/en/Mobile_app for all the latest information.

We’d really appreciate any good reviews about the functionality so far, and your suggestions on what else you want this app to do!

The app requires the following permissions:
Record audio - For recording audio to upload to Moodle
Read and modify the contents of your SD card - Contents are downloaded to the SD Card so you can see them offline
Network access - To be able to connect with your Moodle site and check if you are connected or not to switch to offline mode
Run at startup - So you receive local notifications even when the app is running in the background
Prevent phone from sleeping - So you can receive push notifications anytime';
$string['pluginname'] = 'Moodle App language strings';
$string['privacy_metadata'] = 'This plugin does not store any user data.';

/* AUTO START */
$string['addon.block_myoverview.browseallcourses'] = 'Browse all courses';
$string['addon.block_myoverview.nocoursesenrolleddescription'] = 'Browse all available courses below and start learning.';
$string['addon.block_myoverview.noresult'] = 'Your search didn\'t match any courses.';
$string['addon.block_myoverview.noresultdescription'] = 'Try adjusting your filters or browse all courses below.';
$string['addon.block_myoverview.searchavailablecourses'] = 'Search available courses';
$string['addon.blog.errorloadentries'] = 'Error loading blog entries.';
$string['addon.blog.showonlyyourentries'] = 'Show only your entries';
$string['addon.calendar.calendarevent'] = 'Calendar event';
$string['addon.calendar.calendarevents'] = 'Calendar events';
$string['addon.calendar.calendarreminders'] = 'Calendar reminders';
$string['addon.calendar.currentmonth'] = 'Current Month';
$string['addon.calendar.defaultnotificationtime'] = 'Default notification time';
$string['addon.calendar.errorloadevent'] = 'Error loading event.';
$string['addon.calendar.errorloadevents'] = 'Error loading events.';
$string['addon.calendar.monthlyview'] = 'Monthly view';
$string['addon.calendar.noevents'] = 'There are no events';
$string['addon.calendar.reminders'] = 'Reminders';
$string['addon.calendar.setnewreminder'] = 'Set a new reminder';
$string['addon.competency.errornocompetenciesfound'] = 'No competencies found';
$string['addon.competency.nocompetencies'] = 'No competencies';
$string['addon.coursecompletion.complete'] = 'Complete';
$string['addon.coursecompletion.couldnotloadreport'] = 'Could not load the course completion report. Please try again later.';
$string['addon.enrol_self.confirmselfenrol'] = 'Are you sure you want to enrol yourself in this course?';
$string['addon.enrol_self.errorselfenrol'] = 'An error occurred while self enrolling.';
$string['addon.messageoutput_airnotifier.processorsettingsdesc'] = 'Configure devices';
$string['addon.messageoutput_airnotifier.pushdisabledwarning'] = 'Your users are not receiving any notification from this site on their mobile devices. Enable mobile notifications in the Notification settings page.';
$string['addon.messages.deletemessage'] = 'Delete message';
$string['addon.messages.deletemessageconfirmation'] = 'Are you sure you want to delete this message? It will only be deleted from your messaging history and will still be viewable by the user who sent or received the message.';
$string['addon.messages.errordeletemessage'] = 'Error while deleting the message.';
$string['addon.messages.errorwhileretrievingcontacts'] = 'Error while retrieving contacts from the server.';
$string['addon.messages.errorwhileretrievingdiscussions'] = 'Error while retrieving discussions from the server.';
$string['addon.messages.errorwhileretrievingmessages'] = 'Error while retrieving messages from the server.';
$string['addon.messages.errorwhileretrievingusers'] = 'Error while retrieving users from the server.';
$string['addon.messages.messagenotsent'] = 'The message was not sent. Please try again later.';
$string['addon.messages.newmessages'] = 'New messages';
$string['addon.messages.showdeletemessages'] = 'Show delete messages';
$string['addon.messages.useentertosenddescdesktop'] = 'If disabled, you can use Ctrl+Enter to send the message.';
$string['addon.messages.useentertosenddescmac'] = 'If disabled, you can use Cmd+Enter to send the message.';
$string['addon.messages.warningconversationmessagenotsent'] = 'Couldn\'t send message(s) to conversation {{conversation}}. {{error}}';
$string['addon.messages.warningmessagenotsent'] = 'Couldn\'t send message(s) to user {{user}}. {{error}}';
$string['addon.mod_assign.acceptsubmissionstatement'] = 'Please accept the submission statement.';
$string['addon.mod_assign.allowsubmissionsanddescriptionfromdatesummary'] = 'The assignment details and submission form will be available from <strong>{{$a}}</strong>';
$string['addon.mod_assign.allowsubmissionsfromdatesummary'] = 'This assignment will accept submissions from <strong>{{$a}}</strong>';
$string['addon.mod_assign.cannoteditduetostatementsubmission'] = 'You can\'t add or edit a submission in the app because the submission statement could not be retrieved from the site.';
$string['addon.mod_assign.cannotgradefromapp'] = 'Certain grading methods are not yet supported by the app and cannot be modified.';
$string['addon.mod_assign.cannotsubmitduetostatementsubmission'] = 'You can\'t make a submission in the app because the submission statement could not be retrieved from the site.';
$string['addon.mod_assign.duedateno'] = 'No due date';
$string['addon.mod_assign.erroreditpluginsnotsupported'] = 'You can\'t add or edit a submission in the app because certain plugins are not yet supported for editing.';
$string['addon.mod_assign.errorshowinginformation'] = 'Submission information cannot be displayed.';
$string['addon.mod_assign.feedbacknotsupported'] = 'This feedback is not supported by the app and may not contain all the information.';
$string['addon.mod_assign.gradenotsynced'] = 'Grade not synced';
$string['addon.mod_assign.notallparticipantsareshown'] = 'Participants who have not made a submission are not shown.';
$string['addon.mod_assign.numberofdraftsubmissionscountdescription'] = 'There are {{count}} drafts.';
$string['addon.mod_assign.numberofparticipantscountdescription'] = 'There are {{count}} participants.';
$string['addon.mod_assign.numberofsubmissionsneedgradingcountdescription'] = 'There are {{count}} submissions that need grading.';
$string['addon.mod_assign.numberofsubmittedassignmentscountdescription'] = 'There are {{count}} submitted assignments.';
$string['addon.mod_assign.numberofteamscountdescription'] = 'There are {{count}} teams.';
$string['addon.mod_assign.submissionnotsupported'] = 'This submission is not supported by the app and may not contain all the information.';
$string['addon.mod_assign.syncblockedusercomponent'] = 'user grade';
$string['addon.mod_assign.warningsubmissiongrademodified'] = 'The submission grade was modified on the site.';
$string['addon.mod_assign.warningsubmissionmodified'] = 'The user submission was modified on the site.';
$string['addon.mod_chat.confirmloss'] = 'Are you sure? Chat history can be lost.';
$string['addon.mod_chat.errorwhileconnecting'] = 'Error while connecting to the chat.';
$string['addon.mod_chat.errorwhilegettingchatdata'] = 'Error while getting chat data.';
$string['addon.mod_chat.errorwhilegettingchatusers'] = 'Error while getting chat users.';
$string['addon.mod_chat.errorwhileretrievingmessages'] = 'Error while retrieving messages from the server.';
$string['addon.mod_chat.errorwhilesendingmessage'] = 'Error while sending the message.';
$string['addon.mod_chat.mustbeonlinetosendmessages'] = 'You must be online to send messages.';
$string['addon.mod_chat.nosessionsfound'] = 'No sessions found';
$string['addon.mod_chat.showincompletesessions'] = 'Show incomplete sessions';
$string['addon.mod_choice.errorgetchoice'] = 'Error getting choice data.';
$string['addon.mod_choice.responsesresultgraphdescription'] = '{{number}}% of the users chose the option: {{text}}.';
$string['addon.mod_choice.resultsnotsynced'] = 'Your last response must be synchronised before it is included in the results.';
$string['addon.mod_data.edittagsnotsupported'] = 'Sorry, editing tags is not supported by the app.';
$string['addon.mod_data.errorapproving'] = 'Error approving or unapproving entry.';
$string['addon.mod_data.errordeleting'] = 'Error deleting entry.';
$string['addon.mod_data.mylocation'] = 'My location';
$string['addon.mod_data.searchbytagsnotsupported'] = 'Sorry, searching by tags is not supported by the app.';
$string['addon.mod_feedback.captchaofflinewarning'] = 'Feedback with CAPTCHA cannot be completed offline, or if not configured, or if the server is down.';
$string['addon.mod_feedback.completedfeedbackscountdescription'] = 'There are {{count}} submitted answers.';
$string['addon.mod_feedback.feedback_submitted_offline'] = 'This feedback has been saved to be submitted later.';
$string['addon.mod_feedback.questionscountdescription'] = 'There are {{count}} questions.';
$string['addon.mod_folder.emptyfilelist'] = 'There are no files to show.';
$string['addon.mod_forum.errorgetforum'] = 'Error getting forum data.';
$string['addon.mod_forum.errorgetgroups'] = 'Error getting group settings.';
$string['addon.mod_forum.errorloadingsortingorder'] = 'Forum not available in this sorting order';
$string['addon.mod_forum.errorloadingsortingorderdetails'] = 'Try changing the sorting order or going online to view this forum.';
$string['addon.mod_forum.errorposttoallgroups'] = 'Could not create new discussion in all groups.';
$string['addon.mod_forum.forumnodiscussionsyet'] = 'There are no discussions yet in this forum.';
$string['addon.mod_forum.numdiscussions'] = '{{numdiscussions}} discussions';
$string['addon.mod_forum.numreplies'] = '{{numreplies}} replies';
$string['addon.mod_forum.postingroup'] = 'Posting in group "{{groupname}}".';
$string['addon.mod_forum.refreshposts'] = 'Refresh posts';
$string['addon.mod_glossary.browsemode'] = 'Browse entries';
$string['addon.mod_glossary.byalphabet'] = 'Alphabetically';
$string['addon.mod_glossary.byauthor'] = 'Group by author';
$string['addon.mod_glossary.bycategory'] = 'Group by category';
$string['addon.mod_glossary.bynewestfirst'] = 'Newest first';
$string['addon.mod_glossary.byrecentlyupdated'] = 'Recently updated';
$string['addon.mod_glossary.bysearch'] = 'Search';
$string['addon.mod_glossary.cannoteditentry'] = 'Cannot edit entry';
$string['addon.mod_glossary.entriestobesynced'] = 'Entries to be synced';
$string['addon.mod_glossary.entrypendingapproval'] = 'This entry is pending approval.';
$string['addon.mod_glossary.errordeleting'] = 'Error deleting entry.';
$string['addon.mod_glossary.errorloadingentries'] = 'An error occurred while loading entries.';
$string['addon.mod_glossary.errorloadingentry'] = 'An error occurred while loading the entry.';
$string['addon.mod_glossary.errorloadingglossary'] = 'An error occurred while loading the glossary.';
$string['addon.mod_glossary.noentriesfound'] = 'No entries were found.';
$string['addon.mod_h5pactivity.downloadh5pfile'] = 'Download H5P file';
$string['addon.mod_h5pactivity.errorgetactivity'] = 'Error getting H5P activity data.';
$string['addon.mod_h5pactivity.filestatenotdownloaded'] = 'The H5P package is not downloaded. You need to download it to be able to use it.';
$string['addon.mod_h5pactivity.filestateoutdated'] = 'The H5P package has been modified since the last download. You need to download it again to be able to use it.';
$string['addon.mod_h5pactivity.numberofattempts'] = '{{$a}} attempts';
$string['addon.mod_h5pactivity.offlinedisabledwarning'] = 'You need to be online to view the H5P package.';
$string['addon.mod_h5pactivity.viewattempt'] = 'View attempt {{$a}}';
$string['addon.mod_imscp.showmoduledescription'] = 'Show description';
$string['addon.mod_lesson.errorprefetchrandombranch'] = 'This lesson contains a jump to a random content page. It can\'t be attempted in the app until it has been started in a web browser.';
$string['addon.mod_lesson.errorreviewretakenotlast'] = 'This attempt can no longer be reviewed because another attempt has been finished.';
$string['addon.mod_lesson.finishretakeoffline'] = 'This attempt was finished offline.';
$string['addon.mod_lesson.retakefinishedinsync'] = 'An offline attempt was synchronised. Do you want to review it?';
$string['addon.mod_lesson.retakelabelfull'] = '{{retake}}: {{grade}} {{timestart}} ({{duration}})';
$string['addon.mod_lesson.retakelabelshort'] = '{{retake}}: {{grade}} {{timestart}}';
$string['addon.mod_lesson.warningretakefinished'] = 'The attempt was finished on the site.';
$string['addon.mod_lti.errorgetlti'] = 'Error getting module data.';
$string['addon.mod_lti.errorinvalidlaunchurl'] = 'The launch URL is not valid.';
$string['addon.mod_lti.launchactivity'] = 'Launch the activity';
$string['addon.mod_page.errorwhileloadingthepage'] = 'Error while loading the page content.';
$string['addon.mod_quiz.canattemptbutnotsubmit'] = 'You can attempt this quiz in the app, but you will need to submit the attempt in browser for the following reasons:';
$string['addon.mod_quiz.cannotsubmitquizdueto'] = 'This quiz attempt cannot be submitted for the following reasons:';
$string['addon.mod_quiz.confirmcontinueoffline'] = 'This attempt has not been synchronised since {{$a}}. If you have continued this attempt in another device since then, you may lose data.';
$string['addon.mod_quiz.confirmleavequizonerror'] = 'An error occurred while saving the answers. Are you sure you want to leave the quiz?';
$string['addon.mod_quiz.errorbehaviournotsupported'] = 'This quiz can\'t be attempted in the app because the question behaviour is not supported by the app:';
$string['addon.mod_quiz.errordownloading'] = 'Error downloading required data.';
$string['addon.mod_quiz.errorgetattempt'] = 'Error getting attempt data.';
$string['addon.mod_quiz.errorgetquestions'] = 'Error getting questions.';
$string['addon.mod_quiz.errorgetquiz'] = 'Error getting quiz data.';
$string['addon.mod_quiz.errorparsequestions'] = 'An error occurred while reading the questions. Please attempt this quiz in a web browser.';
$string['addon.mod_quiz.errorquestionsnotsupported'] = 'This quiz can\'t be attempted in the app because it only contains questions not supported by the app:';
$string['addon.mod_quiz.errorrulesnotsupported'] = 'This quiz can\'t be attempted in the app because it has access rules not supported by the app:';
$string['addon.mod_quiz.errorsaveattempt'] = 'An error occurred while saving the attempt data.';
$string['addon.mod_quiz.finishedofflinenotice'] = 'Your attempt has been submitted and saved. It will be sent to the site when you\'re online again.';
$string['addon.mod_quiz.opentoc'] = 'Open navigation popover';
$string['addon.mod_quiz.warningattemptfinished'] = 'Offline attempt discarded as it was finished on the site or not found.';
$string['addon.mod_quiz.warningdatadiscarded'] = 'Some offline answers were discarded because the questions were modified online.';
$string['addon.mod_quiz.warningdatadiscardedfromfinished'] = 'Attempt unfinished because some offline answers were discarded. Please review your answers then resubmit the attempt.';
$string['addon.mod_quiz.warningquestionsnotsupported'] = 'This quiz contains questions not supported by the app:';
$string['addon.mod_resource.errorwhileloadingthecontent'] = 'Error while loading the content.';
$string['addon.mod_resource.openthefile'] = 'Open';
$string['addon.mod_resource.resourcestatusoutdated'] = 'This file has changed since you last opened it.';
$string['addon.mod_resource.resourcestatusoutdatedconfirm'] = 'There is a newer version of this file. To see it, please connect your device to the internet.';
$string['addon.mod_scorm.cannotcalculategrade'] = 'Grade couldn\'t be calculated.';
$string['addon.mod_scorm.dataattemptshown'] = 'This data belongs to the attempt number {{number}}.';
$string['addon.mod_scorm.errorcreateofflineattempt'] = 'An error occurred while creating a new offline attempt. Please try again.';
$string['addon.mod_scorm.errordownloadscorm'] = 'Error downloading SCORM: "{{name}}".';
$string['addon.mod_scorm.errorgetscorm'] = 'Error getting SCORM data.';
$string['addon.mod_scorm.errornovalidsco'] = 'This SCORM package doesn\'t have a visible SCO to load.';
$string['addon.mod_scorm.errorsyncscorm'] = 'An error occurred while synchronising. Please try again.';
$string['addon.mod_scorm.offlineattemptnote'] = 'This attempt has data that hasn\'t been synchronised.';
$string['addon.mod_scorm.offlineattemptovermax'] = 'This attempt cannot be sent because you exceeded the maximum number of attempts.';
$string['addon.mod_scorm.scormstatusnotdownloaded'] = 'This SCORM package is not downloaded. It will be automatically downloaded when you open it.';
$string['addon.mod_scorm.scormstatusoutdated'] = 'This SCORM package has been modified since the last download. It will be automatically downloaded when you open it.';
$string['addon.mod_scorm.warningofflinedatadeleted'] = 'Some offline data from attempt {{number}} has been discarded because it couldn\'t be counted as a new attempt.';
$string['addon.mod_scorm.warningsynconlineincomplete'] = 'Some attempts couldn\'t be synchronised with the site because the last online attempt is not yet finished. Please finish the online attempt first.';
$string['addon.mod_survey.cannotsubmitsurvey'] = 'Sorry, there was a problem submitting your survey. Please try again.';
$string['addon.mod_survey.errorgetsurvey'] = 'Error getting survey data.';
$string['addon.mod_url.accessurl'] = 'Access the URL';
$string['addon.mod_url.pointingtourl'] = 'URL that the resource points to.';
$string['addon.mod_wiki.errorloadingpage'] = 'An error occurred while loading the page.';
$string['addon.mod_wiki.errornowikiavailable'] = 'This wiki does not have any content yet.';
$string['addon.mod_wiki.gowikihome'] = 'Go to the wiki first page';
$string['addon.mod_wiki.subwiki'] = 'Sub-wiki';
$string['addon.mod_wiki.titleshouldnotbeempty'] = 'The title should not be empty';
$string['addon.mod_wiki.viewpage'] = 'View page';
$string['addon.mod_wiki.wikipage'] = 'Wiki page';
$string['addon.mod_workshop.assessmentstrategynotsupported'] = 'Assessment strategy {{$a}} not supported';
$string['addon.mod_workshop.submissionrequiredtitle'] = 'You need to enter a title.';
$string['addon.mod_workshop.warningassessmentmodified'] = 'The submission was modified on the site.';
$string['addon.mod_workshop.warningsubmissionmodified'] = 'The assessment was modified on the site.';
$string['addon.notes.warningnotenotsent'] = 'Couldn\'t add or delete note(s). {{error}}';
$string['addon.notifications.allownotifications'] = 'Allow notifications';
$string['addon.notifications.errorgetnotifications'] = 'Error getting notifications.';
$string['addon.notifications.playsound'] = 'Play sound';
$string['addon.notifications.therearentnotificationsyet'] = 'There are no notifications.';
$string['addon.notifications.typeofnotification'] = 'Type of notification';
$string['addon.privatefiles.couldnotloadfiles'] = 'The list of files could not be loaded.';
$string['addon.privatefiles.emptyfilelist'] = 'There are no files to show.';
$string['addon.privatefiles.erroruploadnotworking'] = 'Unfortunately it is currently not possible to upload files to your site.';
$string['addon.storagemanager.confirmdeleteallsitedata'] = 'Delete all site downloaded data?';
$string['addon.storagemanager.confirmdeletecourses'] = 'Delete downloaded data from all courses?';
$string['addon.storagemanager.confirmdeletedatafrom'] = 'Delete all downloaded data from \'{{name}}\'?';
$string['addon.storagemanager.coursedownloads'] = 'Course downloads';
$string['addon.storagemanager.courseinfo'] = 'Download course content to work offline. Your activity will sync automatically when your device is back online.';
$string['addon.storagemanager.deleteallsitedata'] = 'Delete all site downloaded data';
$string['addon.storagemanager.deleteallsitedatainfo'] = 'This will delete all downloaded data from \'{{name}}\', including all downloaded courses and data that allows you to work offline.';
$string['addon.storagemanager.deletecourses'] = 'Delete downloaded data from all courses';
$string['addon.storagemanager.deletedata'] = 'Delete downloaded data';
$string['addon.storagemanager.deletedatafrom'] = 'Delete all downloaded data from \'{{name}}\'';
$string['addon.storagemanager.downloaddatafrom'] = 'Download {{name}}';
$string['addon.storagemanager.downloadedcourses'] = 'Downloaded courses';
$string['addon.storagemanager.downloads'] = 'Downloads';
$string['addon.storagemanager.errordeletedownloadeddata'] = 'Error deleting downloaded data.';
$string['addon.storagemanager.managedownloads'] = 'Manage downloads';
$string['addon.storagemanager.totaldownloads'] = 'Total downloads';
$string['addon.storagemanager.totalspaceusage'] = 'Total space used';
$string['addon.tinymce.enabletinymceeditor'] = 'Use TinyMCE text editor';
$string['addon.tinymce.enabletinymceeditordescription'] = 'An advanced text editor with additional formatting features.';
$string['addon.tinymce.license'] = 'Moodle Pty Ltd was granted a TinyMCE commercial license compatible with Apache license 2.0.';
$string['assets.mimetypes.application/vnd.apple.keynote'] = 'Apple Keynote presentation';
$string['assets.mimetypes.application/vnd.apple.numbers'] = 'Apple Numbers spreadsheet';
$string['assets.mimetypes.application/vnd.apple.pages'] = 'Apple Pages document';
$string['assets.mimetypes.application/vnd.google-apps.audio'] = 'Google Drive audio';
$string['assets.mimetypes.application/vnd.google-apps.document'] = 'Google Docs';
$string['assets.mimetypes.application/vnd.google-apps.drawing'] = 'Google Drawing';
$string['assets.mimetypes.application/vnd.google-apps.file'] = 'Google Drive file';
$string['assets.mimetypes.application/vnd.google-apps.folder'] = 'Google Drive folder';
$string['assets.mimetypes.application/vnd.google-apps.form'] = 'Google Forms';
$string['assets.mimetypes.application/vnd.google-apps.fusiontable'] = 'Google Fusion Tables';
$string['assets.mimetypes.application/vnd.google-apps.presentation'] = 'Google Slides';
$string['assets.mimetypes.application/vnd.google-apps.script'] = 'Google Apps Scripts';
$string['assets.mimetypes.application/vnd.google-apps.site'] = 'Google Sites';
$string['assets.mimetypes.application/vnd.google-apps.spreadsheet'] = 'Google Sheets';
$string['assets.mimetypes.application/vnd.google-apps.video'] = 'Google Drive video';
$string['core.ajaxendpointnotfound'] = 'AJAX endpoint not found. This can happen if the Moodle site is too old or it blocks access to this endpoint. The Moodle app only supports Moodle systems {{$a}} onwards.';
$string['core.browser'] = 'Browser';
$string['core.calculating'] = 'Calculating';
$string['core.cannotconnect'] = 'Can\'t connect to site';
$string['core.cannotdownloadfiles'] = 'Your school or learning provider has disabled downloading files.';
$string['core.cannotinstallapk'] = 'Can\'t install .apk files';
$string['core.cannotinstallapkinfo'] = 'For security reasons, you can\'t install unknown apps on your device from this app. If you still want to proceed with the installation, you need to open it in a browser.';
$string['core.cannotlogoutpageblocks'] = 'Please save or discard your changes before continuing.';
$string['core.cannotopeninapp'] = 'This file may not work as expected on this device. Would you like to open it anyway?';
$string['core.cannotopeninappdownload'] = 'This file may not work as expected on this device. Would you like to download it anyway?';
$string['core.captureaudio'] = 'Record audio';
$string['core.capturedimage'] = 'Taken picture.';
$string['core.captureimage'] = 'Take picture';
$string['core.capturevideo'] = 'Record video';
$string['core.certificaterror'] = 'The certificate of this site cannot be trusted by your device: {{details}}';
$string['core.clearsearch'] = 'Clear search';
$string['core.clearstoreddata'] = 'Clear storage {{$a}}';
$string['core.clicktoseefull'] = 'Click to see full contents.';
$string['core.comments.commentsnotworking'] = 'Comments cannot be retrieved';
$string['core.comments.warningcommentsnotsent'] = 'Couldn\'t sync comments. {{error}}';
$string['core.confirmleavepagedescription'] = 'Unsaved changes will be lost.';
$string['core.confirmleavepagetitle'] = 'Leave page?';
$string['core.confirmloss'] = 'Are you sure? All changes will be lost.';
$string['core.confirmopeninbrowser'] = 'Do you want to open it in a web browser?';
$string['core.confirmremoveselectedfile'] = 'This will permanently delete \'{{filename}}\'. You can\'t undo this.';
$string['core.confirmremoveselectedfiles'] = 'This will permanently delete selected files. You can\'t undo this.';
$string['core.connectandtryagain'] = 'Please connect to the internet and try again.';
$string['core.connectionlost'] = 'Connection to site lost';
$string['core.contactsupport'] = 'Contact support';
$string['core.contactverb'] = 'Contact';
$string['core.contenteditingsynced'] = 'The content you are editing has been synced.';
$string['core.contentlinks.chooseaccount'] = 'Choose account';
$string['core.contentlinks.chooseaccounttoopenlink'] = 'Choose an account to open the link with.';
$string['core.contentlinks.confirmurlothersite'] = 'This link belongs to another site. Do you want to open it?';
$string['core.contentlinks.errornoactions'] = 'Couldn\'t find an action to perform with this link.';
$string['core.contentlinks.errornosites'] = 'Couldn\'t find any site to handle this link.';
$string['core.contentlinks.errorredirectothersite'] = 'The redirect URL cannot point to a different site.';
$string['core.copiedtoclipboard'] = 'Text copied to clipboard';
$string['core.copytoclipboard'] = 'Copy to clipboard';
$string['core.course.activitynotavailableoffline'] = 'This activity is not available offline.';
$string['core.course.activityrequiresconnection'] = 'This activity is only available with an internet connection. If your device is offline, you will not be able to access it.';
$string['core.course.allsections'] = 'All sections';
$string['core.course.aria:sectionprogress'] = 'Section progress:';
$string['core.course.availablespace'] = 'You currently have about {{available}} free space.';
$string['core.course.cannotdeletewhiledownloading'] = 'Files cannot be deleted while the activity is being downloaded. Please wait for the download to finish.';
$string['core.course.changesofflinemaybelost'] = 'Any changes you make to this activity while offline may not be saved.<br><br>Connect your device to the internet to avoid losing your progress.';
$string['core.course.confirmdownload'] = 'You are about to download {{size}}.{{availableSpace}} Are you sure you want to continue?';
$string['core.course.confirmdownloadunknownsize'] = 'It was not possible to calculate the size of the download.{{availableSpace}} Are you sure you want to continue?';
$string['core.course.confirmdownloadzerosize'] = 'You are about to start downloading.{{availableSpace}} Are you sure you want to continue?';
$string['core.course.confirmlimiteddownload'] = 'You are not currently connected to Wi-Fi.';
$string['core.course.confirmpartialdownloadsize'] = 'You are about to download <strong>at least</strong> {{size}}.{{availableSpace}} Are you sure you want to continue?';
$string['core.course.couldnotloadsectioncontent'] = 'Could not load the section content. Please try again later.';
$string['core.course.couldnotloadsections'] = 'Could not load the sections. Please try again later.';
$string['core.course.downloadcoursesprogressdescription'] = 'Downloading courses: downloaded {{count}} out of {{total}}.';
$string['core.course.downloadsectionprogressdescription'] = 'Downloading section: downloaded {{count}} out of {{total}}.';
$string['core.course.errordownloadingcourse'] = 'Error downloading course.';
$string['core.course.errordownloadingsection'] = 'Error downloading section.';
$string['core.course.errorgetmodule'] = 'Error getting activity data.';
$string['core.course.insufficientavailablequota'] = 'Your device could not allocate space to save this download. It may be reserving space for app and system updates. Please clear some storage space first.';
$string['core.course.insufficientavailablespace'] = 'You are trying to download {{size}}. This will leave your device with insufficient space to operate normally. Please clear some storage space first.';
$string['core.course.lastaccessedactivity'] = 'Last accessed activity';
$string['core.course.manualcompletionnotsynced'] = 'Manual completion not synchronised.';
$string['core.course.modulenotfound'] = 'Resource or activity not found, please make sure you\'re online and it\'s still available.';
$string['core.course.nextactivity'] = 'Next activity';
$string['core.course.nextactivitynotfound'] = 'Next activity not found. It\'s possible that it has been hidden or deleted.';
$string['core.course.nocontentavailable'] = 'No content available at the moment.';
$string['core.course.previousactivity'] = 'Previous activity';
$string['core.course.previousactivitynotfound'] = 'Previous activity not found. It\'s possible that it has been hidden or deleted.';
$string['core.course.refreshcourse'] = 'Refresh course';
$string['core.course.useactivityonbrowser'] = 'You can still use it using your device\'s web browser.';
$string['core.course.warningmanualcompletionmodified'] = 'The manual completion of an activity was modified on the site.';
$string['core.course.warningofflinemanualcompletiondeleted'] = 'Some offline manual completion of course \'{{name}}\' has been deleted. {{error}}';
$string['core.coursenogroups'] = 'You are not a member of any group of this course.';
$string['core.courses.browserenrolinstructions'] = 'We will take you to your device\'s browser. Once you have completed your enrolment, please come back to this app.';
$string['core.courses.cannotretrievemorecategories'] = 'Categories deeper than level {{$a}} cannot be retrieved.';
$string['core.courses.completeenrolmentbrowser'] = 'Complete enrolment in browser';
$string['core.courses.downloadcourses'] = 'Download all courses';
$string['core.courses.errorloadcategories'] = 'An error occurred while loading categories.';
$string['core.courses.errorloadcourses'] = 'An error occurred while loading courses.';
$string['core.courses.errorloadplugins'] = 'The plugins required by this course could not be loaded correctly. Please reload the app to try again.';
$string['core.courses.errorsearching'] = 'An error occurred while searching.';
$string['core.courses.filtermycourses'] = 'Filter my courses';
$string['core.courses.notenrollable'] = 'You cannot enrol yourself in this course.';
$string['core.courses.otherenrolments'] = 'Other enrolments';
$string['core.courses.password'] = 'Enrolment key';
$string['core.courses.refreshcourses'] = 'Refresh courses';
$string['core.courses.searchcoursesadvice'] = 'You can use the search courses button to find courses to access as a  guest or enrol yourself in courses that allow it.';
$string['core.courses.showonlyenrolled'] = 'Show only my courses';
$string['core.courses.totalcoursesearchresults'] = 'Total courses: {{$a}}';
$string['core.currentdevice'] = 'Current device';
$string['core.datastoredoffline'] = 'Data stored in the device because it couldn\'t be sent. It will be sent automatically later.';
$string['core.deletedoffline'] = 'Deleted offline';
$string['core.deleting'] = 'Deleting';
$string['core.desktop'] = 'Desktop';
$string['core.dfdaymonthyear'] = 'MM-DD-YYYY';
$string['core.dfdayweekmonth'] = 'ddd, D MMM';
$string['core.dffulldate'] = 'dddd, D MMMM YYYY h[:]mm A';
$string['core.dflastweekdate'] = 'ddd';
$string['core.dfmediumdate'] = 'LLL';
$string['core.dftimedate'] = 'h[:]mm A';
$string['core.discard'] = 'Discard';
$string['core.dismiss'] = 'Dismiss';
$string['core.dontshowagain'] = 'Don\'t show again.';
$string['core.downloaded'] = 'Downloaded';
$string['core.downloading'] = 'Downloading';
$string['core.editor.hidetoolbar'] = 'Hide toolbar';
$string['core.editor.toggle'] = 'Toggle editor';
$string['core.emptysplit'] = 'This page will appear blank if the left panel is empty or is loading.';
$string['core.endingtime'] = 'Ending time: {{$a}}';
$string['core.errorchangecompletion'] = 'An error occurred while changing the completion status. Please try again.';
$string['core.errorcode'] = 'Error code: {{errorCode}}';
$string['core.errordeletefile'] = 'Error deleting the file. Please try again.';
$string['core.errordetailshide'] = 'Hide error details';
$string['core.errordetailsshow'] = 'Show error details';
$string['core.errordownloading'] = 'Error downloading file.';
$string['core.errordownloadingsomefiles'] = 'Error downloading files. Some files might be missing.';
$string['core.errorfileexistssamename'] = 'A file with this name already exists.';
$string['core.errorinvalidform'] = 'Please check that all required fields are filled in and the data you entered is in the correct format.';
$string['core.errorinvalidresponse'] = 'Unexpected response for {{method}} webservice.';
$string['core.errorloadingcontent'] = 'Error loading content.';
$string['core.errorofflinedisabled'] = 'Offline browsing is disabled on your site. You need to be connected to the internet to use the app.';
$string['core.erroropenfiledownloading'] = 'Error opening file: you need to wait for the download to complete.';
$string['core.erroropenfilenoapp'] = 'Error opening file: no app found to open this type of file.';
$string['core.erroropenfilenoextension'] = 'Error opening file: the file doesn\'t have an extension.';
$string['core.erroropenpopup'] = 'This activity is trying to open a popup. This is not supported in the app.';
$string['core.errorrenamefile'] = 'Error renaming file. Please try again.';
$string['core.errorsitesupport'] = 'If the problem persists, contact site support.';
$string['core.errorsomedatanotdownloaded'] = 'If you downloaded this activity, please notice that some data isn\'t downloaded during the download process for performance and data usage reasons.';
$string['core.errorsomethingwrong'] = 'Something went wrong. Please try again.';
$string['core.errorsync'] = 'An error occurred while synchronising. Please try again.';
$string['core.errorsyncblocked'] = 'This {{$a}} cannot be synchronised right now because of an ongoing process. Please try again later. If the problem persists, try restarting the app.';
$string['core.errorurlschemeinvalidscheme'] = 'This URL is meant to be used in another app: {{$a}}.';
$string['core.errorurlschemeinvalidsite'] = 'This site URL cannot be opened in this app.';
$string['core.exactalarmsturnedoff'] = 'Real-time notifications are turned off';
$string['core.exactalarmsturnedoffmessage'] = 'To make sure you don\'t miss any important alerts, turn on \'Alarms and reminders\' in your device\'s settings.';
$string['core.filedeletedsuccessfully'] = 'You have deleted \'{{filename}}\' succesfully';
$string['core.filenameexist'] = 'File name already exists: {{$a}}';
$string['core.fileuploader.camera'] = 'Camera';
$string['core.fileuploader.confirmuploadfile'] = 'You are about to upload {{size}}. Are you sure you want to continue?';
$string['core.fileuploader.confirmuploadunknownsize'] = 'It was not possible to calculate the size of the upload. Are you sure you want to continue?';
$string['core.fileuploader.discardrecording'] = 'Discard recording';
$string['core.fileuploader.errorcapturingaudio'] = 'Error capturing audio.';
$string['core.fileuploader.errorcapturingimage'] = 'Error capturing image.';
$string['core.fileuploader.errorcapturingvideo'] = 'Error capturing video.';
$string['core.fileuploader.errorgettingimagealbum'] = 'Error getting image from album.';
$string['core.fileuploader.errormustbeonlinetoupload'] = 'You have to be online to upload files.';
$string['core.fileuploader.errornoapp'] = 'You don\'t have an app installed to perform this action.';
$string['core.fileuploader.errorreadingfile'] = 'Error reading file.';
$string['core.fileuploader.errorwhileuploading'] = 'An error occurred during the file upload.';
$string['core.fileuploader.file'] = 'File';
$string['core.fileuploader.fileuploaded'] = 'The file was successfully uploaded.';
$string['core.fileuploader.maxbytesfile'] = 'The file {{$a.file}} is too large. The maximum size you can upload is {{$a.size}}.';
$string['core.fileuploader.microphonepermissiondenied'] = 'Permission to access the microphone has been denied.';
$string['core.fileuploader.microphonepermissionrestricted'] = 'Microphone access is restricted.';
$string['core.fileuploader.pauserecording'] = 'Pause recording';
$string['core.fileuploader.photoalbums'] = 'Photo albums';
$string['core.fileuploader.readingfile'] = 'Reading file';
$string['core.fileuploader.readingfileperc'] = 'Reading file: {{$a}}%';
$string['core.fileuploader.resumerecording'] = 'Resume recording';
$string['core.fileuploader.selectafile'] = 'Select a file';
$string['core.fileuploader.startrecordinginstructions'] = 'Tap to start recording';
$string['core.fileuploader.uploadafile'] = 'Upload a file';
$string['core.fileuploader.uploading'] = 'Uploading';
$string['core.fileuploader.uploadingperc'] = 'Uploading: {{$a}}%';
$string['core.fileuploader.video'] = 'Video';
$string['core.fullnameandsitename'] = '{{fullname}} ({{sitename}})';
$string['core.goto'] = 'Go to {{$a}}';
$string['core.h5p.errorgetemail'] = 'Error obtaining the user email. Please check your connection and try again.';
$string['core.h5p.offlinedisabled'] = 'The site doesn\'t allow downloading H5P packages.';
$string['core.h5p.play'] = 'Play H5P';
$string['core.hasdatatosync'] = 'This {{$a}} has offline data to be synchronised.';
$string['core.howtoobtaincoordinates'] = 'You can obtain your coordinates using a GPS app or a <a href="{{url}}">maps app</a>.';
$string['core.humanreadablesize'] = '{{size}} {{unit}}';
$string['core.iframehelp'] = 'Is this content not working?';
$string['core.image'] = 'Image';
$string['core.imageviewer'] = 'Image viewer';
$string['core.ioscookieshelp'] = 'Embedded content might require cookies to work. Please go to the app\'s iOS settings, enable \'Allow Cross-Website Tracking\' and try again.';
$string['core.lastdownloaded'] = 'Last downloaded';
$string['core.lastsync'] = 'Last synchronisation';
$string['core.leave'] = 'Leave';
$string['core.loadmore'] = 'Load more';
$string['core.locationnolongeravailable'] = 'Finding your location is no longer available. {{howToObtain}}';
$string['core.login.authenticating'] = 'Authenticating';
$string['core.login.changepasswordbutton'] = 'Change password';
$string['core.login.changepasswordhelp'] = 'If you have problems changing your password, try again later or contact your school or learning provider.';
$string['core.login.changepasswordreconnectinstructions'] = 'If you didn\'t change your password correctly, you\'ll be asked to do it again.';
$string['core.login.changepasswordsupportsubject'] = 'Need help changing my password';
$string['core.login.confirmdeletesite'] = 'Are you sure you want to remove the account on {{sitename}}?';
$string['core.login.connect'] = 'Connect!';
$string['core.login.connecttomoodle'] = 'Connect to Moodle';
$string['core.login.connecttomoodleapp'] = 'You are trying to connect to a regular Moodle site. Please download the official Moodle app to access this site.';
$string['core.login.connecttoworkplaceapp'] = 'You are trying to connect to a Moodle Workplace site. Please download the Moodle Workplace app to access this site.';
$string['core.login.credentialsdescription'] = 'Please provide your username and password to log in.';
$string['core.login.credentialshelp'] = 'If you have problems logging in, try again later or contact your school or learning provider.';
$string['core.login.credentialssupportsubject'] = 'Need help logging in';
$string['core.login.emailconfirmsentnoemail'] = '<p>An email should have been sent to your address.</p><p>It contains easy instructions to complete your registration.</p>';
$string['core.login.emailnotmatch'] = 'Emails do not match';
$string['core.login.erroraccesscontrolalloworigin'] = 'The cross-origin call you\'re trying to perform has been rejected. Please check https://moodledev.io/general/app/development/setup/app-in-browser';
$string['core.login.errordeletesite'] = 'An error occurred while deleting this account. Please try again.';
$string['core.login.errorexampleurl'] = 'The URL https://campus.example.edu is only an example URL, it\'s not a real site. <strong>Please use the URL of your school or organization\'s site.</strong>';
$string['core.login.errorqrnoscheme'] = 'This URL isn\'t a valid login URL.';
$string['core.login.errorupdatesite'] = 'An error occurred while updating the site\'s token.';
$string['core.login.exceededloginattempts'] = 'Need help logging in? Try {{recoverPassword}} or contact your site support.';
$string['core.login.exceededloginattemptsrecoverpassword'] = 'recovering your password';
$string['core.login.exceededloginattemptssupportsubject'] = 'I can\'t log in';
$string['core.login.exceededloginattemptswithoutpassword'] = 'Need help logging in? Try to contact your site support.';
$string['core.login.exceededloginattemptswithoutsupport'] = 'Need help logging in? Try {{recoverPassword}}.';
$string['core.login.exceededpasswordresetattempts'] = 'It seems you are having trouble accessing your account. You can contact your school or learning provider or try again later.';
$string['core.login.exceededpasswordresetattemptssupportsubject'] = 'I can\'t reset my password';
$string['core.login.faqcannotfindmysiteanswer'] = 'If you tried searching by URL address and still can\'t find your Moodle site, please get in touch with the person who takes care of Moodle in your school or learning organisation.';
$string['core.login.faqcannotfindmysitequestion'] = 'I can\'t find my site by URL address.';
$string['core.login.faqcantloginanswer'] = '<p>Once you\'ve connected to your Moodle site, you should be able to log in with your usual username and password.</p><br><p>If you forgot your username or password, select the option <strong>Lost password?</strong>. If you still have trouble logging in or can\'t see any options for retrieving your username or password, please get in touch with the person who takes care of Moodle in your school or learning organisation.</p>';
$string['core.login.faqcantloginquestion'] = 'I can\'t log in.';
$string['core.login.faqmore'] = 'Check out <a href="https://docs.moodle.org/en/Moodle_app_FAQ#toc" target="_blank">our FAQ</a> for more answers.';
$string['core.login.faqsetupsiteanswer'] = 'Visit {{$link}} to check out the different options you have to create your own Moodle site.';
$string['core.login.faqsetupsitelinktitle'] = 'Get started.';
$string['core.login.faqsetupsitequestion'] = 'I want to set up my own Moodle site.';
$string['core.login.faqtestappanswer'] = 'To test the app in a Moodle demo site, type "teacher" or "student" in the <strong>Your site</strong> field and tap <strong>Connect to your site</strong>.';
$string['core.login.faqtestappquestion'] = 'Can I test the app on a demo site?';
$string['core.login.faqwhatisurlanswer'] = '<p>If you can\'t find your site by name, try searching by your Moodle site URL address (or web address) instead.</p><p>To find your site address:</p><ol><li>Open a web browser and go to your Moodle site login page.</li><li>At the top of the page, in the address bar, you\'ll see the URL address of your Moodle site, e.g. "campus.example.edu".<br>{{$image}}</li><li>Copy the URL (don\'t copy the /login nor what comes after), paste it into <strong>Your site</strong> in the app, then tap <strong>Connect to your site</strong></li><li>Now you can log in to your site with your username and password.</li></ol><p>If you tried searching by URL address and still can\'t find your Moodle site, please get in touch with the person who takes care of Moodle in your school or learning organisation.</p>';
$string['core.login.faqwhatisurlquestion'] = 'How can I find my site?';
$string['core.login.faqwhereisqrcode'] = 'Where can I find the QR code?';
$string['core.login.faqwhereisqrcodeanswer'] = '<p>If your school or learning provider has enabled it, you will find a QR code on the web site at the bottom of your user profile page.</p>{{$image}}';
$string['core.login.findyoursite'] = 'Find your site';
$string['core.login.invalidaccount'] = 'Please check your login details and try again.';
$string['core.login.invalidmoodleversion'] = 'The version of this Moodle site is too old. The Moodle App works with sites that use {{$a}} or newer.';
$string['core.login.invalidsite'] = 'The site URL is not valid.';
$string['core.login.invalidtime'] = 'Time not valid';
$string['core.login.invalidvaluemax'] = 'The maximum value is {{$a}}';
$string['core.login.invalidvaluemin'] = 'The minimum value is {{$a}}';
$string['core.login.loginbutton'] = 'Log in';
$string['core.login.mobileservicesnotenabled'] = 'Mobile services are not enabled on the site.';
$string['core.login.morewaystologin'] = 'More ways to log in';
$string['core.login.notloggedin'] = 'You need to be logged in.';
$string['core.login.onboardingcreatemanagecourses'] = 'Create & manage your courses';
$string['core.login.onboardingenrolmanagestudents'] = 'Enrol & manage your students';
$string['core.login.onboardinggetstarted'] = 'Get started with Moodle';
$string['core.login.onboardingialreadyhaveasite'] = 'I already have a Moodle site';
$string['core.login.onboardingimalearner'] = 'I\'m a learner';
$string['core.login.onboardingimaneducator'] = 'I\'m an educator';
$string['core.login.onboardingineedasite'] = 'I need a Moodle site';
$string['core.login.onboardingprovidefeedback'] = 'Provide timely feedback';
$string['core.login.onboardingtoconnect'] = 'To connect to the Moodle App you\'ll need a Moodle site';
$string['core.login.onboardingwelcome'] = 'Welcome to the Moodle App!';
$string['core.login.or'] = 'Or';
$string['core.login.passwordrequired'] = 'Password required';
$string['core.login.recaptchachallengeimage'] = 'reCAPTCHA challenge image';
$string['core.login.recaptchaexpired'] = 'Verification expired. Answer the security question again.';
$string['core.login.recaptchaincorrect'] = 'The security question answer is incorrect.';
$string['core.login.reconnect'] = 'Reconnect';
$string['core.login.reconnecthelp'] = 'If you have problems reconnecting, try again later or contact your school or learning provider.';
$string['core.login.reconnectsupportsubject'] = 'Need help reconnecting';
$string['core.login.reconnecttosite'] = 'Reconnect to the site';
$string['core.login.removeaccount'] = 'Remove account';
$string['core.login.searchby'] = 'Search by:';
$string['core.login.selectsite'] = 'Please select your account:';
$string['core.login.signupplugindisabled'] = '{{$a}} is not enabled.';
$string['core.login.signuprequiredfieldnotsupported'] = 'The signup form contains a required custom field that isn\'t supported in the app. Please create your account using a web browser.';
$string['core.login.siteaddress'] = 'Your site';
$string['core.login.siteaddressplaceholder'] = 'https://campus.example.edu';
$string['core.login.sitebadgedescription'] = 'There are {{count}} unread notifications.';
$string['core.login.sitehasredirect'] = 'Your site contains at least one HTTP redirect. The app cannot follow redirects, this could be the issue that\'s preventing the app from connecting to your site.';
$string['core.login.siteinmaintenance'] = 'Your site is in maintenance mode';
$string['core.login.sitenotallowed'] = 'This site is no longer available.';
$string['core.login.siteurl'] = 'Site URL';
$string['core.login.siteurlrequired'] = 'Site URL required i.e <i>https://campus.example.edu</i>';
$string['core.login.stillcantconnect'] = 'Still can\'t connect?';
$string['core.login.toggleremove'] = 'Edit accounts list';
$string['core.login.unsupportedsite'] = 'Site not accessible through the app';
$string['core.login.unsupportedsitemessage'] = '{{site}} can\'t be accessed through this app.<br><br>You can still access it using a web browser.';
$string['core.login.usernamerequired'] = 'Username required';
$string['core.login.visitchangepassword'] = 'Do you want to visit the site to change the password?';
$string['core.login.webservicesnotenabled'] = 'Web services are not enabled on the site.';
$string['core.login.youcanstillconnectwithcredentials'] = 'You can still connect to the site by entering your username and password.';
$string['core.login.yourenteredsite'] = 'Connect to your site';
$string['core.lostconnection'] = 'Your session has expired. Please log in again to continue.';
$string['core.mainmenu.switchaccount'] = 'Switch account';
$string['core.needhelp'] = 'Need help?';
$string['core.needinternettoaccessit'] = 'You need to be connected to the internet to access it.';
$string['core.networkerrormsg'] = 'There was a problem connecting to the site. Please check your connection and try again.';
$string['core.nooptionavailable'] = 'No option available';
$string['core.nopasswordchangeforced'] = 'You cannot proceed without changing your password.';
$string['core.nopermissionerror'] = 'Sorry, but you do not currently have permissions to do that';
$string['core.notapplicable'] = 'n/a';
$string['core.notavailablecontentinapp'] = 'This content is not available in the app, but you can open it in a web browser using the following button.';
$string['core.notavailableoffline'] = 'This content is not available offline. Please connect to the internet and try again.';
$string['core.notdownloadable'] = 'Not downloadable';
$string['core.notnow'] = 'Not now';
$string['core.notsent'] = 'Not sent';
$string['core.nummore'] = '{{$a}} more';
$string['core.openfile'] = 'Open file';
$string['core.openfilewithextension'] = 'Open {{extension}} file';
$string['core.openfullimage'] = 'Click here to display the full size image';
$string['core.openinbrowser'] = 'Open in browser';
$string['core.openinbrowserdescription'] = 'You will be taken to a web browser';
$string['core.openmodinbrowser'] = 'Open {{$a}} in browser';
$string['core.opensecurityquestion'] = 'Open security question';
$string['core.opensettings'] = 'Open settings';
$string['core.openwith'] = 'Open with...';
$string['core.percentagenumber'] = '{{$a}}%';
$string['core.play'] = 'Play';
$string['core.policy.havereadandagreepolicy'] = 'I have read and agree to the {{policyname}}';
$string['core.policy.nopoliciesyet'] = 'No policies and agreements yet.';
$string['core.policy.policyacceptmandatory'] = 'I understand and agree to the mandatory site policies';
$string['core.policy.sitepolicynotagreederror'] = 'Site policy not agreed.';
$string['core.policy.viewpolicy'] = 'View policy {{policyname}}.';
$string['core.pulltorefresh'] = 'Pull to refresh';
$string['core.qrscanner'] = 'QR scanner';
$string['core.question.cannotdeterminestatus'] = 'Cannot determine status';
$string['core.question.errorattachmentsnotsupportedinsite'] = 'Your site doesn\'t support attaching files to answers yet.';
$string['core.question.errorembeddedfilesnotsupportedinsite'] = 'Your site doesn\'t support editing embedded files yet.';
$string['core.question.errorquestionnotsupported'] = 'This question type is not supported by the app: {{$a}}.';
$string['core.question.howtodraganddrop'] = 'Tap to select then tap to drop.';
$string['core.question.questionmessage'] = 'Question {{$a}}: {{$b}}';
$string['core.redirectingtosite'] = 'You will be redirected to the site.';
$string['core.reminders.atthetime'] = 'At the time of the event';
$string['core.reminders.custom'] = 'Custom...';
$string['core.reminders.customreminder'] = 'Custom reminder';
$string['core.reminders.delete'] = 'Delete reminder';
$string['core.reminders.reminderset'] = 'Reminder set for {{$a}}';
$string['core.reminders.reminderunset'] = 'Reminder deleted';
$string['core.reminders.setareminder'] = 'Set a reminder';
$string['core.reminders.setareminderfor'] = 'Set a reminder for "{{title}}" ({{label}})';
$string['core.reminders.setreminder'] = 'Set reminder';
$string['core.reminders.timebefore'] = '{{value}} {{units}} before';
$string['core.reminders.value'] = 'Value';
$string['core.removedownloadeddata'] = 'Remove downloaded data';
$string['core.removefiles'] = 'Remove files {{$a}}';
$string['core.reportbuilder.filtersapplied'] = 'There may be filters applied to this view. To edit filters or change the sorting order, <a href="{{$a}}">open this report on your browser.</a>';
$string['core.reportbuilder.hidecolumns'] = 'Hide columns';
$string['core.reportbuilder.showcolumns'] = 'Show columns';
$string['core.requireduserdatamissing'] = 'This user lacks some required profile data. Please enter the data in your site and try again.<br>{{$a}}';
$string['core.resume'] = 'Resume';
$string['core.retry'] = 'Retry';
$string['core.scanqr'] = 'Scan QR code';
$string['core.scrollbackward'] = 'Scroll backward';
$string['core.scrollforward'] = 'Scroll forward';
$string['core.search.allcategories'] = 'All categories';
$string['core.search.empty'] = 'What are you searching for?';
$string['core.search.filtercategories'] = 'Filter results by';
$string['core.search.filtercourses'] = 'Search in';
$string['core.search.noresults'] = 'No results for "{{$a}}"';
$string['core.search.noresultshelp'] = 'Check for typos or try using different keywords';
$string['core.search.resultby'] = 'By {{$a}}';
$string['core.searching'] = 'Searching';
$string['core.serverconnection'] = 'Error connecting to the server: {{details}}';
$string['core.settings.about'] = 'About';
$string['core.settings.appsettings'] = 'App settings';
$string['core.settings.appversion'] = 'App version';
$string['core.settings.cannotsyncloggedout'] = 'This site cannot be synchronised because you\'ve logged out. Please try again when you\'re logged in the site again.';
$string['core.settings.cannotsyncoffline'] = 'Site synchronisation failed because your device is not connected to the internet.';
$string['core.settings.cannotsyncwithoutwifi'] = 'Your device is not connected to Wi-Fi. Connect to a Wi-Fi network or turn off Data Saver in the app settings.';
$string['core.settings.changelanguage'] = 'Change to {{$a}}';
$string['core.settings.changelanguagealert'] = 'Changing the language will restart the app.';
$string['core.settings.colorscheme'] = 'Color Scheme';
$string['core.settings.colorscheme-dark'] = 'Dark';
$string['core.settings.colorscheme-light'] = 'Light';
$string['core.settings.colorscheme-system'] = 'System default';
$string['core.settings.colorscheme-system-notice'] = 'System default mode will depend on your device support.';
$string['core.settings.compilationinfo'] = 'Compilation info';
$string['core.settings.connecttosync'] = 'Your device is offline. Connect to the internet to synchronise sites.';
$string['core.settings.connectwifitosync'] = 'Connect to a Wi-Fi network or turn off Data saver to synchronise sites.';
$string['core.settings.copyinfo'] = 'Copy device info on the clipboard';
$string['core.settings.cordovadevicemodel'] = 'Cordova device model';
$string['core.settings.cordovadeviceosversion'] = 'Cordova device OS version';
$string['core.settings.cordovadeviceplatform'] = 'Cordova device platform';
$string['core.settings.cordovadeviceuuid'] = 'Cordova device UUID';
$string['core.settings.cordovaversion'] = 'Cordova version';
$string['core.settings.debugdisplaydescription'] = 'If enabled, error modals will display more data about the error if possible.';
$string['core.settings.developeroptions'] = 'Developer options';
$string['core.settings.deviceinfo'] = 'Device info';
$string['core.settings.deviceos'] = 'Device OS';
$string['core.settings.displayformat'] = 'Display format';
$string['core.settings.enableanalytics'] = 'Enable analytics';
$string['core.settings.enableanalyticsdescription'] = 'If enabled, the app will collect anonymous data usage.';
$string['core.settings.enabledownloadsection'] = 'Enable download sections';
$string['core.settings.enablepinchtozoom'] = 'Enable pinch-to-zoom';
$string['core.settings.encryptedpushsupported'] = 'Encrypted push notifications supported';
$string['core.settings.entriesincache'] = '{{$a}} entries in cache';
$string['core.settings.estimatedfreespace'] = 'Estimated free space';
$string['core.settings.filesystemroot'] = 'File system root';
$string['core.settings.fontsize'] = 'Text size';
$string['core.settings.forcedsetting'] = 'This setting has been forced by your site configuration.';
$string['core.settings.helpusimprove'] = 'Help us improve this app';
$string['core.settings.ioscookies'] = 'Cross-Website Tracking';
$string['core.settings.ioscookiesdescription'] = 'Embedded content from the site might require cross-site cookies to work. To enable it, please go to the app\'s iOS settings and enable \'Allow Cross-Website Tracking\'.';
$string['core.settings.legaldisclaimer'] = 'Legal disclaimer';
$string['core.settings.localnotifavailable'] = 'Local notifications available';
$string['core.settings.locationhref'] = 'Web view URL';
$string['core.settings.logintosync'] = 'Log in to synchronise';
$string['core.settings.navigatorlanguage'] = 'Navigator language';
$string['core.settings.navigatoruseragent'] = 'Navigator userAgent';
$string['core.settings.networkstatus'] = 'Internet connection status';
$string['core.settings.opensourcelicenses'] = 'Open Source Licences';
$string['core.settings.privacypolicy'] = 'Privacy policy';
$string['core.settings.publisher'] = 'Publisher';
$string['core.settings.pushid'] = 'Push notifications ID';
$string['core.settings.reportinbackground'] = 'Report errors automatically';
$string['core.settings.screen'] = 'Screen information';
$string['core.settings.showdownloadoptions'] = 'Show download options';
$string['core.settings.siteinfo'] = 'Site info';
$string['core.settings.sitesynccompleted'] = 'Site synchronisation completed.';
$string['core.settings.sitesyncfailed'] = 'Site synchronisation failed';
$string['core.settings.spaceusage'] = 'Space usage';
$string['core.settings.syncdatasaver'] = 'Data saver: Synchronise only when on Wi-Fi';
$string['core.settings.synchronization'] = 'Synchronisation';
$string['core.settings.synchronizenow'] = 'Synchronise now';
$string['core.settings.synchronizenowhelp'] = 'Synchronising a site will send pending changes and all offline activity stored in the device and will synchronise some data like messages and notifications.';
$string['core.settings.syncsettings'] = 'Synchronisation settings';
$string['core.settings.wificonnection'] = 'Wi-Fi connection';
$string['core.settings.youradev'] = 'You are now a developer';
$string['core.sharedfiles.chooseaccountstorefile'] = 'Choose an account to store the file in.';
$string['core.sharedfiles.chooseactionrepeatedfile'] = 'A file with this name already exists. Do you want to replace the existing file or rename it to "{{$a}}"?';
$string['core.sharedfiles.errorreceivefilenosites'] = 'There are no sites stored. Please add a site before sharing a file with the app.';
$string['core.sharedfiles.nosharedfiles'] = 'There are no shared files stored on this site.';
$string['core.sharedfiles.nosharedfilestoupload'] = 'You have no files to upload here. If you want to upload a file from another app, locate the file and click the \'Open in\' button.';
$string['core.sharedfiles.rename'] = 'Rename';
$string['core.sharedfiles.replace'] = 'Replace';
$string['core.sharedfiles.sharedfiles'] = 'Shared files';
$string['core.sharedfiles.successstorefile'] = 'File successfully stored. Select the file to upload to your private files or use in an activity.';
$string['core.sitenotfoundhelp'] = 'We can\'t find the site you entered. Please check for typos or try again later. If you keep seeing this message, contact your school or learning provider.';
$string['core.siteunavailablehelp'] = 'The site "{{site}}" is not available right now. Please try again later or contact your school or learning provider.';
$string['core.sizetb'] = 'TB';
$string['core.sorry'] = 'Sorry...';
$string['core.start'] = 'Start';
$string['core.startingtime'] = 'Starting time: {{$a}}';
$string['core.storingfiles'] = 'Storing files';
$string['core.submittedoffline'] = 'Submitted (Offline)';
$string['core.swipenavigationtourdescription'] = 'Swipe left and right to navigate around.';
$string['core.tablet'] = 'Tablet';
$string['core.tag.errorareanotsupported'] = 'This tag area is not supported by the app.';
$string['core.tag.tagareabadgedescription'] = 'There are {{count}} items.';
$string['core.tag.warningareasnotsupported'] = 'Some of the tag areas are not displayed because they are not supported by the app.';
$string['core.thereisdatatosync'] = 'There are offline {{$a}} to be synchronised.';
$string['core.toggledelete'] = 'Toggle delete buttons';
$string['core.tryagain'] = 'Try again';
$string['core.turnon'] = 'Turn on';
$string['core.turnonexactalarms'] = 'Turn on real-time alerts';
$string['core.turnonnotifications'] = 'Turn on notifications';
$string['core.turnonnotificationsmessage'] = 'Would you like to receive notifications about activities and assignments?';
$string['core.twoparagraphs'] = '{{p1}}<br><br>{{p2}}';
$string['core.unexpectederror'] = 'Unexpected error. Please close and reopen the application then try again.';
$string['core.unicodenotsupported'] = 'Some emojis are not supported on this site. Such characters will be removed when the message is sent.';
$string['core.unicodenotsupportedcleanerror'] = 'Empty text was found when cleaning Unicode chars.';
$string['core.unknown'] = 'Unknown';
$string['core.unzipping'] = 'Unzipping';
$string['core.updaterequired'] = 'App update required';
$string['core.updaterequireddesc'] = 'Please update your app to version {{$a}}';
$string['core.user.completeprofile'] = 'Complete profile';
$string['core.user.completeprofilehelp'] = 'If you have problems completing your profile, try again later or contact your school or learning provider.';
$string['core.user.completeprofilenotice'] = 'Before you continue, please fill in the required fields in your user profile.';
$string['core.user.completeprofilereconnectinstructions'] = 'If you didn\'t complete your profile correctly, you\'ll be asked to do it again.';
$string['core.user.completeprofilesupportsubject'] = 'Need help completing my profile';
$string['core.user.completeyourprofile'] = 'Complete your profile';
$string['core.user.contact'] = 'Contact';
$string['core.user.detailsnotavailable'] = 'The details of this user are not available to you.';
$string['core.user.errorloaduser'] = 'Error loading user.';
$string['core.user.sendemail'] = 'Email';
$string['core.user.support'] = 'Contact site support';
$string['core.user.supportsubject'] = '[App] {{subject}}';
$string['core.user.userwithid'] = 'User with ID {{id}}';
$string['core.usernologin'] = 'Authentication has been revoked for this account';
$string['core.viewcode'] = 'View code';
$string['core.vieweditor'] = 'View editor';
$string['core.viewembeddedcontent'] = 'View embedded content';
$string['core.viewer.decreasetextsize'] = 'Decrease text size';
$string['core.viewer.editimage'] = 'Edit image';
$string['core.viewer.enterreadingmode'] = 'Enter reading mode';
$string['core.viewer.exitreadingmode'] = 'Exit reading mode';
$string['core.viewer.fliphorizontally'] = 'Flip horizontally';
$string['core.viewer.increasetextsize'] = 'Increase text size';
$string['core.viewer.openreadingmodesettings'] = 'Open reading mode settings';
$string['core.viewer.qrscannerdeniedpermissionmessage'] = 'Please allow camera access in your device settings to use the QR scanner.';
$string['core.viewer.qrscannerdeniedpermissiontitle'] = 'Camera permission denied';
$string['core.viewer.qrscannerswitchtofrontcamera'] = 'Switch to front camera';
$string['core.viewer.qrscannerswitchtorearcamera'] = 'Switch to rear camera';
$string['core.viewer.qrscannertitle'] = 'Scan QR code';
$string['core.viewer.qrscannerturnofftorch'] = 'Turn off torch';
$string['core.viewer.qrscannerturnontorch'] = 'Turn on torch';
$string['core.viewer.readingthemeauto'] = 'Match app';
$string['core.viewer.readingthemedark'] = 'Dark';
$string['core.viewer.readingthemehcm'] = 'High contrast';
$string['core.viewer.readingthemelight'] = 'Light';
$string['core.viewer.readingthemesepia'] = 'Sepia';
$string['core.wanttochangesite'] = 'Want to change sites or log out?';
$string['core.warningofflinedatadeleted'] = 'Offline changes to {{component}} \'{{name}}\' have been discarded. {{error}}';
$string['core.warningofflinedatadeletedreason'] = 'Newer changes to this activity have been made from a different device.';
$string['core.warnopeninbrowser'] = '<p>You are about to leave the app to open the following URL in your device\'s browser. Do you want to continue?</p>
<p><b>{{url}}</b></p>';
$string['core.whyisthishappening'] = 'Why is this happening?';
$string['core.wsfunctionnotavailable'] = 'The web service function is not available.';
$string['core.youreoffline'] = 'Your device is offline';
$string['core.youreonline'] = 'Your device is back online';
$string['core.zoomin'] = 'Zoom In';
$string['core.zoomout'] = 'Zoom Out';
$string['freemium.biometriclogin'] = 'Biometric login';
$string['freemium.biometriclogindescription'] = 'Put your finger in the fingerprint reader.';
$string['freemium.biometricloginenablefaceid'] = 'Enable FaceID';
$string['freemium.biometricloginenablefingerprint'] = 'Enable Fingerprint';
$string['freemium.biometricloginenabletouchid'] = 'Enable TouchID';
$string['freemium.biometricloginloginwithfaceid'] = 'Login with FaceID';
$string['freemium.biometricloginloginwithfingerprint'] = 'Login with Fingerprint';
$string['freemium.biometricloginloginwithtouchid'] = 'Login with TouchID';
$string['freemium.biometricloginskip'] = 'Skip for now';
$string['freemium.biometricloginsuccessfullyenabled'] = '{{ biometricMethod }} enabled.';
$string['freemium.biometricloginturnoff'] = 'You can turn this feature on and off at any time under settings.';
$string['freemium.biometriclogintypefaceid'] = 'FaceID';
$string['freemium.biometriclogintypefingerprint'] = 'Fingerprint';
$string['freemium.biometriclogintypetouchid'] = 'TouchID';
$string['freemium.biometricloginwithfingerorface'] = 'Use biometric login with your fingerprint or your face.';
$string['freemium.change'] = 'Change';
$string['freemium.coursesbatchdownloaddisabled'] = 'Downloading courses in batch is not enabled for this site.';
$string['freemium.coursesdownloadlimitreached'] = 'Courses download limit has been reached! You can only have {{limit}} courses downloaded, contact your administrator to increase this limit or remove some downloaded courses from your device.';
$string['freemium.downloadmainapplicationrequired'] = 'You can only connect to this site using the dedicated app.';
$string['freemium.downloadmainapplicationsuggestion'] = 'The site you are trying to connect to has a dedicated app which you may want to try.';
$string['freemium.feature_biometriclogin'] = 'Biometric login';
$string['freemium.feature_coursesdownload'] = 'Downloaded courses';
$string['freemium.feature_multimediapushnotifications'] = 'Multimedia push notifications';
$string['freemium.feature_pushnotificationsdevices'] = 'Push notifications devices';
$string['freemium.feature_qrlogin'] = 'Authenticate using a QR code';
$string['freemium.feature_remotethemes'] = 'Remote themes';
$string['freemium.feature_sitelogo'] = 'Site logo';
$string['freemium.notallowed'] = 'Not allowed';
$string['freemium.nottoday'] = 'Not today';
$string['freemium.qrlogindisabled'] = 'Authentication in the app using a QR code is not enabled for the site:<br><br>{{url}}';
$string['freemium.qrloginexpiredkey'] = 'The QR code has expired. Please refresh the page with the QR code and scan it again.';
$string['freemium.qrloginipmismatch'] = 'The device you\'re using to connect doesn\'t seem to be in the same network as the device that displays the QR code. Please make sure that both devices are connected to the same network (e.g. same WiFi network).<br><br>If the error persists, please contact your site administrator.';
$string['freemium.ratetheapp'] = 'Are you enjoying our app?';
$string['freemium.ratetheapp_feedbackko'] = 'Tell us what went wrong';
$string['freemium.ratetheapp_feedbackmessage'] = 'Your feedback will be anonymous';
$string['freemium.ratetheapp_feedbackok'] = 'Send feedback';
$string['freemium.ratetheapp_feedbackplaceholder'] = 'Write something here';
$string['freemium.ratetheapp_feedbacksent'] = 'Thanks! Your feedback was successfully sent.';
$string['freemium.ratetheapp_sendtostore'] = 'Could you take a moment to rate our app? It will help us to improve the app.';
$string['freemium.remindmelater'] = 'Remind me later';
$string['freemium.settingsoptionsfacial'] = 'Enable facial login';
$string['freemium.settingsoptionsfingerprint'] = 'Enable fingerprint login';
$string['freemium.subscription'] = 'Site subscription';
$string['freemium.subscriptiondetails'] = 'Subscription details';
$string['freemium.subscriptionfeature_exceeded_customlanguagestrings'] = '{{ overflowCount }} custom language strings are being ignored';
$string['freemium.subscriptionfeature_exceeded_custommenuitems'] = '{{ overflowCount }} custom menu items are being ignored';
$string['freemium.subscriptionfeature_exceeded_disabledfeatures'] = '{{ overflowCount }} configured disabled features are still enabled';
$string['freemium.subscriptionfeature_exceeded_remotethemes'] = 'Your custom theme is not being applied';
$string['freemium.subscriptionfeature_exceeded_sitelogo'] = 'Your site logo is not being applied';
$string['freemium.subscriptionfeature_limited'] = 'Limited to {{ limit }}';
$string['freemium.subscriptionfeature_unlimited'] = 'Unlimited';
$string['freemium.subscriptionplan'] = 'Subscription plan';
$string['freemium.subscriptionplan_expired'] = 'expired';
$string['freemium.subscriptionplan_free'] = 'Free';
$string['freemium.subscriptionplan_upgrade'] = 'Upgrade your plan';
$string['freemium.subscriptionplan_validuntil'] = 'valid until {{ date }}';
$string['freemium.subscriptionplandescription'] = 'Subscription plans indicate which restriction apply for this site.';
$string['freemium.subscriptionplanlearnmore'] = 'Learn more';
$string['freemium.upsell_renewexpired'] = 'Your subscription has expired';
$string['freemium.upsell_renewexpiring'] = 'Your subscription will expire in {{ days }} days';
$string['freemium.upsell_renewtitle'] = 'Renew your subscription';
$string['freemium.upsell_upgradefreeaccept'] = 'Upgrade';
$string['freemium.upsell_upgradefreemessage'] = 'You are currently on the free plan, upgrade to unlock more features.';
$string['freemium.upsell_upgradefreepostpone'] = 'Later';
$string['freemium.upsell_upgradefreetitle'] = 'Upgrade your plan';
$string['workplace.teams.isoverdue'] = 'Has overdue or expired items';

/* AUTO END */

// Deprecated since v4.4.0
$string['addon.mod_quiz.finishnotsynced'] = 'Finished but not synchronised';
$string['core.login.policyacceptmandatory'] = 'I understand and agree to the mandatory site policies';
$string['core.login.sitepolicynotagreederror'] = 'Site policy not agreed.';

// Deprecated since v5.0.0
$string['addon.block_myoverview.nocoursesenrolled'] = 'You\'re not enrolled in any courses yet.';
$string['addon.messages.nousersfound'] = 'No users found';
$string['addon.messages.type_blocked'] = 'Blocked';
$string['addon.messages.type_offline'] = 'Offline';
$string['addon.messages.type_online'] = 'Online';
$string['addon.messages.type_search'] = 'Search results';
$string['addon.mod_data.gettinglocation'] = 'Getting location';
$string['addon.mod_data.locationnotenabled'] = 'Location is not enabled';
$string['addon.mod_data.locationpermissiondenied'] = 'Permission to access your location has been denied.';
$string['addon.mod_forum.group'] = 'Group';
$string['addon.mod_glossary.searchquery'] = 'Search query';
$string['addon.mod_scorm.errorinvalidversion'] = 'Sorry, the application only supports SCORM 1.2.';
$string['addon.mod_scorm.errornotdownloadable'] = 'Your school or learning provider has disabled the download of SCORM packages.';
$string['addon.mod_scorm.errorpackagefile'] = 'Sorry, the application only supports ZIP packages.';
$string['addon.mod_survey.results'] = 'Results';
$string['addon.notifications.notifications'] = 'Notifications';
$string['core.confirmcanceledit'] = 'Are you sure you want to leave this page? All changes will be lost.';
$string['core.confirmleaveunknownchanges'] = 'Are you sure you want to leave this page? If you have unsaved changes they will be lost.';
$string['core.course.activitydisabled'] = 'Your organisation has disabled this activity in the mobile app.';
$string['core.course.activitynotyetviewableremoteaddon'] = 'Your organisation installed a plugin that is not yet supported.';
$string['core.courses.enrolme'] = 'Enrol me';
$string['core.fileuploader.audio'] = 'Audio';
$string['core.networkerroriframemsg'] = 'This content is not available offline. Please connect to the internet and try again.';
$string['core.settings.enablerichtexteditor'] = 'Enable text editor';
$string['core.settings.enablerichtexteditordescription'] = 'If enabled, a text editor will be available when entering content.';
$string['core.uhoh'] = 'Uh oh!';

// Deprecated since v5.1.0
$string['addon.messages.contactlistempty'] = 'The contact list is empty';
$string['addon.messages.contactname'] = 'Contact name';
$string['addon.messages.type_strangers'] = 'Others';
$string['core.mainmenu.usermenutourdescription'] = 'The place to check your grades, change your preferences or switch accounts.';
$string['core.mainmenu.usermenutourtitle'] = 'Explore your personal area';
