define("editor_ousupsub/editor",["exports"],(function(_exports){function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}
/**
   * OUSupSub Editor Manager.
   *
   * @module editor_ousupsub/editor
   * @copyright  2024 The Open University.
   * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.loadEditor=void 0;const defaultActions={sup:{name:"superscript",tag:"sup",class:"ousupsub_superscript_button_superscript"},sub:{name:"subscript",tag:"sub",class:"ousupsub_subscript_button_subscript"}};class OUSupSubEditor{constructor(settings){_defineProperty(this,"defaultSetting",{element:"",type:"both",classes:{wrap:"ousupsub-wrap",editor:"editor_ousupsub",contentWrap:"editor_ousupsub_content_wrap",content:"editor_ousupsub_content",toolbar:"editor_ousupsub_toolbar",toolbarGroup:"ousupsub_group",button:"ousupsub-button"},custom:{editor:"",content:"",toolbar:"",button:"",contentWrap:"",wrap:"",toolbarGroup:""}}),_defineProperty(this,"history",[]),_defineProperty(this,"historyIndex",-1),_defineProperty(this,"initEditorContent",(()=>{var _custom$content,_custom$contentWrap;const{classes:classes,custom:custom}=this.settings,contentElement=this.createElement("div",{class:(classes.content+" "+(null!==(_custom$content=custom.content)&&void 0!==_custom$content?_custom$content:"")).trim(),contenteditable:!0,autocapitalize:"none",autocorrect:"off",role:"textbox",spellcheck:!1,"aria-live":"off",id:"".concat(this.settings.element.replace(/:/g,":"),"editable")});contentElement.addEventListener("blur",(()=>{this.saveHistory()})),document.addEventListener("selectionchange",(()=>this.handleSelectionChange())),contentElement.addEventListener("keydown",(event=>{const range=window.getSelection().getRangeAt(0),keyMap={key:{ArrowUp:"sup",94:"sup",ArrowDown:"sub",95:"sub"},shiftKey:{"^":"sup",_:"sub"}};if((keyMap.key[event.key]||event.shiftKey&&keyMap.shiftKey[event.key])&&(event.preventDefault(),this.handleSupSubHotKey(keyMap.key[event.key]||keyMap.shiftKey[event.key])),event.ctrlKey&&this.saveHistory(),"Enter"===event.key&&event.preventDefault(),event.ctrlKey&&"z"===event.key&&(event.preventDefault(),this.handleUndo()),event.ctrlKey&&"y"===event.key&&(event.preventDefault(),this.handleRedo()),""===this.cleanHTML(event.target.innerHTML)&&!this.isSelectionInsideSubSup()){const emptyText=document.createTextNode("\ufeff");range.insertNode(emptyText)}this.getTextArea().value=this.getCleanHTML()})),contentElement.addEventListener("paste",(event=>{this.handlePaste(event)}));const wrapContent=this.createElement("div",{class:(classes.contentWrap+" "+(null!==(_custom$contentWrap=custom.contentWrap)&&void 0!==_custom$contentWrap?_custom$contentWrap:"")).trim()});return wrapContent.appendChild(contentElement),wrapContent})),this.settings=Object.assign(this.defaultSetting,settings),this.init()}init(){var _custom$editor;const textareaElement=this.getTextArea(),{classes:classes,custom:custom}=this.settings;if(!textareaElement)return;textareaElement.style.display="none";const editorElement=this.createElement("div",{class:(classes.editor+" "+(null!==(_custom$editor=null==custom?void 0:custom.editor)&&void 0!==_custom$editor?_custom$editor:"")).trim(),id:classes.editor+"-"+this.settings.element}),editorWrap=this.createElement("div",{class:(classes.wrap+" "+custom.wrap).trim()}),toolbarEl=this.initEditorToolbar();editorWrap.appendChild(toolbarEl);const contentElementWrap=this.initEditorContent(),contentEditor=contentElementWrap.querySelector(".".concat(this.settings.classes.content));editorWrap.appendChild(contentElementWrap),editorElement.appendChild(editorWrap);const width=6*this.getTextArea().getAttribute("cols")+41+"px";contentEditor.style.width=width,contentEditor.style.minWidth=width,contentEditor.style.maxWidth=width;const height=6*this.getTextArea().getAttribute("rows")+13,heightEditor="".concat(height-10,"px"),lineHeightEditor="".concat(height-6,"px");contentEditor.style.height=heightEditor,contentEditor.style.minHeight=heightEditor,contentEditor.style.maxHeight=heightEditor,contentEditor.style.lineHeight=lineHeightEditor;const heightContent="".concat(height+1,"px");contentElementWrap.style.minHeight=heightContent;const textareaLabel=document.querySelector('[for="'+this.settings.element+'"]');if(textareaLabel.style.display="inline-block",textareaLabel.style.margin=0,textareaLabel.style.height=heightContent,textareaLabel.style.minHeight=heightContent,textareaLabel.style.maxHeight=heightContent,textareaLabel.classList.contains("accesshide"))textareaLabel.classList.remove("accesshide"),textareaLabel.style.visibility="hidden",editorElement.style.marginLeft="-".concat(parseInt(textareaLabel.offsetWidth),"px");else{textareaLabel.parentNode.style.paddingBottom=heightEditor,textareaLabel.style.verticalAlign="bottom"}textareaElement.insertAdjacentElement("beforebegin",editorElement),this.getEditorContent().innerHTML=this.getContent(),this.saveHistory(),requestAnimationFrame((()=>{textareaLabel.style.lineHeight=contentEditor.style.lineHeight;const heightWrapper=height+1+parseInt(toolbarEl.offsetHeight);editorElement.style.height=heightWrapper+"px",editorElement.style.minHeight=heightWrapper+"px",editorElement.style.maxHeight=heightWrapper+"px"})),document.addEventListener("click",(e=>{if(!editorElement.contains(e.target)){const cleanData=this.getCleanHTML();this.getTextArea().value=cleanData,this.getEditorContent().innerHTML=cleanData,this.setActiveButton(!1)}}))}handlePaste(event){event.preventDefault();const types=event.clipboardData.types;let content,isHTML=!1;null!=types&&types.contains?isHTML=types.contains("text/html"):null!=types&&types.includes&&(isHTML=types.includes("text/html")),content=isHTML?this.cleanPasteHTML(event.clipboardData.getData("text/html")):event.clipboardData.getData("text");const cleanData=content.replaceAll(/[\r\n]+/g,"");document.execCommand("insertHTML",!1,cleanData),this.saveHistory(),this.getTextArea().value=this.getCleanHTML()}handleUndo(){this.historyIndex>0&&(this.historyIndex--,this.getEditorContent().innerHTML=this.history[this.historyIndex],this.getTextArea().value=this.history[this.historyIndex])}handleRedo(){this.historyIndex<this.history.length-1&&(this.historyIndex++,this.getEditorContent().innerHTML=this.history[this.historyIndex],this.getTextArea().value=this.history[this.historyIndex])}handleSupSubHotKey(action){const nodeEl=this.isSelectionInsideSubSup();if(nodeEl){const nodeName=nodeEl.nodeName.toLowerCase();nodeName!==action&&this.setFormat(this.getActions(nodeName)[0])}else this.isSupportSupSub(action)&&this.setFormat(this.getActions(action)[0])}handleSelectionChange(){const selection=window.getSelection();if(this.getEditorContent().contains(selection.anchorNode)){const node=this.isSelectionInsideSubSup();node?this.setActiveButton(node.nodeName.toLowerCase()):this.setActiveButton(!1)}}createElement(tag){let attributes=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const element=document.createElement(tag);for(let attribute in attributes)element.setAttribute(attribute,attributes[attribute]);return element}isSelectionInsideSubSup(){const selection=window.getSelection();if(0===selection.rangeCount)return!1;const range=selection.getRangeAt(0),tagName=range.commonAncestorContainer.parentNode.nodeName;if(selection.isCollapsed)return!!this.isSupSubTag(tagName)&&range.commonAncestorContainer.parentNode;let nodeNames;const selectionNodes=range.cloneContents().childNodes;for(let node of selectionNodes){const nodeName=node.nodeName;if(""!==node.textContent){if(!this.isSupSubTag(nodeName)&&"#text"===nodeName&&!this.isSupSubTag(tagName))return!1;if(nodeNames||(nodeNames=node),!nodeNames.isEqualNode(node))return!1}}return"#text"===nodeNames.nodeName||this.isSupSubTag(tagName)?range.commonAncestorContainer.parentNode:nodeNames}isSupSubTag(tagName){return["SUB","SUP"].includes(tagName)}setActiveButton(type){const{toolbar:toolbar,button:button}=this.settings.classes;var _this$getSupSubButton,_this$getSupSubButton2;(this.getEditor().querySelectorAll(".".concat(toolbar," .").concat(button)).forEach((button=>button.classList.remove("highlight"))),!1!==type)&&(null===(_this$getSupSubButton=this.getSupSubButton(type))||void 0===_this$getSupSubButton||null===(_this$getSupSubButton2=_this$getSupSubButton.classList)||void 0===_this$getSupSubButton2||_this$getSupSubButton2.add("highlight"))}initEditorToolbar(){var _this$settings$custom,_this$settings,_this$settings$custom2,_this$settings$custom3,_this$settings3,_this$settings3$custo;const toolbarGroup=this.createElement("div",{class:(this.settings.classes.toolbarGroup+" "+(null!==(_this$settings$custom=null===(_this$settings=this.settings)||void 0===_this$settings||null===(_this$settings$custom2=_this$settings.custom)||void 0===_this$settings$custom2?void 0:_this$settings$custom2.toolbarGroup)&&void 0!==_this$settings$custom?_this$settings$custom:"")).trim()});this.getActions(this.settings.type).forEach((action=>{var _this$settings2;const button=this.createElement("button",{class:(null===(_this$settings2=this.settings)||void 0===_this$settings2?void 0:_this$settings2.classes.button)+" "+action.class,title:this.settings.buttons[action.name].title,type:"button","data-action":action.name});button.innerHTML=this.settings.buttons[action.name].icon,button.setAttribute("type","button"),button.onclick=()=>{const selection=window.getSelection(),nodeEl=this.isSelectionInsideSubSup();if(selection.isCollapsed&&!1!==nodeEl&&nodeEl.nodeName.toLowerCase()!==action.tag)return button.blur(),void this.getEditorContent().focus();this.getEditorContent().focus(),this.setFormat(action)},toolbarGroup.appendChild(button)}));const toolbarEl=this.createElement("div",{class:(this.settings.classes.toolbar+" "+(null!==(_this$settings$custom3=null===(_this$settings3=this.settings)||void 0===_this$settings3||null===(_this$settings3$custo=_this$settings3.custom)||void 0===_this$settings3$custo?void 0:_this$settings3$custo.toolbar)&&void 0!==_this$settings$custom3?_this$settings$custom3:"")).trim()});return toolbarEl.appendChild(toolbarGroup),toolbarEl}setFormat(action){const selection=window.getSelection(),range=selection.getRangeAt(0),{tag:tag}=action,nodeEl=this.isSelectionInsideSubSup();if(selection.isCollapsed){const parentNode=range.commonAncestorContainer.parentNode;if(parentNode.nodeName.toLowerCase()===tag){const beforeText=this.createElement(tag);beforeText.innerText=parentNode.textContent.slice(0,range.startOffset);const emptyText=document.createTextNode("\ufeff"),afterText=this.createElement(tag);afterText.innerText=parentNode.textContent.slice(range.startOffset),""!==afterText.innerHTML&&parentNode.parentNode.insertBefore(afterText,parentNode.nextSibling),parentNode.parentNode.insertBefore(emptyText,parentNode.nextSibling),""!==beforeText.innerHTML&&parentNode.parentNode.insertBefore(beforeText,parentNode.nextSibling),parentNode.remove(),range.setStart(emptyText,1),range.setEnd(emptyText,1),selection.removeAllRanges(),selection.addRange(range)}else{const node=this.createElement(tag);node.appendChild(document.createTextNode("\ufeff")),range.insertNode(node),range.setStart(node.firstChild,1),range.setEnd(node.firstChild,1),selection.removeAllRanges(),selection.addRange(range)}}else if(nodeEl){const selectedText=range.toString(),parentElement=nodeEl,nextSibling=parentElement.nextSibling,beforeText=parentElement.textContent.slice(0,range.startOffset),afterText=parentElement.textContent.slice(range.endOffset);if(beforeText){const start=this.createElement(parentElement.nodeName.toLowerCase());start.textContent=beforeText,parentElement.parentNode.insertBefore(start,nextSibling)}const textNode=document.createTextNode(selectedText);if(parentElement.parentNode.insertBefore(textNode,nextSibling),afterText){const end=this.createElement(parentElement.nodeName.toLowerCase());end.textContent=afterText,parentElement.parentNode.insertBefore(end,nextSibling)}parentElement.remove(),range.setStart(textNode,0),range.setEnd(textNode,selectedText.length),selection.removeAllRanges(),selection.addRange(range),this.getTextArea().value=this.getCleanHTML()}else{const selectedText=range.toString();range.deleteContents();const previousNode=range.commonAncestorContainer.previousSibling,nextNode=range.commonAncestorContainer.nextSibling;if(previousNode||nextNode){var _previousNode$nodeNam,_nextNode$nodeName;const newNode=this.createElement(tag);let startOffset=0,endOffset=0,content="";if(previousNode&&(null==previousNode||null===(_previousNode$nodeNam=previousNode.nodeName)||void 0===_previousNode$nodeNam?void 0:_previousNode$nodeNam.toLowerCase())===tag&&(content=previousNode.textContent,startOffset=content.length,previousNode.remove()),content+=selectedText,endOffset=content.length,nextNode&&(null==nextNode||null===(_nextNode$nodeName=nextNode.nodeName)||void 0===_nextNode$nodeName?void 0:_nextNode$nodeName.toLowerCase())===tag&&(content+=nextNode.textContent,nextNode.remove()),newNode.textContent=content,content!==selectedText)return range.insertNode(newNode),range.setStart(newNode.firstChild,startOffset),range.setEnd(newNode.firstChild,endOffset),void(this.getTextArea().value=this.getCleanHTML())}const newNode=document.createElement(tag);newNode.appendChild(document.createTextNode(selectedText)),selection.removeAllRanges(),range.insertNode(newNode),range.selectNodeContents(newNode.firstChild),selection.addRange(range),this.getEditorContent().childNodes.forEach((el=>{"#text"===el.nodeName&&""===el.textContent&&el.remove()})),this.getTextArea().value=this.getCleanHTML()}this.getEditorContent().childNodes.forEach((el=>{"#text"===el.nodeName&&""===el.textContent&&el.remove()})),this.saveHistory()}saveHistory(){const content=this.getCleanHTML();-1!==this.historyIndex&&content===this.history[this.historyIndex]||(this.history.splice(this.historyIndex+1),this.history.push(content),this.historyIndex++)}cleanPasteHTML(content){if(!content||0===content.length)return"";let rules=[{regex:/<\s*\/html\s*>([\s\S]+)$/gi,replace:""},{regex:/<!--\[if[\s\S]*?endif\]-->/gi,replace:""},{regex:/<!--(Start|End)Fragment-->/gi,replace:""},{regex:/<xml[^>]*>[\s\S]*?<\/xml>/gi,replace:""},{regex:/<\?xml[^>]*>[\s\S]*?<\\\?xml>/gi,replace:""},{regex:/<\/?\w+:[^>]*>/gi,replace:""}];if(content=this.filterContentWithRules(content,rules),0===(content=this.cleanHTML(content)).length||!/\S/.test(content))return content;const holder=document.createElement("div");return holder.innerHTML=content,content=holder.innerHTML,holder.innerHTML="",rules=[{regex:/(<[^>]*?style\s*?=\s*?"[^>"]*?)(?:[\s]*MSO[-:][^>;"]*;?)+/gi,replace:"$1"},{regex:/(<[^>]*?class\s*?=\s*?"[^>"]*?)(?:[\s]*MSO[_a-zA-Z0-9-]*)+/gi,replace:"$1"},{regex:/(<[^>]*?class\s*?=\s*?"[^>"]*?)(?:[\s]*Apple-[_a-zA-Z0-9-]*)+/gi,replace:"$1"},{regex:/<a [^>]*?name\s*?=\s*?"OLE_LINK\d*?"[^>]*?>\s*?<\/a>/gi,replace:""}],content=this.filterContentWithRules(content,rules),this.cleanHTML(content)}isSupportSupSub(action){const{type:type}=this.settings;return"both"===type||type===action}filterContentWithRules(content,rules){for(const element of rules)content=content.replace(element.regex,element.replace);return content}cleanHTML(content){return this.filterContentWithRules(content,[{regex:/<p[^>]*>(&nbsp;|\s)*<\/p>/gi,replace:""},{regex:/<sup[^>]*(&nbsp;|\s)*>/gi,replace:"<sup>"},{regex:/<sub[^>]*(&nbsp;|\s)*>/gi,replace:"<sub>"},{regex:/&nbsp;/gi,replace:" "},{regex:/<\/sup>(\s*)+<sup>/gi,replace:"$1"},{regex:/<\/sub>(\s*)+<sub>/gi,replace:"$1"},{regex:/<sup>(\s*)+/gi,replace:"$1<sup>"},{regex:/<sub>(\s*)+/gi,replace:"$1<sub>"},{regex:/(\s*)+<\/sup>/gi,replace:"</sup>$1"},{regex:/(\s*)+<\/sub>/gi,replace:"</sub>$1"},{regex:/<br>/gi,replace:""},{regex:/<style[^>]*>[\s\S]*?<\/style>/gi,replace:""},{regex:/<!--(?![\s\S]*?-->)/gi,replace:""},{regex:/<script[^>]*>[\s\S]*?<\/script>/gi,replace:""},{regex:/<\/?(?:br|title|meta|style|std|font|html|body|link|a|ul|li|ol)[^>]*?>/gi,replace:""},{regex:/<\/?(?:b|i|u|ul|ol|li|img)[^>]*?>/gi,replace:""},{regex:/<\/?(?:abbr|address|area|article|aside|audio|base|bdi|bdo|blockquote)[^>]*?>/gi,replace:""},{regex:/<\/?(?:button|canvas|caption|cite|code|col|colgroup|content|data)[^>]*?>/gi,replace:""},{regex:/<\/?(?:datalist|dd|decorator|del|details|dialog|dfn|div|dl|dt|element)[^>]*?>/gi,replace:""},{regex:/<\/?(?:em|embed|fieldset|figcaption|figure|footer|form|h1|h2|h3|h4|h5)[^>]*?>/gi,replace:""},{regex:/<\/?(?:h6|header|hgroup|hr|iframe|input|ins|kbd|keygen|label|legend)[^>]*?>/gi,replace:""},{regex:/<\/?(?:main|map|mark|menu|menuitem|meter|nav|noscript|object|optgroup)[^>]*?>/gi,replace:""},{regex:/<\/?(?:option|output|p|param|pre|progress|q|rp|rt|rtc|ruby|samp)[^>]*?>/gi,replace:""},{regex:/<\/?(?:section|select|script|shadow|small|source|std|strong|summary)[^>]*?>/gi,replace:""},{regex:/<\/?(?:svg|table|tbody|td|template|textarea|time|tfoot|th|thead|tr|track)[^>]*?>/gi,replace:""},{regex:/<\/?(?:var|wbr|video)[^>]*?>/gi,replace:""},{regex:/<\/?(?:acronym|applet|basefont|big|blink|center|dir|frame|frameset|isindex)[^>]*?>/gi,replace:""},{regex:/<\/?(?:listing|noembed|plaintext|spacer|strike|tt|xmp)[^>]*?>/gi,replace:""},{regex:/<\/?(?:jsl|nobr)[^>]*?>/gi,replace:""},{regex:/<span(?![^>]*?rangySelectionBoundary[^>]*?)[^>]*>[\s\S]*?([\s\S]*?)<\/span>/gi,replace:"$1"},{regex:/<span(?![^>]*?rangySelectionBoundary[^>]*?)[^>]*>(&nbsp;|\s)*<\/span>/gi,replace:""},{regex:/<span(?![^>]*?rangySelectionBoundary[^>]*?)[^>]*>[\s\S]*?([\s\S]*?)<\/span>/gi,replace:"$1"},{regex:/<sup[^>]*>(&nbsp;|\s)*<\/sup>/gi,replace:""},{regex:/<sub[^>]*>(&nbsp;|\s)*<\/sub>/gi,replace:""},{regex:/<xmlns.*?>(.*?)<\/xmlns.*?>/gi,replace:"$1"},{regex:/\uFEFF/gi,replace:""}])}getCleanHTML(){let html;html=this.getEditorContent().cloneNode(!0).innerHTML;return["<p></p>","<p><br></p>","<br>",'<p dir="rtl" style="text-align: right;"></p>','<p dir="rtl" style="text-align: right;"><br></p>','<p dir="ltr" style="text-align: left;"></p>','<p dir="ltr" style="text-align: left;"><br></p>',"<p>&nbsp;</p>","<p><br>&nbsp;</p>",'<p dir="rtl" style="text-align: right;">&nbsp;</p>','<p dir="rtl" style="text-align: right;"><br>&nbsp;</p>','<p dir="ltr" style="text-align: left;">&nbsp;</p>','<p dir="ltr" style="text-align: left;"><br>&nbsp;</p>'].includes(html)?"":this.cleanHTML(html)}getEditorContent(){return this.getEditor().querySelector(".".concat(this.settings.classes.content))}getEditor(){return document.getElementById("".concat(this.settings.classes.editor,"-").concat(this.settings.element))}getSupSubButton(type){const{toolbar:toolbar,button:button}=this.settings.classes;return this.getEditor().querySelector(".".concat(toolbar," .").concat(button,'[data-action^="').concat(type,'"]'))}getActions(type){return defaultActions[type]?[defaultActions[type]]:Object.values(defaultActions)}getButtonContainer(){return this.getEditor().querySelectorAll(".".concat(this.settings.classes.toolbar," .").concat(this.settings.classes.button))}getContent(){return this.getTextArea().value}getEditorId(){return this.settings.element}getTextArea(){return document.getElementById(this.settings.element)}}_exports.loadEditor=settings=>{const editor=new OUSupSubEditor(settings);window.OUSupSubEditor?window.OUSupSubEditor.addEditor(editor):window.OUSupSubEditor={instances:{[settings.element]:editor},addEditor:function(editor){this.instances[editor.getEditorId()]=editor},getEditorById:function(editorId){return this.instances[editorId]}}}}));

//# sourceMappingURL=editor.min.js.map