define("qtype_crossword/crossword_grid",["exports","qtype_crossword/crossword_question","./crossword_clue","core/str"],(function(_exports,_crossword_question,_crossword_clue,_str){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.CrosswordGrid=void 0;
/**
   * CrosswordGrid class handle every function relative to grid.
   *
   * @module qtype_crossword/crossword_grid
   * @copyright 2022 The Open University
   * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
class CrosswordGrid extends _crossword_question.CrosswordQuestion{constructor(options){super(options)}buildBackgroundTable(){let{colsNum:colsNum,rowsNum:rowsNum,previewSetting:previewSetting}=this.options,style=previewSetting;const tableEl=document.createElement("table");colsNum++,rowsNum++,tableEl.className="crossword-grid",tableEl.style.backgroundColor=style.backgroundColor;for(let i=0;i<rowsNum;i++){const rowEl=document.createElement("tr");rowEl.className="grid-row";for(let j=0;j<colsNum;j++){let squareEl=document.createElement("td");squareEl.className="grid-square",squareEl.style.borderColor=style.borderColor,squareEl.style.color=style.color,0===i&&0===j&&squareEl.classList.add("cell-white"),0===i&&0!==j&&(squareEl.innerText=this.getColumnLabel(j-1),squareEl.classList.add("square-indicate-horizontal")),0!==i&&0===j&&(squareEl.innerText=i,squareEl.classList.add("square-indicate-vertical")),rowEl.append(squareEl)}tableEl.append(rowEl)}this.tableEl=tableEl,this.options.crosswordEl.innerHTML=tableEl.outerHTML}async addCell(){let{words:words,previewSetting:previewSetting,rowsNum:rowsNum,colsNum:colsNum}=this.options;const orientationMarks=["→","↓"];if(0!==words.length)for(let i=0;i<words.length;i++){const answer=words[i].answer.trim().replace(/-|\s|\'|‘|’/g,"");let row=words[i].startrow+1,column=words[i].startcolumn+1,answerLength=answer.length,realLength=answerLength+words[i].startcolumn,allowLength=parseInt(colsNum);row++,column++,words[i].orientation&&(realLength=answerLength+words[i].startrow,allowLength=parseInt(rowsNum));for(let j=0;j<answer.length;j++){var _answer$j$toUpperCase;const number=i+1;let isInvalidLetter=!1;const squareEl=document.querySelector(".grid-row:nth-child("+row+") .grid-square:nth-child("+column+")");if(!squareEl)continue;if(squareEl.classList.add("background-white"),0===j){var _words$i$no,_words$i;const labelEl=squareEl.querySelector(".word-label"),labelParams={number:null!==(_words$i$no=null===(_words$i=words[i])||void 0===_words$i?void 0:_words$i.no)&&void 0!==_words$i$no?_words$i$no:number,orientation:orientationMarks[words[i].orientation]},labelText=await(0,_str.get_string)("wordlabel","qtype_crossword",labelParams);if(labelEl){let label=labelEl.innerText;isInvalidLetter=label.includes(orientationMarks[words[i].orientation]),label+=", "+labelText,labelEl.innerText=label}else{let spanEl=document.createElement("span");spanEl.className="word-label text-start",spanEl.innerText=labelText,squareEl.append(spanEl)}}const letter=null!==(_answer$j$toUpperCase=answer[j].toUpperCase().trim())&&void 0!==_answer$j$toUpperCase?_answer$j$toUpperCase:"",contentEl=squareEl.querySelector("span.word-content");if(isInvalidLetter||(isInvalidLetter=this.isContainSpecialCharacters(letter)),contentEl){let text="";const innerText=contentEl.innerText;innerText.search(letter)<0&&(isInvalidLetter=!0,text=innerText+" | "+letter,contentEl.innerText=text)}else{let spanEl=document.createElement("span");spanEl.className="word-content",spanEl.innerText=letter,squareEl.append(spanEl)}(realLength>allowLength||isInvalidLetter)&&(squareEl.style.backgroundColor=previewSetting.conflictColor),words[i].orientation?row++:column++}}}previewCrossword(){this.buildBackgroundTable(),this.addCell()}buildCrossword(){const options=this.options;this.options={...options,width:31*options.colsNum,height:31*options.rowsNum};new _crossword_clue.CrosswordClue(this.options).setUpClue(),this.drawCrosswordSVG(),this.syncDataForInit(),this.addEventResizeScreen()}drawCrosswordSVG(){const options=this.options,crosswordEl=this.options.crosswordEl;if(!crosswordEl)return;let svg=this.createElementNSFrom("svg",{class:"crossword-grid",viewBox:"0 0 ".concat(options.width," ").concat(options.height)});const rectEl=this.createElementNSFrom("rect",{class:"crossword-grid-background",x:0,y:0,width:options.width,height:options.height});svg.append(rectEl),svg=this.createCrosswordBody(svg),svg=this.setSizeForCrossword(svg),svg=this.setBorder(svg);const inputContainEl=this.createElementFrom("div",{class:"crossword-hidden-input-wrapper"}),inputEl=this.createElementFrom("input",{type:"text",class:"crossword-hidden-input",maxlength:1,autocomplete:"off",spellcheck:!1,autocorrect:"off"});this.addEventForWordInput(inputEl),inputContainEl.append(inputEl),options.colsNum>=15&&svg.classList.add("adjust-small-crossword"),options.colsNum>=20&&svg.classList.add("adjust-crossword"),crosswordEl.append(svg,inputContainEl)}createElementNSFrom(type){let attributes=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const element=document.createElementNS("http://www.w3.org/2000/svg",type);for(let key in attributes)element.setAttributeNS(null,key,attributes[key]);return element}createElementFrom(type){let attributes=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};const element=document.createElement(type);for(let key in attributes)element.setAttribute(key,attributes[key]);return element}createCrosswordBody(svg){const{words:words,cellWidth:cellWidth,cellHeight:cellHeight}=this.options;let count=0;for(let i in words){const word=words[i],ignoreList=this.getIgnoreIndexByAnswerNumber(word.number);for(let key=0;key<word.length-ignoreList.length;key++){const customAttribute={"data-startrow":word.startRow,"data-startcolumn":word.startColumn,"data-letterindex":key,"data-word":"("+word.number+")","data-code":"A"+count},position=this.calculatePosition(word,parseInt(key)),rectEl=this.createElementNSFrom("rect",{...position,width:cellWidth,height:cellHeight,class:"crossword-cell"});let g=this.createElementNSFrom("g",{...customAttribute});const existingRectElement=svg.querySelector("rect.crossword-cell[x='".concat(position.x,"'][y='").concat(position.y,"']")),textEl=this.createElementNSFrom("text",{class:"crossword-cell-text",x:position.x+cellWidth/2,y:position.y+cellHeight/2+1,"text-anchor":"middle","alignment-baseline":"middle"});if(existingRectElement){let g,existingNumberElement=existingRectElement.closest("g").querySelector("text.crossword-cell-number"),currentWord=existingRectElement.closest("g").dataset.word;if(existingRectElement.closest("g").dataset.word=currentWord+"("+word.number+")",0!==parseInt(key))continue;existingNumberElement||(g=existingRectElement.closest("g"),this.appendCellNumber(g,position,word.wordNumber))}else g.append(rectEl),0===parseInt(key)&&(g=this.appendCellNumber(g,position,word.wordNumber)),g.append(textEl),this.addEventForG(g),count++,svg.append(g)}}return svg}setBorder(svg){const{colsNum:colsNum,rowsNum:rowsNum,cellWidth:cellWidth,cellHeight:cellHeight,width:width,height:height}=this.options;for(let i=0;i<=rowsNum;i++){let strokeWidth=1;0!==i&&i!==rowsNum||(strokeWidth=2);const horizontalLine=this.createElementNSFrom("line",{x1:0,y1:i*cellHeight,x2:width,y2:i*cellHeight,stroke:"#000","stroke-width":strokeWidth});svg.appendChild(horizontalLine)}for(let i=0;i<=colsNum;i++){let strokeWidth=1;0!==i&&i!==colsNum||(strokeWidth=2);const verticalLine=this.createElementNSFrom("line",{x1:i*cellWidth,y1:0,x2:i*cellWidth,y2:height,stroke:"#000","stroke-width":strokeWidth});svg.appendChild(verticalLine)}return svg}appendCellNumber(g,position,wordNumber){const x=position.x+2,y=position.y+10;let textNumber=this.createElementNSFrom("text",{x:x,y:y,class:"crossword-cell-number"});return textNumber.append(wordNumber),g.append(textNumber),g}addEventForG(g){const{readonly:readonly}=this.options;readonly||g.addEventListener("click",(e=>{const inputEl=this.options.crosswordEl.querySelector(".crossword-hidden-input-wrapper").querySelector("input");let element=e.target;"g"!==element.tagName&&(element=element.closest("g")),this.handleWordSelect(element),inputEl.dataset.code=element.dataset.code,inputEl.value="",this.updatePositionForCellInput(element.querySelector("rect")),inputEl.focus()}))}handleWordSelect(gEl){const currentCell=gEl.dataset.code;let words=gEl.dataset.word,focus=-1,{coordinates:coordinates,wordNumber:wordNumber}=this.options;if(words=words.match(/(\d+)/g),currentCell===coordinates){const indexCell=words.indexOf(wordNumber);focus=void 0!==words[indexCell+1]?words[indexCell+1]:words[0]}else this.options.coordinates=currentCell,wordNumber<0&&(this.options.wordNumber=words[0]),focus=words.includes(wordNumber)?wordNumber:words[0];this.options.wordNumber=focus;const word=this.options.words.find((o=>o.number===parseInt(focus)));word&&(this.updateLetterIndexForCells(word),this.toggleHighlight(word,gEl),this.focusClue(),this.setStickyClue())}updatePositionForCellInput(){let rectEl=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;if(null===rectEl&&(rectEl=this.options.crosswordEl.querySelector("rect.crossword-cell-focussed")),rectEl){const rect=rectEl.getBoundingClientRect(),parentEl=this.options.crosswordEl.querySelector(".crossword-grid").getBoundingClientRect(),inputWrapperEl=this.options.crosswordEl.querySelector(".crossword-hidden-input-wrapper");let top=rect.top-parentEl.top;top<1&&(top=0),inputWrapperEl.style.cssText="\n                display: block; top: ".concat(top+2,"px;\n                left: ").concat(rect.left-parentEl.left+2,"px;\n                width: ").concat(rect.width-3,"px;\n                height: ").concat(rect.height-3,"px\n            ")}}handleInsertTextEventForGridInput(event,value){const{wordNumber:wordNumber,words:words}=this.options;let code=event.target.dataset.code;const upperText=value.toUpperCase();if(""===this.replaceText(value))return;let letterIndex,chars=upperText.split("");const wordObj=words.find((word=>word.number===parseInt(wordNumber)));for(let char of chars){const textEl=this.options.crosswordEl.querySelector("g[data-code='".concat(code,"'] text.crossword-cell-text"));if(!textEl||""===this.replaceText(char))continue;textEl.innerHTML=char,letterIndex||(letterIndex=parseInt(textEl.closest("g").dataset.letterindex));const[charIndex,nextCellEl]=this.findTheClosestCell(wordNumber,wordObj,letterIndex+1);if(this.bindDataToClueInput(textEl.closest("g"),char),!nextCellEl)return;code=nextCellEl.dataset.code,letterIndex=charIndex,nextCellEl.dispatchEvent(new Event("click"))}}addEventForWordInput(inputEl){const{readonly:readonly}=this.options;readonly||(inputEl.addEventListener("beforeinput",(e=>{"insertText"===e.inputType&&e.data&&this.handleInsertTextEventForGridInput(e,e.data)})),inputEl.addEventListener("keypress",(e=>(e.preventDefault(),e.key!==this.BACKSPACE&&(this.handleInsertTextEventForGridInput(e,e.key),!0)))),inputEl.addEventListener("compositionend",(evt=>{evt.preventDefault(),evt.stopPropagation();const{wordNumber:wordNumber,words:words}=this.options,wordObj=words.find((word=>word.number===parseInt(wordNumber)));let key=evt.data.toUpperCase();const code=evt.target.dataset.code;if(""===this.replaceText(key))return!1;if(code){var _this$findTheClosestC;let chars=key.split("");const gEl=this.options.crosswordEl.querySelector("g[data-code='".concat(code,"']"));if(!gEl)return!1;let letterIndex=parseInt(gEl.dataset.letterindex);for(let char of chars){if(""===this.replaceText(char))continue;const[charIndex,cellEl]=this.findTheClosestCell(wordNumber,wordObj,letterIndex);cellEl&&(letterIndex=charIndex,cellEl.querySelector("text.crossword-cell-text").innerHTML=char,this.bindDataToClueInput(cellEl,char),cellEl.querySelector(".crossword-cell-focussed")||cellEl.dispatchEvent(new Event("click")),letterIndex++)}const nextCellEl=null!==(_this$findTheClosestC=this.findTheClosestCell(wordNumber,wordObj,letterIndex).pop())&&void 0!==_this$findTheClosestC?_this$findTheClosestC:null;nextCellEl&&nextCellEl.dispatchEvent(new Event("click"))}return!0})),inputEl.addEventListener("keyup",(event=>{event.preventDefault();const{wordNumber:wordNumber,cellWidth:cellWidth,cellHeight:cellHeight,words:words}=this.options,{key:key,target:target}=event,code=target.dataset.code,gEl=this.options.crosswordEl.querySelector("g[data-code='".concat(code,"']")),word=words.find((o=>o.number===parseInt(wordNumber))),letterIndex=this.findTheClosestCell(wordNumber,word,parseInt(gEl.dataset.letterindex)-1,!1)[0],previousCell=this.options.crosswordEl.querySelector("g[data-word*='(".concat(wordNumber,")'][data-letterindex='").concat(letterIndex,"']")),textEl=gEl.querySelector("text.crossword-cell-text");let x=parseInt(gEl.querySelector("rect").getAttributeNS(null,"x")),y=parseInt(gEl.querySelector("rect").getAttributeNS(null,"y"));if(key!==this.DELETE&&key!==this.BACKSPACE||(""===textEl.innerHTML?previousCell&&previousCell.dispatchEvent(new Event("click")):(textEl.innerHTML="",this.bindDataToClueInput(gEl,"_"))),[this.ARROW_UP,this.ARROW_DOWN,this.ARROW_LEFT,this.ARROW_RIGHT].includes(key)){key===this.ARROW_UP&&(y-=cellHeight),key===this.ARROW_DOWN&&(y+=cellHeight),key===this.ARROW_LEFT&&(x-=cellWidth),key===this.ARROW_RIGHT&&(x+=cellWidth);const nextCell=this.options.crosswordEl.querySelector("g rect[x='".concat(x,"'][y='").concat(y,"']"));nextCell&&nextCell.closest("g").dispatchEvent(new Event("click"))}})),inputEl.addEventListener("click",(e=>{const code=e.target.dataset.code,gEl=this.options.crosswordEl.querySelector("g[data-code='".concat(code,"']"));this.handleWordSelect(gEl)})),inputEl.addEventListener("keydown",(e=>{let{key:key}=e;key=key.toLowerCase(),e.ctrlKey&&(key!==this.Z_KEY&&key!==this.A_KEY||e.preventDefault()),e.key===this.ENTER&&e.preventDefault()})),inputEl.addEventListener("paste",(e=>{e.preventDefault()})))}addEventResizeScreen(){window.addEventListener("resize",(()=>{this.updatePositionForCellInput()}))}}_exports.CrosswordGrid=CrosswordGrid}));

//# sourceMappingURL=crossword_grid.min.js.map