define("qtype_crossword/crossword_question",["exports"],(function(_exports){function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}
/**
   * CrosswordQuestion base class handle every common function.
   *
   * @module qtype_crossword/crossword_question
   * @copyright 2022 The Open University
   * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.CrosswordQuestion=void 0;_exports.CrosswordQuestion=class{constructor(options){_defineProperty(this,"ARROW_LEFT","ArrowLeft"),_defineProperty(this,"ARROW_RIGHT","ArrowRight"),_defineProperty(this,"ARROW_UP","ArrowUp"),_defineProperty(this,"ARROW_DOWN","ArrowDown"),_defineProperty(this,"END","End"),_defineProperty(this,"HOME","Home"),_defineProperty(this,"DELETE","Delete"),_defineProperty(this,"BACKSPACE","Backspace"),_defineProperty(this,"Z_KEY","z"),_defineProperty(this,"A_KEY","a"),_defineProperty(this,"ENTER","Enter"),_defineProperty(this,"MAX_ROW",30);let defaultOption={colsNum:10,rowsNum:10,words:[],target:"#crossword",isPreview:!1,previewSetting:{backgroundColor:"#ffffff",borderColor:"#000000",textColor:"#ffffff",conflictColor:"#f4cece"},cellWidth:31,cellHeight:31,wordNumber:-1,coordinates:"",maxSizeCell:50,minSizeCell:30,specialCharacters:{hyphen:"-",space:" ",straightsinglequote:"'",openingsinglequote:"‘",closingsinglequote:"’"}};defaultOption={...defaultOption,...options},this.options=defaultOption;const targetEls=document.querySelectorAll(defaultOption.target);for(let i=0;i<targetEls.length;i++)if(!targetEls[i].querySelector("svg")){this.crosswordEl=targetEls[i],this.options.crosswordEl=targetEls[i],this.options.isPreview||(this.options.words=this.retrieveWordData());break}}retrieveWordData(){const clueEls=this.options.crosswordEl.closest(".qtype_crossword-grid-wrapper").querySelectorAll(".contain-clue .wrap-clue");return 0===clueEls.length?[]:[...clueEls].map((el=>({number:parseInt(el.dataset.questionid),startRow:parseInt(el.dataset.startrow),startColumn:parseInt(el.dataset.startcolumn),length:parseInt(el.dataset.length),orientation:parseInt(el.dataset.orientation),clue:el.dataset.clue,wordNumber:el.dataset.wordnumber}))).sort(((clueA,clueB)=>clueA.number-clueB.number))}getColumnLabel(index){let text="";const firstLetterIndex=Math.trunc(index/26)-1;let lastLetterIndex=index%26;return firstLetterIndex>-1&&(text=this.retrieveCharacterByIndex(firstLetterIndex)),text+=this.retrieveCharacterByIndex(lastLetterIndex),text}retrieveCharacterByIndex(index){return String.fromCharCode("A".charCodeAt(0)+index)}isContainSpecialCharacters(answer){return/([^\p{L}\p{N}\-\s]+)/giu.test(answer)}makeUnderscore(length){return Array.from({length:length},(()=>"_")).join("")}updateLetterIndexForCells(word){const{wordNumber:wordNumber}=this.options,letterList=this.options.crosswordEl.querySelectorAll("g[data-word*='(".concat(wordNumber,")']")),ignoreList=this.getIgnoreIndexByAnswerNumber(word.number),letterListArray=Array.prototype.slice.call(letterList,0);let letterIndex=0;letterListArray.sort(((a,b)=>{let aValue=parseInt(a.querySelector("rect").getAttributeNS(null,"x")),bValue=parseInt(b.querySelector("rect").getAttributeNS(null,"x"));return word.orientation&&(aValue=parseInt(a.querySelector("rect").getAttributeNS(null,"y")),bValue=parseInt(b.querySelector("rect").getAttributeNS(null,"y"))),aValue-bValue})).forEach((el=>{ignoreList.includes(letterIndex)&&(letterIndex=this.generateLetterIndex(letterIndex,ignoreList,word.length)),el.dataset.letterindex=letterIndex,letterIndex++}))}generateLetterIndex(letterIndex,ignoreList,wordLength){return letterIndex++,ignoreList.includes(letterIndex)||letterIndex>wordLength-1?this.generateLetterIndex(letterIndex,ignoreList,wordLength):letterIndex}focusClue(){const{wordNumber:wordNumber}=this.options,containCrosswordEl=this.options.crosswordEl.closest(".qtype_crossword-grid-wrapper"),clueEl=containCrosswordEl.querySelector(".wrap-clue[data-questionid='".concat(wordNumber,"']")),clueFocusEl=containCrosswordEl.querySelector(".wrap-clue.focus");clueFocusEl&&clueFocusEl.classList.remove("focus"),clueEl&&clueEl.classList.add("focus")}setStickyClue(){const stickyClue=this.options.crosswordEl.closest(".qtype_crossword-grid-wrapper").querySelector(".sticky-clue"),{wordNumber:wordNumber,words:words}=this.options,word=words.find((o=>o.number===parseInt(wordNumber))),clueWrapperSelector='.contain-clue .wrap-clue[data-questionid="'.concat(wordNumber,'"]'),clueContent=this.options.crosswordEl.closest(".qtype_crossword-grid-wrapper").querySelector(clueWrapperSelector+" .clue-content").innerHTML,clueCount=this.options.crosswordEl.closest(".qtype_crossword-grid-wrapper").querySelector(clueWrapperSelector+" .clue-count").innerText;if(!stickyClue&&word)return;let strongEl=stickyClue.querySelector("strong"),clueEl=stickyClue.querySelector("span.clue"),countEl=stickyClue.querySelector("span.count");strongEl||(strongEl=document.createElement("strong"),strongEl.classList.add("me-1","text-nowrap"),stickyClue.append(strongEl)),clueEl||(clueEl=document.createElement("span"),clueEl.classList.add("clue","clearfix"),stickyClue.append(clueEl)),countEl||(countEl=document.createElement("span"),countEl.classList.add("count","text-nowrap","ms-1"),stickyClue.append(countEl)),strongEl.innerText="".concat(word.number," ").concat(this.options.orientation[word.orientation]),clueEl.innerHTML=clueContent,countEl.innerText=clueCount}replaceText(value){return value.replace(/([^\p{L}\p{N}\s]+)/giu,"")}bindDataToClueInput(gEl,key){const{words:words}=this.options,rectEl=gEl.querySelector("rect"),conflictPointX=rectEl.getAttributeNS(null,"x"),conflictPointY=rectEl.getAttributeNS(null,"y");let letterIndex,value;if(gEl){gEl.dataset.word.match(/\d+/g).forEach((wordId=>{const word=words.find((o=>o.number===parseInt(wordId)));if(word){letterIndex=this.findCellOrder(word,conflictPointX,conflictPointY);const clueInputEl=this.options.crosswordEl.closest(".qtype_crossword-grid-wrapper").querySelector(".wrap-clue[data-questionid='".concat(wordId,"'] input"));" "===key&&(key="_"),letterIndex=this.findTheValidLetterIndex(letterIndex,word),value=this.replaceAt(clueInputEl.value,letterIndex,key);let answerString=value.toUpperCase()+this.makeUnderscore(word.length-value.length);const ignoreList=this.getIgnoreIndexByAnswerNumber(word.number,!1);answerString=this.mapAnswerAndSpecialLetter(answerString,ignoreList[0]),clueInputEl.value=answerString}}))}}calculatePosition(word,key){const{cellWidth:cellWidth,cellHeight:cellHeight}=this.options;let x=cellWidth*word.startColumn,y=cellHeight*word.startRow;return word.orientation?y+=key*cellHeight:x+=key*cellWidth,{x:x,y:y}}replaceAt(text,index,char){let a=text.split("");return void 0!==a[index]&&(a[index]=char),a.join("")}syncLettersByText(text){let skipEmptyData=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];const{wordNumber:wordNumber}=this.options;if(0===text.replace(/_/g,"").length&&skipEmptyData)return!1;for(let i in text){const gEl=this.options.crosswordEl.querySelector("g[data-word*='(".concat(wordNumber,")'][data-letterindex='").concat(i,"']"));if(gEl){const letter=text[i].toUpperCase(),textEl=gEl.querySelector("text.crossword-cell-text");"_"!==text[i]?textEl.innerHTML=letter:textEl.innerHTML="",this.bindDataToClueInput(gEl,letter)}}return!0}toggleHighlight(word,gEl){const{wordNumber:wordNumber,orientation:orientation,title:title}=this.options,focus=wordNumber,focusedEl=this.options.crosswordEl.querySelector(".crossword-cell-focussed");focusedEl&&focusedEl.classList.remove("crossword-cell-focussed"),this.options.crosswordEl.querySelectorAll(".crossword-cell-highlighted").forEach((el=>el.classList.remove("crossword-cell-highlighted"))),this.options.crosswordEl.querySelectorAll("g[data-word*='(".concat(focus,")'] rect")).forEach((el=>{let titleData="";if(el.closest("g").dataset.code===gEl.dataset.code){el.classList.add("crossword-cell-focussed");const conflictPointX=gEl.querySelector("rect").getAttributeNS(null,"x"),conflictPointY=gEl.querySelector("rect").getAttributeNS(null,"y");let letterIndex=this.findCellOrder(word,conflictPointX,conflictPointY);const data={row:word.startRow+1,column:word.startColumn+letterIndex+1,number:word.wordNumber,orientation:orientation[word.orientation],clue:word.clue,letter:letterIndex+1,count:word.length-this.getIgnoreIndexByAnswerNumber(wordNumber).length};word.orientation&&(data.row=word.startRow+letterIndex+1,data.column=word.startColumn+1),titleData=this.replaceStringData(title,data),this.options.crosswordEl.querySelector("input.crossword-hidden-input").setAttributeNS(null,"aria-label",titleData)}else el.classList.add("crossword-cell-highlighted")}))}replaceStringData(str,data){for(let key in data)str=str.replace("{".concat(key,"}"),data[key]);return str}syncDataForInit(){const{words:words}=this.options;this.options.crosswordEl.closest(".qtype_crossword-grid-wrapper").querySelectorAll(".wrap-clue input").forEach((element=>{this.options.wordNumber=parseInt(element.closest(".wrap-clue").dataset.questionid);const word=words.find((o=>o.number===this.options.wordNumber));word&&(this.updateLetterIndexForCells(word),this.syncLettersByText(element.value))})),this.options.wordNumber=-1}setSizeForCrossword(svg){const{colsNum:colsNum,maxSizeCell:maxSizeCell,minSizeCell:minSizeCell}=this.options,maxWidth=colsNum*maxSizeCell,minWidth=colsNum*minSizeCell,maxHeight=this.MAX_ROW*minSizeCell;return svg.style.cssText="max-width: ".concat(maxWidth,"px; min-width: ").concat(minWidth,"px;\n            max-height: ").concat(maxHeight,"px;"),svg}getIgnoreIndexByAnswerNumber(answerNumber){var _crosswordEl$closest$,_crosswordEl$closest,_crosswordEl$closest$2,_crosswordEl$closest$3;let forceFlatObject=!(arguments.length>1&&void 0!==arguments[1])||arguments[1];const{crosswordEl:crosswordEl}=this.options;let ignoreIndexes=null!==(_crosswordEl$closest$=null===(_crosswordEl$closest=crosswordEl.closest(".qtype_crossword-grid-wrapper"))||void 0===_crosswordEl$closest||null===(_crosswordEl$closest$2=_crosswordEl$closest.querySelector(".contain-clue .wrap-clue[data-questionid='".concat(answerNumber,"']")))||void 0===_crosswordEl$closest$2||null===(_crosswordEl$closest$3=_crosswordEl$closest$2.dataset)||void 0===_crosswordEl$closest$3?void 0:_crosswordEl$closest$3.ignoreindexes)&&void 0!==_crosswordEl$closest$?_crosswordEl$closest$:"[]";return ignoreIndexes=JSON.parse(ignoreIndexes),Array.isArray(ignoreIndexes)&&0===ignoreIndexes.length&&(ignoreIndexes={}),forceFlatObject?Object.values(ignoreIndexes).flat().sort(((a,b)=>a-b)):[ignoreIndexes]}mapAnswerAndSpecialLetter(answer,specialList){const specials=this.options.specialCharacters;if(0===Object.keys(specialList).length&&specialList.constructor===Object)return answer;for(let character in specialList)if(void 0!==specials[character])for(let index of specialList[character])answer=this.replaceAt(answer,index,specials[character]);return answer}findTheClosestCell(wordNumber,word,selectionIndex){let count=selectionIndex,number=-1,notFound=!0,closestCell=[];for((!(arguments.length>3&&void 0!==arguments[3])||arguments[3])&&(number=Math.abs(number));notFound;){const gelEl=this.options.crosswordEl.querySelector("g[data-word*='(".concat(wordNumber,")'][data-letterindex='").concat(count,"']"));(gelEl||count>word.length||count<=0)&&(notFound=!1,closestCell=[count,gelEl]),count+=number}return closestCell}findTheValidLetterIndex(selectedIndex,word){let isAscending=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];const ignoreIndexes=this.getIgnoreIndexByAnswerNumber(word.number);let number=-1;isAscending&&(number=Math.abs(number));for(let invalidIndex of ignoreIndexes)if(selectedIndex>=invalidIndex){if(!isAscending&&selectedIndex===invalidIndex)continue;selectedIndex+=number}return selectedIndex}findCellIndexFromAnswerIndex(word,answerIndex){let skipIgnoreIndex=!(arguments.length>2&&void 0!==arguments[2])||arguments[2],ignoreIndexes=this.getIgnoreIndexByAnswerNumber(word.number),cellIndex=answerIndex;for(let index=cellIndex;index<word.length&&ignoreIndexes.includes(index);index++)cellIndex++;return skipIgnoreIndex?cellIndex-ignoreIndexes.filter((index=>index<=cellIndex)).length:cellIndex}findCellOrder(word,xCoordinate,yCoordinate){const{cellWidth:cellWidth,cellHeight:cellHeight}=this.options,startPoint=this.calculatePosition(word,0);return word.orientation?(parseInt(yCoordinate)-startPoint.y)/cellHeight:(parseInt(xCoordinate)-startPoint.x)/cellWidth}}}));

//# sourceMappingURL=crossword_question.min.js.map