define("qtype_crossword/crossword_clue",["exports","qtype_crossword/crossword_question"],(function(_exports,_crossword_question){Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.CrosswordClue=void 0;
/**
   * Crossword clue class, handle any action relative to clue.
   *
   * @module qtype_crossword/crossword_clue
   * @copyright 2022 The Open University
   * @license http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */
class CrosswordClue extends _crossword_question.CrosswordQuestion{constructor(options){super(options)}setUpClue(){let{words:words,readonly:readonly}=this.options;this.options.crosswordEl.closest(".qtype_crossword-grid-wrapper").querySelectorAll(".contain-clue .wrap-clue").forEach((el=>{const questionId=el.dataset.questionid;let word=words.find((o=>o.number===parseInt(questionId)));if(word){const inputEl=el.querySelector("input"),ignoreIndexes=this.getIgnoreIndexByAnswerNumber(word.number,!1),wordString=this.makeUnderscore(word.length-inputEl.value.length);inputEl.value+=this.mapAnswerAndSpecialLetter(wordString,ignoreIndexes[0]),readonly||(inputEl.disabled=!1),this.addEventForClueInput(inputEl,word)}}))}addEventForClueInput(el,word){const{readonly:readonly}=this.options;let startSelection=0;readonly||(el.addEventListener("click",(e=>{const blankAnswer=/^[ _-]+$/.test(e.target.value),isCursorAtTheEnd=e.target.selectionEnd===e.target.value.length;let startIndex=e.target.selectionStart;const isClicked=startIndex===e.target.selectionEnd;blankAnswer&&isCursorAtTheEnd&&isClicked&&(startIndex=0);const previousIndex=startIndex-1;!["-"," "].includes(e.target.value.charAt(previousIndex))&&isClicked&&(startIndex=previousIndex<0?0:previousIndex,e.target.setSelectionRange(startIndex,startIndex));const{words:words}=this.options,wordNumber=e.target.closest(".wrap-clue").dataset.questionid,wordObj=words.find((o=>o.number===parseInt(wordNumber)));startIndex=this.findCellIndexFromAnswerIndex(wordObj,startIndex),this.focusCellByStartIndex(startIndex,word),this.focusClue(),this.setStickyClue()})),el.addEventListener("focus",(e=>{e.target.dispatchEvent(new Event("click"))})),el.addEventListener("beforeinput",(e=>{"insertText"===e.inputType&&e.data&&this.handleInsertedCharacterToElement(e,e.data)})),el.addEventListener("input",(e=>{"deleteContentBackward"!==e.inputType&&"deleteContentForward"!==e.inputType||this.handleAndSyncDeletedStringToElement(e.target,e.target.value)})),el.addEventListener("keypress",(e=>{e.preventDefault(),e.key!==this.BACKSPACE&&this.handleInsertedCharacterToElement(e,e.key)})),el.addEventListener("compositionstart",(evt=>{startSelection=evt.target.selectionStart;let value=evt.target.value.split("");value.splice(startSelection,1),evt.target.value=value.join(""),evt.target.setSelectionRange(startSelection,startSelection)})),el.addEventListener("compositionend",(evt=>{evt.preventDefault(),evt.stopPropagation();const{wordNumber:wordNumber}=this.options,selection=evt.target.selectionStart;let key=evt.data.normalize("NFKC");evt.target.setSelectionRange(selection,selection),this.insertCharacters(evt,key,wordNumber,word,startSelection)})),el.addEventListener("keyup",(event=>{event.preventDefault();const{words:words,wordNumber:wordNumber}=this.options,{key:key,target:target}=event;let{value:value}=target,isValidKey=!1,maxLength=parseInt(target.getAttribute("maxlength"));if([this.ARROW_LEFT,this.ARROW_RIGHT].includes(key)){isValidKey=!0;const word=words.find((o=>o.number===parseInt(wordNumber))),startIndex=this.findCellIndexFromAnswerIndex(word,target.selectionStart,!1),gEl=this.options.crosswordEl.querySelector("g[data-word*='(".concat(wordNumber,")'][data-letterindex='").concat(startIndex,"']"));gEl&&this.toggleHighlight(word,gEl)}if(key===this.END||key===this.HOME||key===this.ARROW_UP||key===this.ARROW_DOWN){isValidKey=!0;let startIndex=0;const word=words.find((o=>o.number===parseInt(wordNumber)));if(!word)return;key!==this.END&&key!==this.ARROW_DOWN||(startIndex=word.length-1),this.syncFocusCellAndInput(target,startIndex)}!isValidKey&&startSelection>=maxLength&&(event.target.value=value.slice(0,maxLength))})),el.addEventListener("paste",(event=>{event.preventDefault();const{words:words,wordNumber:wordNumber}=this.options,word=words.find((o=>o.number===parseInt(wordNumber)));let selection=event.target.selectionStart,value=(event.clipboardData||window.clipboardData).getData("text"),ignoreIndexes=this.getIgnoreIndexByAnswerNumber(word.number);if(value=this.replaceText(value).normalize("NFKC"),""===value)return;let letterIndex=1;value.split("").every((char=>{if(letterIndex>word.length-ignoreIndexes.length)return!1;const result=this.handleTypingData(event,wordNumber,word,selection,char);if(letterIndex++,result)for(let index=selection+1;index<word.length;index++)if(!ignoreIndexes.includes(index)){selection=index;break}return!0}))})),el.addEventListener("keydown",(e=>{e.ctrlKey&&e.key.toLowerCase()===this.Z_KEY&&e.preventDefault(),e.key===this.ENTER&&e.preventDefault()})),el.addEventListener("cut",(event=>{const selectString=document.getSelection().toString(),startIndex=event.target.selectionStart;let{value:value}=event.target;value=value.substring(0,startIndex)+value.substring(startIndex+selectString.length)+this.makeUnderscore(selectString.length),event.target.value=value,event.clipboardData.setData("text/plain",selectString),event.preventDefault(),event.target.setSelectionRange(startIndex,startIndex),this.syncLettersByText(value,!1)})))}handleTypingData(evt,wordNumber,word,selectionIndex,char){const[count,gEl]=this.findTheClosestCell(wordNumber,word,selectionIndex);if(""===this.replaceText(char))return!1;gEl&&(gEl.querySelector("text.crossword-cell-text").innerHTML=char.toUpperCase(),this.bindDataToClueInput(gEl,char.toUpperCase()));const[letterIndex,nexEl]=this.findTheClosestCell(wordNumber,word,count+1);return nexEl&&(this.toggleHighlight(word,nexEl),evt.target.setSelectionRange(letterIndex,letterIndex)),!0}focusCellByStartIndex(startIndex,word){let position=this.calculatePosition(word,startIndex);const rect=this.options.crosswordEl.querySelector("g rect[x='".concat(position.x,"'][y='").concat(position.y,"']"));rect&&(this.options.wordNumber=word.number,this.toggleHighlight(word,rect.closest("g")),this.updateLetterIndexForCells(word))}syncFocusCellAndInput(target,startIndex){const{wordNumber:wordNumber}=this.options,gEl=this.options.crosswordEl.querySelector("g[data-word*='(".concat(wordNumber,")'][data-letterindex='").concat(startIndex,"']"));target.setSelectionRange(startIndex,startIndex),gEl&&this.toggleFocus(gEl)}toggleFocus(gEl){const focused=this.options.crosswordEl.querySelector("g rect.crossword-cell-focussed");focused&&(focused.classList.remove("crossword-cell-focussed"),focused.classList.add("crossword-cell-highlighted")),gEl.querySelector("rect").classList.add("crossword-cell-focussed")}handleAndSyncDeletedStringToElement(target,value){const{words:words,wordNumber:wordNumber}=this.options,word=words.find((o=>o.number===parseInt(wordNumber)));if(!word)return;let startIndex=target.selectionStart,selectionLength=word.length-value.length;selectionLength<0&&(selectionLength=0);const underScore=this.makeUnderscore(selectionLength);target.value=[value.slice(0,startIndex),underScore,value.slice(startIndex)].join("").slice(0,word.length),this.syncLettersByText(target.value,!1),this.syncFocusCellAndInput(target,startIndex)}handleInsertedCharacterToElement(event,value){const{words:words,wordNumber:wordNumber}=this.options,word=words.find((o=>o.number===parseInt(wordNumber)));let startIndex=event.target.selectionStart;""!==(value=this.replaceText(value).normalize("NFKC"))&&(event.target.setSelectionRange(startIndex,startIndex),this.insertCharacters(event,value,wordNumber,word,startIndex))}insertCharacters(event,value,wordNumber,word,currentSelection){const ignoreIndexes=this.getIgnoreIndexByAnswerNumber(wordNumber),chars=value.split("");for(;currentSelection<word.length&&0!==chars.length;)ignoreIndexes.includes(currentSelection)||this.handleTypingData(event,wordNumber,word,currentSelection,chars.shift()),currentSelection++;requestAnimationFrame((()=>{ignoreIndexes.includes(currentSelection)&&currentSelection++,event.target.setSelectionRange(currentSelection,currentSelection)}))}}_exports.CrosswordClue=CrosswordClue}));

//# sourceMappingURL=crossword_clue.min.js.map