/**
 * This class provides functionality for the rule creation assistant.
 *
 * This is based on the work of Dr Alistair Willis published:
 * http://aclweb.org/anthology/W/W15/W15-0628.pdf
 *
 * @class     rulecreator
 * @copyright 2016 The Open University
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 * @since     2.9
 */
define("qtype_pmatch/rulecreator",["jquery"],(function($){const t={store:{},init:function(){$('textarea[name^="answer"]').each((function(){const id=$(this).attr("id").replace("id_answer_",""),ref="id_"+id;t.store[ref]=[],""!==$(this).val()&&"match ()"!==$(this).val()?$(this).parent().parent().next().addClass("rc-hidden"):$(this).parent().parent().next().addClass("rcw");const rc=$(this).parent().parent().next().find("div.rule-creator");rc.attr("id","rc_"+id),$(this).parent().parent().next().find("a.rule-creator-btn").attr("id","rc_btn_"+id),rc.find('div[class="rc-notice"]').attr("id","rc_notice_"+id),rc.find('label[for="term"]').attr("for","rc_term_"+id),rc.find('input[name="term"]').attr("id","rc_term_"+id),rc.find('input[name="termadd"]').attr("id","rc_termadd_"+id).click((function(){return t.termAdd(id),!1})),rc.find('input[name="termexclude"]').attr("id","rc_termexclude_"+id).click((function(){return t.termExclude(id),!1})),rc.find('input[name="termor"]').attr("id","rc_termor_"+id).click((function(){return t.termOr(id),!1})),rc.find('label[for="template"]').attr("for","rc_template_"+id),rc.find('input[name="template"]').attr("id","rc_template_"+id),rc.find('input[name="templateadd"]').attr("id","rc_templateadd_"+id).click((function(){return t.templateAdd(id),!1})),rc.find('input[name="templateexclude"]').attr("id","rc_templateexclude_"+id).click((function(){return t.templateExclude(id),!1})),rc.find('label[for="precedesadd"]').attr("for","rc_precedes1_"+id),rc.find('select[name="precedes1"]').attr("id","rc_precedes1_"+id),rc.find('select[name="precedes2"]').attr("id","rc_precedes2_"+id),rc.find('input[name="precedesadd"]').attr("id","rc_precedesadd_"+id).click((function(){return t.precedesAdd(id),!1})),rc.find('label[for="cprecedesadd"]').attr("for","rc_cprecedes1_"+id),rc.find('select[name="cprecedes1"]').attr("id","rc_cprecedes1_"+id),rc.find('select[name="cprecedes2"]').attr("id","rc_cprecedes2_"+id),rc.find('input[name="cprecedesadd"]').attr("id","rc_cprecedesadd_"+id).click((function(){return t.cprecedesAdd(id),!1})),rc.find("div.rc-result").attr("id","rc_result_"+id),rc.find('input[name="add"]').attr("id","rc_add_"+id).click((function(){return t.addToAnswer(id),!1})),rc.find('input[name="clear"]').attr("id","rc_clear_"+id).click((function(){return t.clear(id),!1}))})),$(".rule-creator-btn").click((function(e){const wrapper=$(e.target).closest(".fitem.rcw"),icon=$(e.target).closest(".rule-creator-btn").find("img.icon");let src=icon.attr("src");return wrapper.find(".rule-creator").slideToggle(),void 0===src||(src=src.indexOf("collapsed")>0?src.slice(0,-9)+"expanded":src.slice(0,-8)+"collapsed",icon.attr("src",src)),!1}))},termAdd:function(id){const term=this.getTerm(id,"term");if(!term)return void $("#rc_term_"+id).focus();const termid=this.addToStore(id,term,"and","term");this.addToPrecedes(id,termid,term),this.displayResult(id),$("#rc_term_"+id).val("")},termExclude:function(id){const term=this.getTerm(id,"term");term?(this.addToStore(id,term,"not","term"),this.disablePrecedes(id,!0),this.displayResult(id),$("#rc_term_"+id).val("")):$("#rc_term_"+id).focus()},termOr:function(id){const term=this.getTerm(id,"term");if(!term)return void $("#rc_term_"+id).focus();const termid=this.addToStore(id,term,"or","term");this.addToPrecedes(id,termid,term),this.displayResult(id),$("#rc_term_"+id).val("")},templateAdd:function(id){const term=this.getTerm(id,"template");if(!term)return void $("#rc_template_"+id).focus();const termid=this.addToStore(id,term,"and","template");this.addToPrecedes(id,termid,term),this.displayResult(id),$("#rc_template_"+id).val("")},templateExclude:function(id){const term=this.getTerm(id,"template");term?(this.addToStore(id,term,"not","template"),this.disablePrecedes(id,!0),this.displayResult(id),$("#rc_template_"+id).val("")):$("#rc_template_"+id).focus()},precedesAdd:function(id){const terms=this.getPrecedesChoices(id,"precedes");terms&&(this.addToStore(id,terms,"and","precedes"),this.removeFromPrecedes(id,terms),this.displayResult(id))},cprecedesAdd:function(id){const terms=this.getPrecedesChoices(id,"cprecedes");terms&&(this.addToStore(id,terms,"and","cprecedes"),this.removeFromPrecedes(id,terms),this.displayResult(id))},addToAnswer:function(id){const result=$("#rc_result_"+id).text();null!==result&&""!==result&&($("#id_answer_"+id).val(result),this.clear(),$("#rc_btn_"+id).click(),$("#id_fraction_"+id).val("1.0").change(),$("#id_answer_"+id).focus())},clear:function(id){const ref="id_"+id;this.store[ref]=[],$("#rc_term_"+id).val(""),$("#rc_template_"+id).val(""),$("#rc_result_"+id).text(""),this.resetPrecedes(id)},getTerm:function(id,type){if(this.getStoreLength(id)>4)return $("#rc_notice_"+id).text(M.util.get_string("rulecreationtoomanyterms","qtype_pmatch")),!1;let term=$("#rc_"+type+"_"+id).val();return null!=term&&""!==term&&(term=term.trim(),""!==term&&(!(term.indexOf(" ")>-1)&&(term.indexOf("_")>-1&&(term=term.replace(/_/g,"\\_")),"term"===type||"*"===term.slice(-1)?term:term+"*")))},getPrecedesChoices:function(id,type){const term1=$("#rc_"+type+"1_"+id).val();if("0"===term1)return $("#rc_"+type+"1_"+id).focus(),!1;const term2=$("#rc_"+type+"2_"+id).val();return"0"===term2||term1===term2?($("#rc_"+type+"2_"+id).focus(),!1):[term1,term2]},addToPrecedes:function(id,termid,term){$("#rc_precedes1_"+id).append($("<option>",{value:termid}).text(term)),$("#rc_precedes2_"+id).append($("<option>",{value:termid}).text(term)),$("#rc_cprecedes1_"+id).append($("<option>",{value:termid}).text(term)),$("#rc_cprecedes2_"+id).append($("<option>",{value:termid}).text(term))},disablePrecedes:function(id,type){$("#rc_precedes1_"+id).prop("disabled",type),$("#rc_precedes2_"+id).prop("disabled",type),$("#rc_cprecedes1_"+id).prop("disabled",type),$("#rc_cprecedes2_"+id).prop("disabled",type)},resetPrecedes:function(id){this.disablePrecedes(id,!1),$("#rc_precedes1_"+id).find('option[value!="0"]').remove(),$("#rc_precedes2_"+id).find('option[value!="0"]').remove(),$("#rc_cprecedes1_"+id).find('option[value!="0"]').remove(),$("#rc_cprecedes2_"+id).find('option[value!="0"]').remove()},removeFromPrecedes:function(id,terms){for(let i=0;i<2;i++)$("#rc_precedes1_"+id+' option[value="'+terms[i]+'"]').remove(),$("#rc_precedes2_"+id+' option[value="'+terms[i]+'"]').remove(),$("#rc_cprecedes1_"+id+' option[value="'+terms[i]+'"]').remove(),$("#rc_cprecedes2_"+id+' option[value="'+terms[i]+'"]').remove()},addToStore:function(id,term,op,type){const ref="id_"+id,termid=this.store[ref].length+1;return this.store[ref].push({termid:termid,term:term,op:op,type:type}),termid},getStoreLength:function(id){const ref="id_"+id;return this.store[ref].length},getStoredResult:function(id){const ref="id_"+id;let rule="",temp=[];const mystore=this.store[ref].slice(0);let num=mystore.length,first=0,second=0,orpos=[],orcount=0;if(0===num)return rule;for(let i=0;i<num;i++){let currentterm="";"term"===mystore[i].type&&("and"===mystore[i].op&&(currentterm="match_w("+mystore[i].term+")"),"or"===mystore[i].op&&(currentterm="match_w("+mystore[i].term+")",i>0&&orpos.push(i)),"not"===mystore[i].op&&(currentterm="not(match_w("+mystore[i].term+"))")),"template"===mystore[i].type&&("and"===mystore[i].op&&(currentterm="match_wm("+mystore[i].term+")"),"not"===mystore[i].op&&(currentterm="match_wm("+mystore[i].term+")")),"precedes"===mystore[i].type&&(first=mystore[i].term[0]-1,second=mystore[i].term[1]-1,currentterm=" match_w("+mystore[first].term+" "+mystore[second].term+")"),"cprecedes"===mystore[i].type&&(first=mystore[i].term[0]-1,second=mystore[i].term[1]-1,currentterm=" match_w("+mystore[first].term+"_"+mystore[second].term+")"),temp.push(currentterm)}if(num=temp.length,0===num)return"";if(1===num)return temp[0];if(orcount=orpos.length,0===orcount){rule="match_all(\n  "+temp[0];for(let i=1;i<num;i++)rule=rule+" "+temp[i];return rule+="\n)",rule}if(num===orcount+1){rule="match_any(\n  "+temp[0];for(let i=1;i<num;i++)rule=rule+" "+temp[i];return rule+="\n)",rule}if(1===orcount)if(1===orpos[0])if(2===num)rule="match_any(\n  "+temp[0]+" "+temp[1]+"\n)";else{rule="match_all(\n  match_any(\n    "+temp[0]+" "+temp[1]+"\n  )\n ";for(let i=2;i<num;i++)rule=rule+" "+temp[i];rule+="\n)"}else{rule="match_all(\n    "+temp[0];for(let i=1;i<orpos[0];i++)rule=rule+" "+temp[i];if(rule="match_any(\n  "+rule+"\n  )\n  "+temp[orpos[0]]+"\n)",num>orpos[0]+1){rule="match_all(\n"+rule+"\n";for(let i=orpos[0]+1;i<num;i++)rule=rule+" "+temp[i];rule+="\n)"}}else{if(2!==orcount)return $("#rc_notice_"+id).text(M.util.get_string("rulecreationtoomanyors","qtype_pmatch")),"";if(1===orpos[0])if(rule="match_any(\n  "+temp[0]+" "+temp[1],2===orpos[1]){rule="match_all(\n"+rule+" "+temp[2]+"\n)\n";for(let i=3;i<num;i++)rule=rule+" "+temp[i];rule+="\n)"}else{rule="match_all(\n"+rule+"\n)\n";for(let i=2;i<orpos[1];i++)rule=rule+" "+temp[i];if(rule="match_any(\n"+rule+"\n)\n "+temp[orpos[1]],num>orpos[1]+1){rule="\nmatch_all(\n"+rule;for(let i=orpos[1]+1;i<num;i++)rule=rule+" "+temp[i];rule+="\n)"}rule+="\n)"}else{rule="match_all(\n"+temp[0];for(let i=1;i<orpos[0];i++)rule=rule+" "+temp[i];if(rule="match_any(\n"+rule+"\n)\n  "+temp[orpos[0]],orpos[1]===orpos[0]+1){if(rule=rule+" "+temp[orpos[1]]+"\n)\n",num>orpos[1]+1){rule="match_all(\n"+rule;for(let i=orpos[1]+1;i<num;i++)rule=rule+" "+temp[i];rule+="\n)"}}else{rule="match_all(\n"+rule+"\n)\n";for(let i=orpos[0]+1;i<orpos[1];i++)rule=rule+" "+temp[i];if(rule="match_any(\n"+rule+"\n)\n"+temp[orpos[1]]+"\n)\n",num>orpos[1]+1){rule="match_all(\n"+rule;for(let i=orpos[1]+1;i<num;i++)rule=rule+" "+temp[i];rule+="\n)\n"}}}}return rule.trim()},displayResult:function(id){const result=this.getStoredResult(id);$("#rc_result_"+id).text(result)}};return t}));

//# sourceMappingURL=rulecreator.min.js.map