<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * OU pmatch question type language strings.
 *
 * @package   qtype_pmatch
 * @copyright  2011 The Open University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['add'] = 'Add';
$string['addmoreanswerblanks'] = 'Blanks for {no} More Answers';
$string['addmoresynonymblanks'] = 'Blanks for {no} more synonyms';
$string['addtoanswer'] = 'Add to answer';
$string['allowsubscript'] = 'Allow use of subscript';
$string['allowsuperscript'] = 'Allow use of superscript';
$string['amatiwsurl'] = 'Amati webservice URL';
$string['amatiwsurl_desc'] = 'URL for the Amati webservice';
$string['answer'] = 'Answer: {$a}';
$string['answeringoptions'] = 'Options For Entering Answers';
$string['answermustbegiven'] = 'You must enter an answer if there is a grade or feedback.';
$string['answermustmatch'] = 'Answer must match';
$string['answerno'] = 'Answer {$a} must match';
$string['answeroptions'] = 'Answer options';
$string['anyotheranswer'] = 'Any other answer';
$string['apply_spellchecker_label'] = 'Do not check spelling of student';
$string['apply_spellchecker_missing_language_attempt'] = 'This question is set to use {$a} spell-check, but that language is not available on this server.';
$string['apply_spellchecker_missing_language_select'] = '{$a} (Warning! Dictionary not installed on this server)';
$string['apply_spellchecker_select'] = '{$a->name} ({$a->code})';
$string['applydictionarycheck'] = 'Spell checking';
$string['caseno'] = 'No, case is unimportant';
$string['casesensitive'] = 'Case sensitivity';
$string['caseyes'] = 'Yes, case must match';
$string['choosetoken'] = 'Choose token';
$string['combinedcontrolnamepmatch'] = 'text input';
$string['converttospace'] = 'Convert to space';
$string['converttospace_help'] = 'Specify characters that you want the system to convert to spaces before running the pattern-matching process. This is great for simplifying the input if punctuation does not matter.';
$string['correctanswers'] = 'Answer matching';
$string['correctanswers_help'] = 'The most basic form of pattern match is to type <code>match (word)</code>, where ‘word’ is what you want to match.

If you have alternative words, you can either use the Synonyms above, or use a pipe (<code>|</code>) to signify ‘or’. E.g. <code>match (word|words)</code>. For more complicated cases, you might use:

<pre>
match_any (
    match (word)
    match (words)
    match (wordage)
    match (wordiness)
)
</pre>
In the above example, because the responses all start the same, you could also simply use asterisk (<code>*</code>) to allow multiple character wildcards: <code>match (word*)</code>. A question mark (<code>?</code>) is used for single character wildcards.

If you have a short phrase you want to match, you should enclose it in square brackets (<code>[...]</code>). E.g. <code>match ([numerous words make a short sentence])</code>. You can combine pipe and square bracketed sentences if desired.';
$string['correctanswers_link'] = 'Pattern-match_question_type_detailed_documentation#Pattern_match_syntax';
$string['duplicateresponse'] = '{$a}: Duplicate';
$string['env_dictmissing'] = 'Missing spell check dictionary {$a->langforspellchecker} for installed language {$a->humanfriendlylang} is installed.';
$string['env_dictmissing2'] = 'Student attempted a spell check in language \'{$a}\'. But aspell dictionary for this language is not installed.';
$string['env_dictok'] = 'Spell check dictionary {$a->langforspellchecker} for installed language {$a->humanfriendlylang} is installed.';
$string['env_peclnormalisationmissing'] = 'PECL Package for Unicode Normalizer appears not to be correctly installed';
$string['env_peclnormalisationok'] = 'PECL Package for Unicode Normalizer appears to be correctly installed';
$string['env_pspellmissing'] = 'Pspell library appears not to be correctly installed';
$string['env_pspellok'] = 'Pspell library appears to be correctly installed';
$string['environmentcheck'] = 'Environment checks for the pmatch question type';
$string['err_ousupsubnotsupportedonmobile'] = 'This question requires superscripts or subscripts and so does not yet work in this app. Please answer this question in the web browser.';
$string['err_providepmatchexpression'] = 'You must provide a pmatch expression here.';
$string['error:blank'] = 'The response cannot be blank';
$string['error:title'] = 'Error';
$string['errorfilecell'] = 'The file requires at least two rows (the first row is the header row, the second row onwards for responses).';
$string['errorfilecolumnbigger'] = 'The file has more than two columns. Please only include the expected mark and response.';
$string['errorfilecolumnless'] = 'The file requires at least two columns (the first column for expected marks, the second column for responses).';
$string['errorfileformat'] = 'The file must be in .csv/.xlsx/.html/.json/.ods format.';
$string['errors'] = 'Please fix the following problems : {$a}';
$string['exclude'] = 'Exclude';
$string['extenddictionary'] = 'Add these words to dictionary';
$string['filloutoneanswer'] = 'Use the pattern match syntax to describe possible answers. The student\'s response will be compared to these in order, and the first matching pattern will determine the score and the feedback. You must give at least one pattern.';
$string['forcelength'] = 'If answer is more than 20 words';
$string['forcelengthno'] = 'do not issue warning';
$string['forcelengthyes'] = 'warn that answer is too long and invite respondee to shorten it';
$string['ie_illegaloptions'] = 'Illegal options in expression "match<strong><em>{$a}</em></strong>()".';
$string['ie_lastsubcontenttypeorcharacter'] = 'Or character must not end subcontent in "{$a}".';
$string['ie_lastsubcontenttypeworddelimiter'] = 'Word delimiter character must not end sub content "{$a}".';
$string['ie_missingclosingbracket'] = 'Missing closing bracket in code fragment "{$a}".';
$string['ie_nofullstop'] = 'Full stop characters are not allowed in pmatch expressions. (Decimal points in the middle of numbers are OK.)';
$string['ie_nomatchfound'] = 'Error in pattern match code.';
$string['ie_unrecognisedexpression'] = 'Unrecognised expression.';
$string['ie_unrecognisedsubcontents'] = 'Unrecognised sub-content in code fragment "{$a}".';
$string['inputareatoobig'] = 'The input area defined by "{$a}" is too big. Input area size is limited to a width of 150 characters and a height of 100 characters.';
$string['minresponses'] = 'Minimum number of responses';
$string['minresponses_desc'] = 'Minimum number of marked responses that should be uploaded in order for the Amati system to generate rules.';
$string['modelanswer'] = 'Model answer';
$string['modelanswer_appropriateinputsize'] = 'Appropriate input size:';
$string['modelanswer_help'] = 'Give one possible answer to this question that would be graded correct.';
$string['modelanswer_possibleanswerplaceholders'] = 'Possible answer placeholders';
$string['modelanswererror'] = '\'<strong>{$a}</strong>\' is not a correct answer to this question.';
$string['modelanswermissing'] = 'You must provide a possible response to this question, which would be graded 100% correct.';
$string['nolanguagesfound'] = '<i>No languages found</i>';
$string['nomatchingsynonymforword'] = 'No synonyms entered for word. Delete the word or enter synonym(s) for it.';
$string['nomatchingwordforsynonym'] = 'You have not entered a word that the synonym is equivalent too. Delete the synonym(s) or enter an equivalent word for it.';
$string['notenoughanswers'] = 'This type of question requires at least {$a} answers';
$string['or'] = 'Or';
$string['overallgradingaccuracy'] = 'Overall grading accuracy';
$string['pleaseenterananswer'] = 'Please enter an answer.';
$string['pluginname'] = 'Pattern match';
$string['pluginname_help'] = 'In response to a question (that may include a image) the respondent types a short phrase. There may be several possible correct answers, each with a different grade. If the "Case sensitive" option is selected, then you can have different scores for "Word" or "word".';
$string['pluginname_link'] = 'question/type/pmatch';
$string['pluginnameadding'] = 'Adding a Pattern match question';
$string['pluginnameediting'] = 'Editing a Pattern match question';
$string['pluginnamesummary'] = 'Allows a short response of one or a few sentences that is graded by comparing against various model answers, which are described using the OU\'s pattern match syntax.';
$string['precedes'] = 'Precedes';
$string['precedesclosely'] = 'Closely precedes';
$string['prefillanswertext'] = 'Pre-filled answer text';
$string['prefillanswertext_help'] = 'Use this box to add in any text you want to appear in the answer text for the student to complete, adapt, or correct. You can include (and are limited to) `<sub>` and `<sup>` hypertext mark-up language (HTML) tags.

If you are using this setting, you may wish to disable spell-checking.';
$string['privacy:metadata'] = 'Pattern match question type plugin allows question authors to set default options as user preferences.';
$string['privacy:preference:allowsubscript'] = 'Whether subscript is used to input answer.';
$string['privacy:preference:allowsuperscript'] = 'Whether superscript is used to input answer.';
$string['privacy:preference:applydictionarycheck'] = 'Whether students answer should be spell checked';
$string['privacy:preference:converttospace'] = 'Which characters are specified to be converted to spaces.';
$string['privacy:preference:defaultmark'] = 'The default mark set for a given question.';
$string['privacy:preference:forcelength'] = 'Whether a warning should be displayed when the answer is more than 20 words.';
$string['privacy:preference:penalty'] = 'The penalty for each incorrect try when questions are run using the \'Interactive with multiple tries\' or \'Adaptive mode\' behaviour.';
$string['privacy:preference:quotematching'] = 'Whether smart and straight quotes are matched strictly or relaxed.';
$string['privacy:preference:sentencedividers'] = 'Which characters are specified to be treatrd as sentence end points.';
$string['privacy:preference:testquestion_pagesize'] = 'Number of pattern match question attempts to show per page.';
$string['privacy:preference:usecase'] = 'Whether case is unimportant or must match in student\'s answer.';
$string['processingxofy'] = 'Processing response {$a->row} of {$a->total}: {$a->response}.';
$string['repeatedword'] = 'This word appears more than once in synonym list.';
$string['resetrule'] = 'Reset rule';
$string['row'] = 'Row';
$string['rule'] = 'Rule';
$string['ruleaccuracy'] = 'Responses not matched above: {$a->responseneedmatch} <br> Correctly matched by this rule: {$a->correctlymatched}, <span class="{$a->class}">Incorrectly matched: {$a->incorrectlymatched}</span> <br> Responses still to be processed below: {$a->responsestillprocess}';
$string['ruleaccuracylabel'] = 'Effect on sample responses';
$string['rulecreationasst'] = 'Show/hide rule creation assistant';
$string['rulecreationtoomanyors'] = 'Sorry too many or\'s.';
$string['rulecreationtoomanyterms'] = 'Sorry too many terms.';
$string['rulesuggestionbutton'] = 'Auto generate matching rules';
$string['rulesuggestiondescriptionnoresponses'] = 'Automatically generate matching rules by uploading a set of existing marked responses';
$string['rulesuggestionlabel'] = 'Rule suggestion';
$string['savedxresponses'] = 'Saved {$a} responses';
$string['sentencedividers'] = 'Sentence end points';
$string['sentencedividers_help'] = 'Specify characters for the system to treat as sentence end points. By default, ‘?’ is a sentence end point, so if you wanted to match “Hello?”, you would remove ‘?’ from this field and use “match (hello\?)”. Note that ‘?’ needs escaping ( \\ ) in the match expression because it is a special character, but ‘.’ and ‘!’ do not.';
$string['sentencedividers_noconvert'] = '\'<strong>{$a}</strong>\' is used as a <strong>sentence end point</strong> and cannot be converted to space.';
$string['setting_installed_spell_check_dictionaries'] = 'Spell check dictionaries';
$string['setting_installed_spell_check_dictionaries_des'] = 'This setting controls which spell-check language options are displayed to question authors when they create or edit a question.';
$string['showcoverage'] = 'Show coverage';
$string['showingresponsesforquestion'] = 'Showing the responses for the selected question: {$a}';
$string['smart_straight_quote_matching'] = 'Quote/apostrophe matching';
$string['smart_straight_quote_matching_help'] = 'If the "Relaxed" option is enabled, then any curly (also known as "smart") quotes and apostrophes in the question authoring fields will be converted to the straight equivalent on save.';
$string['smart_straight_quote_matching_relaxed'] = 'Relaxed: all forms of quotes and apostrophes are interchangeable (default).';
$string['smart_straight_quote_matching_strict'] = 'Strict: all forms of quotes and apostrophes are unique.';
$string['spellcheckdisabled'] = 'Allowing use of sub- or superscript will disable spellchecking.';
$string['spellcheckerenchant'] = 'Enchant spell-checking library';
$string['spellcheckernull'] = 'No spell checking available';
$string['spellcheckerpspell'] = 'Pspell spell-checking library';
$string['spellcheckertype'] = 'Spell checking library';
$string['spellcheckertype_desc'] = 'Which spell checking library to use. This should automatically be set to the correct value on install.';
$string['spellingmistakes'] = 'The following words are not in our dictionary: {$a}. Please correct your spelling.';
$string['subsuponelineonly'] = 'The sub / super script editor can only be used with an input box one line high.';
$string['synonym'] = 'Synonyms';
$string['synonymcontainsillegalcharacters'] = 'Synonym contains illegal characters.';
$string['synonymsheader'] = 'Define Synonyms For Words in Answers';
$string['synonymsno'] = 'Synonyms {$a}';
$string['template'] = 'Template';
$string['term'] = 'Term';
$string['test'] = 'Test';
$string['testquestionactualmark'] = 'Computed mark';
$string['testquestionbacklink'] = 'Back to Test question';
$string['testquestionchangescore'] = 'Change score';
$string['testquestioncorrect'] = 'Correct';
$string['testquestiondeletedresponses'] = 'The responses were successfully deleted.';
$string['testquestioneditresponse'] = 'Edit response';
$string['testquestionexpectedfraction'] = 'Human mark';
$string['testquestionformcancelresponsebutton'] = 'Cancel';
$string['testquestionformdeletecheck'] = 'Are you absolutely sure you want to completely delete these responses?';
$string['testquestionformdeletesubmit'] = 'Delete';
$string['testquestionformduplicateresponse'] = 'Duplicate responses are not allowed.';
$string['testquestionformerror_incorrectquestionid'] = 'Incorrect question id, or not a pattern match question.';
$string['testquestionformheader'] = 'Marked responses to upload';
$string['testquestionforminfo'] = 'You should upload a spreadsheet file (.csv or .xlsx) with two columns. The first column contains the expected mark for that response, and the second column should contain that response. The first row in the file is assumed to contain column headings, and is ignored.';
$string['testquestionformnewresponsebutton'] = 'Add new response';
$string['testquestionformsaveresponsebutton'] = 'Save';
$string['testquestionformtestsubmit'] = 'Test selected responses';
$string['testquestionformtitle'] = 'Pattern-match question testing tool';
$string['testquestionformuploadlabel'] = 'Marked responses';
$string['testquestionheader'] = 'Testing question: {$a}';
$string['testquestionidlabel'] = '#';
$string['testquestionincorrectlymarkedrights'] = 'missed negatives';
$string['testquestionincorrectlymarkedwrong'] = 'missed positives';
$string['testquestionmatches'] = 'matches';
$string['testquestionresponse'] = 'Response';
$string['testquestionresponsesthatare'] = 'Show responses that are';
$string['testquestionresultsheader'] = 'Test results: {$a}';
$string['testquestionresultssummary'] = 'Sample responses: {$a->total} <br>
     Marked correctly: {$a->correct} ({$a->accuracy}%)<br>
     <span>Computed mark greater than human mark: {$a->misspositive} (missed positive)</span><br>
     <span>Computed mark less than human mark: {$a->missnegative} (missed negative)</span>';
$string['testquestionruleslabel'] = 'Rules';
$string['testquestionseletresponsex'] = 'Select response {$a}';
$string['testquestiontool'] = 'Pattern-match testing tool';
$string['testquestionungraded'] = 'ungraded';
$string['testquestionuploadanother'] = 'Upload another file';
$string['testquestionuploadincorrectmark'] = '{$a->response}: The expected mark was {$a->expectedmark}. Only 0 or 1 are allowed.';
$string['testquestionuploadresponses'] = 'Upload responses';
$string['testquestionuploadrowhastwoitems'] = 'Each row should contain exactly two items, a numerical mark and a response. Row <b>{$a->row}</b> contains <b>{$a->items}</b> item(s).';
$string['testquestionuploadrownotvalidutf8'] = 'The response in row <b>{$a}</b> contains unrecognised special characters. The input must be valid UTF-8.';
$string['testquestionuploadtheseresponses'] = 'Upload these responses';
$string['testsubquestionx'] = 'Test sub question {$a}';
$string['testthisquestion'] = 'Test this question';
$string['testthisquestionnoresmoreponsesrequired'] = 'More responses are required for auto-suggestion to work. There are {$a->existing} responses and you need {$a->required}';
$string['testthisquestionnoresponsesfound'] = 'No responses were found.';
$string['testthisquestionnorulesreturned'] = 'No rules were suggested.';
$string['toomanywords'] = 'Your answer is too long. Please edit it to be no longer than 20 words.';
$string['tryrule'] = 'Try rule';
$string['tryrulecoverage'] = 'Coverage';
$string['tryrulegradeerror'] = 'Sorry, try rule only works if the grade is set to 100% or None.';
$string['tryrulenogradedresponses'] = 'There are no graded responses, please grade your response set.';
$string['tryrulenomatch'] = 'This rule does not match any graded responses.';
$string['tryrulenovalidrule'] = 'This rule is not a valid pmatch expression.';
$string['unknownlanguagex'] = 'Unknown language ({$a})';
$string['unparseable'] = 'We do not understand the characters or punctuation here "{$a}"';
$string['wordcontainsillegalcharacters'] = 'Word contains illegal characters.';
$string['wordwithsynonym'] = 'Word';
$string['xresponsesduplicated'] = 'The following {$a} responses were duplicated';
$string['xresponsesproblems'] = 'The following {$a} responses were not saved';
$string['xrulesuggested'] = '{$a} new answer(s) were suggested and added to the end of the existing answers';
