<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Question type class for the short answer question type.
 *
 * @package    qtype_varnumeric
 * @copyright  2011 The Open University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */


defined('MOODLE_INTERNAL') || die();

require_once($CFG->libdir . '/questionlib.php');
require_once($CFG->dirroot . '/question/engine/lib.php');
require_once($CFG->dirroot . '/question/type/varnumeric/calculator.php');
require_once($CFG->dirroot . '/question/type/varnumericset/questiontypebase.php');

/**
 * The variable numeric set question type.
 *
 * @copyright  2011 The Open University
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
class qtype_varnumeric extends qtype_varnumeric_base {

    #[\Override]
    public function recalculate_every_time() {
        return true;
    }

    #[\Override]
    public function db_table_prefix() {
        return 'qtype_varnumeric';
    }

    #[\Override]
    public function save_question_options($form) {
        $form->noofvariants = 1;
        return parent::save_question_options($form);
    }

    #[\Override]
    public function break_down_stats_and_response_analysis_by_variant($questiondata) {
        return false;
    }
}
