define("tiny_embedquestion/dialogue_manager",["exports","core/templates","core/str","core/modal","core/modal_factory","core/pending","core/loadingicon","./options","core/ajax","core/notification","core/fragment"],(function(_exports,_templates,_str,_modal,_modal_factory,_pending,_loadingicon,_options,_ajax,_notification,_fragment){function _interopRequireDefault(obj){return obj&&obj.__esModule?obj:{default:obj}}function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}
/**
   * Manages the embed question dialog.
   *
   * @module    tiny_embedquestion/dialogue_manager
   * @copyright 2024 The Open University
   * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
   */Object.defineProperty(_exports,"__esModule",{value:!0}),_exports.DialogManager=void 0,_templates=_interopRequireDefault(_templates),_modal=_interopRequireDefault(_modal),_modal_factory=_interopRequireDefault(_modal_factory),_pending=_interopRequireDefault(_pending),_notification=_interopRequireDefault(_notification),_fragment=_interopRequireDefault(_fragment);_exports.DialogManager=class{constructor(_editor){_defineProperty(this,"editor",null),_defineProperty(this,"currentModal",null),_defineProperty(this,"displayDialogue",(async()=>{void 0!==_modal.default.create?this.currentModal=await _modal.default.create({large:!0,title:(0,_str.get_string)("pluginname","tiny_embedquestion"),body:'<div class="tiny_embedquestion-wrap"></div>',show:!0,removeOnClose:!0}):(this.currentModal=await _modal_factory.default.create({title:(0,_str.get_string)("pluginname","tiny_embedquestion"),body:'<div class="tiny_embedquestion-wrap"></div>',large:!0,removeOnClose:!0}),this.currentModal.show());const pendingModalReady=new _pending.default("tiny_embedquestion/displayDialogue"),body=this.currentModal.getBody()[0];(0,_loadingicon.addIconToContainerRemoveOnCompletion)(body,pendingModalReady);let existingCode=this.getEmbedCodeFromTextSelection(this.editor);existingCode&&(existingCode=existingCode.embedCode);const dialogManager=this;_fragment.default.loadFragment("tiny_embedquestion","questionselector",(0,_options.getRelevantContextId)(this.editor),{contextId:(0,_options.getRelevantContextId)(this.editor),embedCode:existingCode}).then((function(html,js){return _templates.default.replaceNodeContents(body,html,js),body.querySelector("#embedqform #id_submitbutton").addEventListener("click",dialogManager.getEmbedCode),pendingModalReady.resolve(),dialogManager.currentModal})).catch(_notification.default.exception)})),_defineProperty(this,"getEmbedCode",(e=>{e.preventDefault();const iframeDescription=document.getElementById("id_iframedescription").value,questionIdnumber=document.getElementById("id_questionidnumber").value,dialogManager=this;questionIdnumber&&(iframeDescription.length&&(iframeDescription.length<3||iframeDescription.length>100)||dialogManager.getEmbedCodeCall(iframeDescription,questionIdnumber).then((function(embedCode){return dialogManager.insertEmbedCode(embedCode),dialogManager})).catch(_notification.default.exception))})),_defineProperty(this,"getEmbedCodeCall",((iframeDescription,questionIdnumber)=>{var _document$getElementB,_document$getElementB2,_document$getElementB3,_document$getElementB4,_document$getElementB5,_document$getElementB6,_document$getElementB7,_document$getElementB8,_document$getElementB9,_document$getElementB10,_document$getElementB11;return(0,_ajax.call)([{methodname:"filter_embedquestion_get_embed_code",args:{courseid:document.querySelector("input[name=courseid]").value,categoryidnumber:document.getElementById("id_categoryidnumber").value,questionidnumber:questionIdnumber,iframedescription:iframeDescription,behaviour:(null===(_document$getElementB=document.getElementById("id_behaviour"))||void 0===_document$getElementB?void 0:_document$getElementB.value)||"",maxmark:(null===(_document$getElementB2=document.getElementById("id_maxmark"))||void 0===_document$getElementB2?void 0:_document$getElementB2.value)||"",variant:(null===(_document$getElementB3=document.getElementById("id_variant"))||void 0===_document$getElementB3?void 0:_document$getElementB3.value)||"",correctness:(null===(_document$getElementB4=document.getElementById("id_correctness"))||void 0===_document$getElementB4?void 0:_document$getElementB4.value)||"",marks:(null===(_document$getElementB5=document.getElementById("id_marks"))||void 0===_document$getElementB5?void 0:_document$getElementB5.value)||"",markdp:(null===(_document$getElementB6=document.getElementById("id_markdp"))||void 0===_document$getElementB6?void 0:_document$getElementB6.value)||"",feedback:(null===(_document$getElementB7=document.getElementById("id_feedback"))||void 0===_document$getElementB7?void 0:_document$getElementB7.value)||"",generalfeedback:(null===(_document$getElementB8=document.getElementById("id_generalfeedback"))||void 0===_document$getElementB8?void 0:_document$getElementB8.value)||"",rightanswer:(null===(_document$getElementB9=document.getElementById("id_rightanswer"))||void 0===_document$getElementB9?void 0:_document$getElementB9.value)||"",history:(null===(_document$getElementB10=document.getElementById("id_history"))||void 0===_document$getElementB10?void 0:_document$getElementB10.value)||"",forcedlanguage:(null===(_document$getElementB11=document.getElementById("id_forcedlanguage"))||void 0===_document$getElementB11?void 0:_document$getElementB11.value)||""}}])[0]})),_defineProperty(this,"insertEmbedCode",(embedCode=>{const existingCode=this.getEmbedCodeFromTextSelection(this.editor);if(existingCode){const parent=this.editor.selection.getNode(),text=parent.textContent;parent.textContent=text.slice(0,existingCode.start)+embedCode+text.slice(existingCode.end)}else this.editor.insertContent(embedCode);this.currentModal.destroy()})),_defineProperty(this,"getEmbedCodeFromTextSelection",(editor=>{const selection=editor.selection.getSel(),selectedNode=editor.selection.getNode();let text,patternMatches,returnValue=!1;if(!selection)return!1;if(!(selection.rangeCount?selection.getRangeAt(0):null))return!1;if(text=selectedNode.textContent,patternMatches=text.match(/\{Q\{(?:(?!\}Q\}).)*\}Q\}/g),!patternMatches||!patternMatches.length)return!1;for(let i=0;i<patternMatches.length;++i){let startIndex=0;for(;-1!==text.indexOf(patternMatches[i],startIndex);){const start=text.indexOf(patternMatches[i],startIndex),end=start+patternMatches[i].length,startMatches=selection.anchorOffset>=start&&selection.anchorOffset<end,endMatches=selection.focusOffset<=end&&selection.focusOffset>start,reserveStartMatches=selection.anchorOffset<=end&&selection.anchorOffset>start,reserveEndMatches=selection.focusOffset>=start&&selection.focusOffset<end;if(startMatches&&endMatches||reserveStartMatches&&reserveEndMatches){returnValue={start:start,end:end,embedCode:patternMatches[i]};break}startIndex=end}}return returnValue})),this.editor=_editor}}}));

//# sourceMappingURL=dialogue_manager.min.js.map