<?php
// This file is part of MuTMS suite of plugins for Moodle™ LMS.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <https://www.gnu.org/licenses/>.

// phpcs:disable moodle.Files.BoilerplateComment.CommentEndedTooSoon

/**
 * Delete chapter.
 *
 * @package    mod_mubook
 * @copyright  2025 Petr Skoda
 * @license    https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use mod_mubook\local\chapter;

/** @var moodle_database $DB */
/** @var moodle_page $PAGE */

define('AJAX_SCRIPT', true);

require('../../../config.php');

$chapterid = required_param('id', PARAM_INT);

$chapterrecord = $DB->get_record('mubook_chapter', ['id' => $chapterid], '*', MUST_EXIST);
$mubook = $DB->get_record('mubook', ['id' => $chapterrecord->mubookid], '*', MUST_EXIST);
$cm = get_coursemodule_from_instance('mubook', $mubook->id, $mubook->course, false, MUST_EXIST);
$course = $DB->get_record('course', ['id' => $cm->course], '*', MUST_EXIST);
$context = context_module::instance($cm->id);

require_login($course, true, $cm);
require_capability('mod/mubook:view', $context);
require_capability('mod/mubook:editchapter', $context);

$currenturl = new \core\url('/mod/mubook/management/chapter_delete.php', ['id' => $chapterrecord->id]);
$returnurl = new \core\url('/mod/mubook/viewchapter.php', ['id' => $chapterrecord->id]);

$PAGE->set_context($context);
$PAGE->set_url($currenturl);

// Check chapter permissions.
$chapter = new chapter($chapterrecord, $mubook, $context);
if (!$chapter->can_delete()) {
    redirect($returnurl);
}

$toc = new \mod_mubook\local\toc($mubook);

$form = new \mod_mubook\local\form\chapter_delete(null, ['chapter' => $chapter, 'toc' => $toc]);
if ($form->is_cancelled()) {
    $form->ajax_form_cancelled($returnurl);
} else if ($data = $form->get_data()) {
    chapter::delete($data->id, true);
    $toc = \mod_mubook\local\toc::fix_sortorders($mubook->id);

    if ($chapter->parentid) {
        $returnurl = new \core\url('/mod/mubook/viewchapter.php', ['id' => $chapter->parentid]);
    } else {
        $returnurl = new \core\url('/mod/mubook/view.php', ['id' => $cm->id]);
    }
    $form->ajax_form_submitted($returnurl);
}

$form->ajax_form_render();
