/**
 * This code is based on core/fragment, it fetches form html markup and javascript
 * from legacy form page.
 *
 * This code is based on modal_form by Mitxel Moriana.
 *
 * @module      tool_mulib/dialog_form
 * @copyright   2022 Open LMS (https://www.openlms.net/)
 * @copyright   2025 Petr Skoda
 * @author      Petr Skoda
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("tool_mulib/dialog_form",["jquery","core/modal_factory","core/modal_events","core/ajax","core/notification","core/yui","core/event","core/str","core/log","core_form/changechecker"],(function($,ModalFactory,ModalEvents,Ajax,Notification,Y,Event,Str,Log,Changechecker){var unloading=!1,DialogForm=function(config){this.config=config,this.config.modalConfig=this.config.modalConfig||{},this.config.modalConfig.type=ModalFactory.types.CANCEL,this.init()};DialogForm.prototype.config={},DialogForm.prototype.modal=null,DialogForm.prototype.init=function(){M.util.js_pending("tool_mulib_dialog_form_init"),Str.get_strings([{key:"collapseall",component:"moodle"},{key:"expandall",component:"moodle"}]).then(function(){return ModalFactory.create(this.config.modalConfig)}.bind(this)).then(function(modal){return this.modal=modal,this.modal.setBody(this.getFormHtml("")),"xl"===this.config.size?this.modal.getModal().addClass("modal-xl"):"lg"===this.config.size&&this.modal.getModal().addClass("modal-lg"),this.modal.getRoot().on(ModalEvents.hidden,function(){Event.notifyFormSubmitAjax(this.modal.getRoot().find("form")[0],!0),this.modal.destroy(),this.resetDirtyFormState(),null!==this.config.triggerElement&&this.config.triggerElement.focus()}.bind(this)),this.modal.getModal().addClass("tool_mulib-dialog_form"),this.modal.getRoot().on("click","form input[type=submit][data-no-submit]",this.noSubmitButtonPressed.bind(this)),this.modal.getRoot().on("click","form input[type=submit][data-cancel]",this.cancelButtonPressed.bind(this)),this.modal.getBody().on("click","form input[type=submit]",this.submitButtonPressed.bind(this)),this.modal.getRoot().on("submit","form",this.submitFormAjax.bind(this)),this.onInit(),this.modal.show(),M.util.js_complete("tool_mulib_dialog_form_init"),this.modal}.bind(this)).fail(Notification.exception)},DialogForm.prototype.onInit=function(){},DialogForm.prototype.getFormHtml=function(formData){var promise=$.Deferred();return M.util.js_pending("tool_mulib_dialog_form_html"),fetchFormHtml(this.config.formUrl,formData).then((function(response){return"render"===response.dialog_form?(promise.resolve(response.html,processCollectedJavascript(response.javascript)),M.util.js_complete("tool_mulib_dialog_form_html")):promise.reject(new Error("Dialog form rendering error")),null})).fail((function(ex){promise.reject(ex)})),promise.promise()},DialogForm.prototype.onSubmitSuccess=function(response){return response},DialogForm.prototype.onValidationError=function(){},DialogForm.prototype.resetDirtyFormState=function(){Changechecker.resetAllFormDirtyStates()},DialogForm.prototype.noSubmitButtonPressed=function(e){e.preventDefault(),Event.notifyFormSubmitAjax(this.modal.getRoot().find("form")[0],!0);var formData=this.modal.getRoot().find("form").serialize(),el=$(e.currentTarget);formData=formData+"&"+encodeURIComponent(el.attr("name"))+"="+encodeURIComponent(el.attr("value")),this.modal.setBody(this.getFormHtml(formData))},DialogForm.prototype.cancelButtonPressed=function(e){e.preventDefault(),this.disableButtons(),this.modal.hide()},DialogForm.prototype.submitButtonPressed=function(e){var btn=$(e.currentTarget);"1"!==btn.attr("data-no-submit")&&btn.attr("data-clicked-button","1")},DialogForm.prototype.validateElements=function(){Event.notifyFormSubmitAjax(this.modal.getRoot().find("form")[0]);var invalid=$.merge(this.modal.getRoot().find('[aria-invalid="true"]'),this.modal.getRoot().find(".error"));return!invalid.length||(invalid.first().focus(),!1)},DialogForm.prototype.disableButtons=function(){this.modal.getBody().find("form input[type=submit]").attr("disabled",!0)},DialogForm.prototype.enableButtons=function(){this.modal.getBody().find("form input[type=submit]").removeAttr("disabled")},DialogForm.prototype.submitFormAjax=function(e){e.preventDefault();var submit=this.modal.getBody().find("form input[type=submit][data-clicked-button]");if(void 0!==submit&&submit.removeAttr("data-clicked-button"),this.validateElements()){this.disableButtons();var formData=this.modal.getRoot().find("form").serialize();void 0!==submit&&(formData=formData+"&"+encodeURIComponent(submit.attr("name"))+"="+encodeURIComponent(submit.attr("value"))),M.util.js_pending("tool_mulib_dialog_form_submit"),fetchFormHtml(this.config.formUrl,formData).then(function(response){if("render"===response.dialog_form){var promise=$.Deferred();promise.resolve(response.html,processCollectedJavascript(response.javascript)),this.modal.setBody(promise.promise()),this.enableButtons(),this.onValidationError(),M.util.js_complete("tool_mulib_dialog_form_submit")}else"submitted"===response.dialog_form&&(this.modal.hide(),this.onSubmitSuccess(response),M.util.js_complete("tool_mulib_dialog_form_submit"),"reload"===this.config.afterSubmit?window.location.reload():"redirect"===this.config.afterSubmit&&(window.location=response.redirecturl));return null}.bind(this)).fail((function(exception){Notification.exception(exception)}))}},DialogForm.prototype.submitForm=function(e){e.preventDefault(),this.modal.getRoot().find("form").submit()};const processCollectedJavascript=function(js){var jsNodes=$(js),allScript="";return jsNodes.each((function(index,scriptNode){var tagName=(scriptNode=$(scriptNode)).prop("tagName");if(tagName&&"script"===tagName.toLowerCase())if(scriptNode.attr("src")){var exists=!1;$("script").each((function(index,s){return $(s).attr("src")===scriptNode.attr("src")&&(exists=!0),!exists})),exists||(allScript+=" { ",allScript+=' node = document.createElement("script"); ',allScript+=' node.type = "text/javascript"; ',allScript+=' node.src = decodeURI("'+encodeURI(scriptNode.attr("src"))+'"); ',allScript+=' document.getElementsByTagName("head")[0].appendChild(node); ',allScript+=" } ")}else allScript+=" "+scriptNode.text()})),allScript};var fetchFormHtml=function(formUrl,formData){$(window).bind("beforeunload",(function(){unloading=!0}));var promise=$.Deferred(),settings={type:"POST",dataType:"json",processData:!1,async:!0,headers:{"x-mulib-dialog-form-request":"1"},data:formData};return $.ajax(formUrl,settings).done((function(response){void 0===response?promise.reject(new Error("Unreadable server response")):void 0!==response.error?promise.reject(response):void 0!==response.data&&void 0!==response.data.dialog_form?promise.resolve(response.data):promise.reject(new Error("Invalid server response"))})).fail((function(jqXHR,textStatus,exception){unloading?(Log.error("Page unloaded."),Log.error(exception)):promise.reject(exception)})),promise};return DialogForm}));

//# sourceMappingURL=dialog_form.min.js.map