# Multi-tenancy plugin for Moodle™ LMS

![Moodle Plugin CI](https://github.com/mutms/moodle-tool_mutenancy/actions/workflows/moodle-ci.yml/badge.svg)

Multi-tenancy refers to the ability to create isolated entities, known as tenants, within a single instance of an LMS
(Learning Management System). Each tenant operates independently, managing its own users, roles, appearance, courses,
and settings. This feature is particularly beneficial for organizations that require multiple self-contained business
units or client organizations within a single LMS installation.

The standard, free Moodle™ LMS distribution does not include support for multi-tenancy. This functionality is
available through [Moodle Workplace™](https://moodle.com/solutions/workplace-learning/), provided by Moodle HQ and
a limited number of certified partners and solution providers, as a closed source commercial product.

**Multi-tenancy plugin** for Moodle™ LMS is an unofficial plugin that, together with a required core patch, introduces
limited multi-tenancy functionality to standard Moodle™ LMS installations. The source code is fully open and free,
governed by the terms of the GPL 3.0 license, with no restrictions on commercial use or distribution.

Note that the current code is still under development and is not suitable for production use.
If you require a stable version for a production environment or commercial support,
please consider [Moodle Workplace™](https://moodle.com/solutions/workplace-learning/) instead.
This plugin is not suitable for existing customers of Open LMS due to the lack of upgrade path.

MuTMS suite of plugins is not associated with Moodle HQ or Open LMS in any way.

## Documentation

See [online documentation](https://github.com/mutms/moodle-tool_mutenancy/wiki) for more information.
